//collects mouse/key events and directly related command parsing

void keyPressed()
{
  if(key==ESC)
  {
    key=0;
    return;
  }
  if(key==CODED){ 
    if(keyCode==RIGHT)g_ofx++;refresh();
    if(keyCode==LEFT)g_ofx--;refresh();
    if(keyCode==UP)g_ofy--;refresh();
    if(keyCode==DOWN)g_ofy++;refresh();        
    if(keyCode==SHIFT)g_shift=true;
    if(platform==MACOSX)
    {
      if(keyCode==COMMAND)g_control=true;
    }
    else
    {
      if(keyCode==CONTROL)g_control=true;
    }  
    return;
  }
  
  //send to the indirect key handling
  //so commands can be invoked elsewhere too
  command(key);
}

void keyReleased()
{
  if(key==CODED){
    if(keyCode==CONTROL)g_control=false;
    if(keyCode==SHIFT)g_shift=false;
    if(platform==MACOSX)
    {
      if(keyCode==COMMAND)
      g_control=false;
    }
      else
    {
      if(keyCode==CONTROL)
      g_control=false;
    }  
  }
}

void mouseDragged()
{
  int msx,msy;
  g_iconx=mouseX;
  g_icony=mouseY;
  if(insidewindow(g_iconx,g_icony)){
      if(g_phase==0){
        g_piconx=g_iconx;g_picony=g_icony; g_iconx=-1;g_icony=-1;
        g_repanel=-2;g_tooltrigger=100;
        return;
      }else{
          g_iconx=-1;g_icony=-1;
          g_piconx=-1;g_picony=-1;        
      }
  }else
  {
    if(g_data['m']==0&&g_data['M']==0){
      msx=g_iconx-(g_windowx);
      msy=g_icony-(g_windowy);
      msx=g_msx-(g_windowx);msy=g_msy-(g_windowy);
   
    }else{
      msx=g_iconx;msy=g_icony;
    }
    
    g_iconx=-1;g_icony=-1;
  }
  g_iconx=-1;g_icony=-1;
  if(mouseButton==CENTER)return;
  if(g_tooltrigger==0)g_tooltrigger=1;
}

boolean insidewindow(int x,int y)
{
  if(x>width-g_hedge||y>height-g_vedge)return true;
  return false;
}

void mousePressed()
{
    int msx,msy;
    g_iconx=mouseX;g_icony=mouseY;
    g_button=mouseButton;g_realbutton=g_button;
 
    if(insidewindow(g_iconx,g_icony)){
        if(g_phase==0){
          g_repanel=-2;g_tooltrigger=100;g_piconx=g_iconx;g_picony=g_icony;
        }else{
          g_iconx=-1;g_icony=-1;
        }
      return;
     }
      else
     {
        g_msx=g_iconx;g_msy=g_icony;
        if(g_data['m']==0&&g_data['M']==0){
          msx=g_iconx-(g_windowx);
          msy=g_icony-(g_windowy);
          msx=g_msx-(g_windowx);msy=g_msy-(g_windowy);
       
        }else{
          msx=g_iconx;msy=g_icony;
        }
            
        if(g_button!=CENTER){
          if(tool()!=5&&tool()!=4)store_undo();
          if(tool()==4){//cut brush results in undo
            if(g_button==RIGHT)store_undo();
          }
        }
      if(g_button==CENTER){g_button=255;g_repanel=-2;
        if(g_shift)g_button=254;
      }
      g_phase=0;
      do_tool(msx,msy,g_button);
      g_phase=1;
   }
}

void mouseReleased()
{
  int swap;
  g_tooltrigger=0;
  g_klikkeri=0;
  if(tool()==8){
    if(g_phase==1){
      g_phase=0;
      rectangle(g_rx,g_ry,g_rx2,g_ry2);
    }
  }
  if(tool()==7){//circle
    if(g_phase==1){
      g_phase=0;
      docircle(g_rx,g_ry,g_rx2,g_ry2);
    }
  }  
  if(tool()==6){
    if(g_phase==1){
      g_phase=0;
      doline(g_rx,g_ry,g_rx2,g_ry2,0);
    }
  }
  
  if(g_data['4']==1){ 
    if(g_phase==1){
      g_phase=0;g_rubbermode=0;refresh();
      g_data['4']=0;g_data['d']=0;
      g_data['r']=0;g_data['R']=0;
      g_data['x']=0;g_data['y']=0;
      g_data['q']=0;g_data['p']=0;
      g_data['t']=0;g_data['n']=0;
      switcher(2);
      if(g_multic==1||g_hzoomer==2){g_rx=g_rx/2;g_rx=g_rx*2;g_rx2=g_rx2/2;g_rx2=g_rx2*2;}
      g_bsourcex=g_rx;g_bsourcey=g_ry;
      g_bsourcex2=g_rx2;g_bsourcey2=g_ry2;
      if(g_bsourcex<=0)g_bsourcex=0;
      if(g_bsourcey<=0)g_bsourcey=0;
      if(g_bsourcex>=X)g_bsourcex=X-1;
      if(g_bsourcey>=Y)g_bsourcex=Y-1;    
      if(g_bsourcex2<=0)g_bsourcex2=0;
      if(g_bsourcey2<=0)g_bsourcey2=0;
      if(g_bsourcex2>=X)g_bsourcex2=X-1;
      if(g_bsourcey2>=Y)g_bsourcey2=Y-1;
      
      set_tool(1);
      g_btype=9;
      g_repanel=-2;
      if(g_button==RIGHT){
        storeparameters();
        g_data['f']=1;g_data['X']=0;g_data['Y']=0;       
        doborx(g_rx,g_ry,g_rx2,g_ry2);
        restoreparameters();
      }
    }
  consistency();
  }
  if(g_phase==1){
     g_phase=0;g_rubbermode=0;refresh(); //needed otherwise the pen color is kept e.g. after right mousebutton
  }
}

void macro_command(int ckey)
{
    //filter out load/save
    if(ckey=='s'||ckey=='S'||ckey=='l'||ckey=='E'||ckey=='w'||ckey=='W'||ckey=='A')return;
    command(ckey);
}

void command(int ckey)
{
  int swap;
  
  //keypresses change g_data[] values directly as 1/0 switches
  //handling these presses "indirectly" adds complexity here
  //but is valuable elsewhere = corresponding icons have shortcuts automatically
  
  if(ckey=='-')ckey='h';
  if(ckey=='+')ckey='H';
  
  if(ckey==TAB){
    if(g_shift==false){
      if(g_britemode==1){
        if(g_realfront==7)g_realfront=-1;
        if(g_realfront==15)g_realfront=7;
      }
      selectcolor(0,g_realfront+1);g_repanel=-2;
    }else{
      if(g_britemode==1){
        if(g_realfront==8)g_realfront=16;
        if(g_realfront==0)g_realfront=8;
      }
      selectcolor(0,g_realfront-1);g_repanel=-2;
    }
  }
      
  //println("ckey+"+ckey);
  if(g_control==true){
    int UNDO=26,
    REDO=25,
    PASTE=22,
    SAVE=19,
    LOAD=15,
    NEW=14,
    COPY=3,
    COPYALT=24,
    ALL=1;
            
    if(platform==MACOSX){
      UNDO=122;
      REDO=25;
      PASTE=22;
      SAVE=115;
      LOAD=111;
      NEW=110;
      COPY=99;
      COPYALT=120;
      ALL=97;        
    }
        
    if(ckey==UNDO){
      ckey='u';
      if(g_shift)ckey='U';
    }//undo
    if(ckey==REDO)ckey='U';
    if(ckey==PASTE)ckey='9';
    if(ckey==SAVE){
      ckey='S';
      if(g_shift)ckey='s';
    }//save
    if(ckey==LOAD)ckey='l';
    if(ckey==NEW)ckey='o';
    if(ckey==COPY||ckey==COPYALT)ckey='4';
    if(ckey==ALL){
      switcher(2);
      g_bsourcex=0;g_bsourcey=0;
      g_bsourcex2=X-1;g_bsourcey2=Y-1;
      ckey='9';
      g_data['p']=0;g_data['x']=0;g_data['y']=0;g_data['q']=0;g_data['z']=0;
      g_phase=0;g_rubbermode=0;
      set_tool(1);
    }
  }
  
  if(ckey>=128&&ckey<=131){
    g_bsize=ckey-128;g_btype=0;
  }
  
  if(ckey>=132&&ckey<=135){
    g_bsize=ckey-132;g_btype=1;
  }
  
  if(ckey==' '||ckey=='.'){
    if(ckey=='.'){g_bsize=0;g_btype=0;g_data['n']=0;}
    ckey='3';
    if(ckey==' '){}    
  }
    
  if(ckey>=0&&ckey<=255){
    //g_depressed[ckey-48]=10;
  }
    
  if(ckey==','){
      g_repanel=-2;
      do_tool(mouseX,mouseY,255);
      do_tool(g_mx,g_my,255);
      return;
  }
  
  if(ckey=='v'){
    g_repanel=-2;
   // do_tool(mouseX,mouseY,254);
    do_tool(g_mx,g_my,254);
    return;
  }
  
  if(ckey=='['){
      fixed_raster_command('x');
      message("R.OFFSET "+str(g_raster_offset_x)+"."+str(g_raster_offset_y));
      g_repanel=-2;
      return;
  }
  if(ckey==']'){
      fixed_raster_command('y');
      message("R.OFFSET "+str(g_raster_offset_x)+"."+str(g_raster_offset_y));
      g_repanel=-2;
      return;
  }  
  if(ckey=='('){
      fixed_raster_command('p');
      message("RASTER "+str(g_raster_no)+"/9|[=PREV|]=NEXT");
      g_repanel=-2;
      return;
  }
  
  if(ckey==')'){
      fixed_raster_command('n');
      message("RASTER "+str(g_raster_no)+"/9|[=PREV|]=NEXT");
      g_repanel=-2;
      return;
  }
  
  if(ckey=='>'){
    selectcolor(0,g_rgb[int(g_map[1])]);
    message("Current=Back");    
    g_repanel=-2;
    return;
  }
  if(ckey=='<'){
    g_repanel=-2;
    swap=g_farge;
    g_farge=g_backg;g_ofarge=g_farge;
    g_backg=swap;
    g_realfront=byte(g_farge);
    g_realback=byte(g_backg);
  }
  
  if(ckey=='0'){
      if(g_data['m']==0&&g_data['M']==0){
        if(tool()!=0){
          g_prevtool=tool();
        }
      }else
      {
        ckey='m';
      }
   }
      
   if(ckey=='9'){
     g_repanel=-2;
     g_btype=9;
     return;
   }
   if(ckey>='0'&&ckey<='8'){
     g_repanel=-2;
     set_tool(ckey-48);
     g_phase=0;g_rubbermode=0;
     g_rx=-1;g_ry=-1;g_rx2=-1;g_ry2=-1;
     if(g_data[ckey]>1)g_data[ckey]=0;
     if(ckey=='4'){
       g_data['x']=0;
       g_data['y']=0;
       g_data['h']=0;
       g_data['q']=0;
       g_data['t']=0;
       g_data['n']=0;
     }
  }
  
  if(ckey>='A'&&ckey<='Z'){
    g_repanel=-2;
    g_data[ckey]++;
    if(g_data[ckey]>1)g_data[ckey]=0;
    
    if(ckey=='Q'){g_repanel=-2;g_msgctr=0;help('B');g_msgctr=50;}
    if(ckey=='G'){
      g_data['G']=0;
      switch(g_gridx){
        case 8:
          g_gridx=16;g_gridy=16;
        break;
        case 16:
          g_gridx=4;g_gridy=4;
        break;
        case 4:
          g_gridx=8;g_gridy=8;
        break;
      }
      g_repanel=-2;g_msgctr=0;help('g');g_msgctr=50;
    }
    
    if(ckey=='I'){
       // message("sprites shitted");
        //poopsprites();
       // poopspecialsprites();
    }
    
    if(ckey=='T'){
     //   message("chars shitted");
      //  poopultimachars();
//        poopsprites();
    }
    if(ckey=='G'){
       if(g_data['g']==0)g_data['g']=1;
    }
    if(g_data['M']==0)g_boxreconstruct=2;
    
    if(g_data['M']==1){
      if(ckey=='M'){
        g_ofx=g_storedcoordx/8-magx()/2;
        g_ofy=g_storedcoordy/8-magy()/2;
        g_data['m']=0;message("Super|Magnify");
        if(tool()==0){set_tool(g_prevtool);g_phase=0;g_rubbermode=0;}
      }
    }
    if(g_data['B']==1){
      g_data['B']=0;
      if(machine!=MSX){
        store_undo();
        g_map[0]=byte(zxcolor(g_farge));
        sussborder();
        message("Set border");
      }
      if(machine==MSX){
        g_data['C']=1;
      }
    }
    if(g_data['C']==1){
      g_data['C']=0;
      if(int(g_map[1])!=255){
        store_undo();
        if(machine==PLUS4M&&g_farge==g_map[2]){
            message("1st and 2nd|can't be|same");
            refresh();
            return;          
        }
        g_map[1]=byte(g_farge);
        
        if(machine==MSX){g_map[0]=byte(g_farge);sussborder();}
        message("Set back|color");
       }
    }
    if(g_data['V']==1){
      g_data['V']=0;
      if(int(g_map[1])!=255){
        store_undo();
        if(machine==PLUS4M&&g_farge==g_map[1]){
          message("1st and 2nd|can't be|same");
          refresh();
          return;
        }
          g_map[2]=byte(g_farge);
        message("Set 2nd|back color");
       }
    }      
    if(g_data['W']==1){
      g_data['W']=0; 
      if(g_formatextension!=""){
        gui=true;exportfmt=true;
        message("Format|export");
      }
        else
      {
        message("None for|"+g_name);
      }
    }
    if(g_data['N']==1){
        g_data['N']=0;
        int i=g_animspeed;
        i++;
        if(i>3)i=0;
        g_animspeed=i;
        message("Playbrush|speed="+g_animspeed);
      }
    refresh();
  }
  
  if(ckey>='a'&&ckey<='z'){
    g_repanel=-2;
    g_data[ckey]++;
    if(g_data[ckey]>1){
      if(ckey=='m'||ckey=='M'){g_boxreconstruct=2;g_data['M']=0;g_data['m']=0;}
      g_data[ckey]=0;
    }
    
    if(g_data['t']==1){
      if(ckey=='t')message("Tile mode");
    }
    
    if(ckey=='n'){if(g_data['n']==1){
      switcher(2);infersize();
      if(g_data['n']==1){
        command('1');command('9');
        g_data['p']=0;g_data['x']=0;g_data['y']=0;
        g_data['q']=0;g_data['t']=0;
        }
      }
    }    
    
    if(g_data['i']==1){
      g_data['i']=0;
      selectcolor(0,nextluminance(g_farge,1));
    }
    if(g_data['k']==1){
      g_data['k']=0;
      selectcolor(0,nextluminance(g_farge,-1));
    }
    if(g_data['d']==0){
      if(ckey=='d')consistency();
    }
    if(g_data['z']==1){
      g_data['z']=0;
      int orient;
      orient=g_data['x']*100+g_data['y']*10+g_data['q'];
      if(orient==0){
        g_data['x']=0;g_data['y']=0;g_data['q']=1;
      }
      if(orient==1){
        g_data['x']=1;g_data['y']=1;g_data['q']=0;
      }  
      if(orient==110){
        g_data['x']=1;g_data['y']=1;g_data['q']=1;
      } 
      if(orient==111){
        g_data['x']=0;g_data['y']=0;g_data['q']=0;
      }
      if(orient==100){
        g_data['x']=0;g_data['y']=1;g_data['q']=1;
      }
      if(orient==11){
        g_data['x']=0;g_data['y']=1;g_data['q']=0;
      }  
      if(orient==10){
        g_data['x']=1;g_data['y']=0;g_data['q']=1;
      }
      if(orient==101){
        g_data['x']=1;g_data['y']=0;g_data['q']=0;
      }      
      message("Rotate|brush");
    }    

    if(ckey=='m'){
      if(g_data['M']==1){
        g_data['M']=0;g_data['m']=0;ckey=0;g_boxreconstruct=2;
      }
      g_data['M']=0;        
    }
    if(g_data['m']==1){
      if(ckey=='m'){
       g_data['M']=0;
       int moux,mouy;
       moux=g_mx/g_wzoom;mouy=g_my/g_wzoom;
       g_ofx=moux/(8)-magx()/2;
       g_ofy=mouy/(8)-magy()/2;
       message("Magnify");
       if(tool()==0){set_tool(g_prevtool);g_phase=0;g_rubbermode=0;}
      }
    }
    refresh();
  }
  
  if(g_data['J']==1){
    g_data['J']=0;g_data['j']=0;
    spare();
    store_undo();
    switch(g_spare){
      case 0:
        message("Copied to|Front");
        switcher(4);
      break;
      case 1:
        message("Copied to|Spare");
        switcher(4);        
      break;
    }
    spare(); 
  }
  
  if(g_data['j']==1){
    g_data['j']=0;
    if(g_spare==0)message("Spare Page");
    if(g_spare==1)message("Front Page");
    spare();
    makecolor(259,g_r[g_map[0]],g_g[g_map[0]],g_b[g_map[0]]);
    g_boxreconstruct=2;
  }
  if(g_data['E']==1){
    g_data['E']=0;
    message("Source|export");    
    gui=true;exporttxt=true;
    //machine_export(1);  
  }
  if(g_data['A']==1){
    g_data['A']=0;
    message("Executable|export");   
    gui=true;exportemu=true;
    //machine_export(0);  
  }
  if(g_data['w']==1){
    g_data['w']=0;
    gui=true;importfmt=true;
  }   
  if(g_data['O']==1){
    g_data['O']=0;
    store_undo();
    for(int xx=0;xx<X*Y;xx++){
        g_map[1024+xx]=0;
    }    
    for(int xx=0;xx<X;xx++){
      for(int yy=0;yy<Y;yy++){
        g_farge=g_backg;
        makepoint(xx,yy);
        g_farge=g_ofarge;      
      }
    }
  }
  
  if(g_data['o']==1){
    g_data['o']=0;
    message("Clear all");
    store_undo();
    storeparameters();
    g_data['r']=0;g_data['R']=0;g_data['d']=0;g_data['t']=0;
           
    for(int xx=0;xx<X*Y;xx++){
        g_map[1024+xx]=0;
    }
 
    for(int xx=0;xx<X;xx++){
      for(int yy=0;yy<Y;yy++){
        g_farge=g_backg;
        makepoint(xx,yy);
        g_farge=g_ofarge;      
      }
    }
    
    restoreparameters();
  }
  
  if(g_data['e']==1){
    g_data['e']=0;
  }
 
  if(g_data['h']==1){
    g_data['h']=0;
    g_bsize--;if(g_bsize<0)g_bsize=0;
    g_msgctr=-2;
    help('h');  
  }
  if(g_data['H']==1){
    g_data['H']=0;
    g_bsize++;if(g_bsize>10)g_bsize=10;
    g_msgctr=-2;
    help('h');
  }  
  if(g_data['u']==1){
    g_data['u']=0;
    message("Undo");
    restore_undo();refresh();g_boxreconstruct=2;
  }
  if(g_data['U']==1){
    g_data['U']=0;
    message("Redo");
    redo_undo();refresh();
  }
  if(g_data['S']==1){
    g_data['S']=0;
    if(g_spare==0)elename=filename;
    if(g_spare==1)elename=sfilename;
    
    if(elename.length()>3){
    
      if(g_iconmode==0){
        if(g_spare==0){
          message("Page saved");
          store(elename);
        }
        if(g_spare==1){
          message("Spare page|saved");
          store(elename);
        }
      }
    
    }
      else
    {
      message("No filename!");
      message("*");
      g_data['S']=0;g_data['s']=0;
    }
  }
  
  if(machine==SPECTRUM&&debugger==1){
      if(g_data['i']==1){
          g_data['i']=0;
          if(g_iconmode==0){
            message("Icons|not loaded!");
          }
            else
          {
            message("Store|icons");
            store("icons.bin");
          }
      }
      if(g_data['I']==1){
        g_data['I']=0;
        store_undo();
        message("Restore|icons");
        restore("icons.bin");
        refresh();
        g_iconmode=1;
      }  
  }
  if(g_data['l']==1){
    g_data['l']=0;
    gui=true;fileselect=true;
  }
  if(g_data['s']==1){
    g_data['s']=0;
    gui=true;saveas=true;
  }  
  if(g_data['L']==1){
    g_data['L']=0;
  }
}


