// machine definitions
// source writer and other export/import functions
// the machine_export() makes use of bitmapexport() and colorexport() below
// remember hexdump -C !

String g_formatname, g_formatextension;

int g_headpos;
int[] g_grids = new int[16];
int OLD=0;
int NEW=1;
int g_gridmode=OLD;

int bitti(int inp)
{
    if(inp==0)return 0;
    return 1;
}

int qbitti(int inp)
{
    if(inp==10)return 1;
    return 0;
}

void poopspecialsprites()
{
    int x,y,xs,xx,yy,mup,row;
    int b7,b6,b5,b4,b3,b2,b1,b0,val;
    mup=0;
        for(row=0;row<=1;row++){
        for(x=0;x<=8;x++)
        {
            for(y=0;y<=20;y++){
            for(xs=0;xs<=2;xs++){
                if(mup>0){print(",");}
                  mup=1;
                  xx=x*24+xs*8;
                  if(row==1&&x==7){xx=xx+24;}
                  if(x==8){xx=xx+24;}
                  yy=row*48+2+y;
                  b7=qbitti(easygetcolor(xx,yy));
                  b6=qbitti(easygetcolor(xx+1,yy));
                  b5=qbitti(easygetcolor(xx+2,yy));
                  b4=qbitti(easygetcolor(xx+3,yy));
                  b3=qbitti(easygetcolor(xx+4,yy));
                  b2=qbitti(easygetcolor(xx+5,yy));
                  b1=qbitti(easygetcolor(xx+6,yy));
                  b0=qbitti(easygetcolor(xx+7,yy));
                  val=b7*128+b6*64+b5*32+b4*16+b3*8+b2*4+b1*2+b0;
                  print(str(val));
            }
            
        }print(",0");  println("");
        for(y=0;y<=20;y++){
            for(xs=0;xs<=2;xs++){
                if(mup>0){print(",");}
                  mup=1;
                  xx=x*24+xs*8;yy=row*48+y*2;
                  if(x==8){xx=xx+24;}
                    b7=bitti(easygetcolor(xx,yy));
                    b6=bitti(easygetcolor(xx+1,yy));
                    b5=bitti(easygetcolor(xx+2,yy));
                    b4=bitti(easygetcolor(xx+3,yy));
                    b3=bitti(easygetcolor(xx+4,yy));
                    b2=bitti(easygetcolor(xx+5,yy));
                    b1=bitti(easygetcolor(xx+6,yy));
                    b0=bitti(easygetcolor(xx+7,yy));                 
                  if(x==7){xx=x*24+xs*16;yy=row*48+y;
                    b7=bitti(easygetcolor(xx,yy));
                    b6=bitti(easygetcolor(xx+2,yy));
                    b5=bitti(easygetcolor(xx+4,yy));
                    b4=bitti(easygetcolor(xx+6,yy));
                    b3=bitti(easygetcolor(xx+8,yy));
                    b2=bitti(easygetcolor(xx+10,yy));
                    b1=bitti(easygetcolor(xx+12,yy));
                    b0=bitti(easygetcolor(xx+14,yy));
                  }
                  val=b7*128+b6*64+b5*32+b4*16+b3*8+b2*4+b1*2+b0;
                  print(str(val));
            }
          
        }print(",0");  println();
        }
    }
}

void poopultimachars()
{
    PImage poutput;
    poutput=createImage(256*8,8,RGB);
    int x,y,rr,gg,bb,xx,yy,bx,by;
    int ac,box,boy;
    int b7,b6,b5,b4,b3,b2,b1,b0,val;
    int blok,muna;
    color c;
    
    blok=0;
    PrintWriter f=createWriter("/home/tero/code/c64/ultima/graffa.s");
    f.println(".global _graffa");
    f.println("_graffa:");
    f.println();
    //print("unsigned char graffa[]={");
    for(y=0;y<=5;y++){
      muna=0;
      if(blok<=63){
        f.print(".byte ");}
    for(x=0;x<=19;x++)
    {
      if(blok<=63){
      for(boy=0;boy<=1;boy++){
        for(box=0;box<=1;box++){
          
        for(yy=0;yy<=7;yy++){
          bx=x*16+box*8;by=(y*16+boy*8+yy);
      
            b7=0;b6=0;b5=0;b4=0;b3=0;b2=0;b1=0;b0=0;
            ac=easygetcolor(bx,by);
            if(ac==0){b7=0;b6=0;}
            if(ac==15){b7=1;b6=0;}
            if(ac==2){b7=0;b6=1;}
            if(ac==7){b7=1;b6=1;}
            ac=easygetcolor(bx+2,by);
            if(ac==0){b5=0;b4=0;}
            if(ac==15){b5=1;b4=0;}
            if(ac==2){b5=0;b4=1;}
            if(ac==7){b5=1;b4=1;}
            ac=easygetcolor(bx+4,by);
            if(ac==0){b3=0;b2=0;}
            if(ac==15){b3=1;b2=0;}
            if(ac==2){b3=0;b2=1;}
            if(ac==7){b3=1;b2=1;}
            ac=easygetcolor(bx+6,by);
            if(ac==0){b1=0;b0=0;}
            if(ac==15){b1=1;b0=0;}
            if(ac==2){b1=0;b0=1;}
            if(ac==7){b1=1;b0=1;}            
            val=b7*128+b6*64+b5*32+b4*16+b3*8+b2*4+b1*2+b0;
            f.print(str(val));muna++;
            if(muna<640){f.print(",");}
            
          for(xx=0;xx<=7;xx++){
             
            rr=g_r[easygetcolor(x*8+xx,y*8+yy)];  
            gg=g_g[easygetcolor(x*8+xx,y*8+yy)];  
            bb=g_b[easygetcolor(x*8+xx,y*8+yy)];
            c=color(rr,gg,bb);
            poutput.set(x*8+y*(16*8)+xx,yy,c);
          }
        }
        }
      }
      }
      }
      f.println();
      blok++;
    }
        f.flush();
    f.close();
    //poutput.save("/home/tero/sketchbook/petscii/data/petscii-c64x.png");
}

void poopchars()
{
    PImage poutput;
    poutput=createImage(256*8,8,RGB);
    int x,y,rr,gg,bb,xx,yy,bx,by;
    int ac;
    int b7,b6,b5,b4,b3,b2,b1,b0,val;
    color c;
    
    PrintWriter f=createWriter("/home/tero/code/c64/newgame/graffa.s");
    f.println(".global _graffa");
    f.println("_graffa:");
    f.println();
    //print("unsigned char graffa[]={");
      for(y=0;y<=15;y++){
        f.print(".byte ");
    for(x=0;x<=15;x++)
    {
        for(yy=0;yy<=7;yy++){
          bx=x*8;by=(y*8+yy);
      
            b7=0;b6=0;b5=0;b4=0;b3=0;b2=0;b1=0;b0=0;
            ac=easygetcolor(bx,by);
            if(ac==0){b7=0;b6=0;}
            if(ac==15){b7=1;b6=0;}
            if(ac==11){b7=0;b6=1;}
            if(ac==5){b7=1;b6=1;}
            ac=easygetcolor(bx+2,by);
            if(ac==0){b5=0;b4=0;}
            if(ac==15){b5=1;b4=0;}
            if(ac==11){b5=0;b4=1;}
            if(ac==5){b5=1;b4=1;}
            ac=easygetcolor(bx+4,by);
            if(ac==0){b3=0;b2=0;}
            if(ac==15){b3=1;b2=0;}
            if(ac==11){b3=0;b2=1;}
            if(ac==5){b3=1;b2=1;}
            ac=easygetcolor(bx+6,by);
            if(ac==0){b1=0;b0=0;}
            if(ac==15){b1=1;b0=0;}
            if(ac==11){b1=0;b0=1;}
            if(ac==5){b1=1;b0=1;}            
            val=b7*128+b6*64+b5*32+b4*16+b3*8+b2*4+b1*2+b0;
            f.print(str(val));
            if(x<15||yy<7){f.print(",");}
          for(xx=0;xx<=7;xx++){
             
            rr=g_r[easygetcolor(x*8+xx,y*8+yy)];  
            gg=g_g[easygetcolor(x*8+xx,y*8+yy)];  
            bb=g_b[easygetcolor(x*8+xx,y*8+yy)];
            c=color(rr,gg,bb);
            poutput.set(x*8+y*(16*8)+xx,yy,c);
          }
        }
      }
      f.println();
    }
        f.flush();
    f.close();
    poutput.save("/home/tero/sketchbook/petscii/data/petscii-c64x.png");
}

void poopsprites()
{
    int x,y,xs,xx,yy,mup;
    int b7,b6,b5,b4,b3,b2,b1,b0,val;
    mup=0;
        for(x=0;x<=7;x++)
        {
            for(y=0;y<=15;y++){
            for(xs=0;xs<=1;xs++){
                if(mup>0){print(",");}
                mup=1;
            xx=x*16+xs*8;
            yy=y;
            b7=bitti(easygetcolor(xx,yy));
            b6=bitti(easygetcolor(xx+1,yy));
            b5=bitti(easygetcolor(xx+2,yy));
            b4=bitti(easygetcolor(xx+3,yy));
            b3=bitti(easygetcolor(xx+4,yy));
            b2=bitti(easygetcolor(xx+5,yy));
            b1=bitti(easygetcolor(xx+6,yy));
            b0=bitti(easygetcolor(xx+7,yy));
            val=b7*128+b6*64+b5*32+b4*16+b3*8+b2*4+b1*2+b0;
            print(str(val));
            }
            
        }println();
    }
    
}

void pushbyte(int ad,int head)
{
  g_map[ad]=byte((g_template[head]&128)>>7);
  g_map[ad+1]=byte((g_template[head]&64)>>6);             
  g_map[ad+2]=byte((g_template[head]&32)>>5);
  g_map[ad+3]=byte((g_template[head]&16)>>4);  
  g_map[ad+4]=byte((g_template[head]&8)>>3);
  g_map[ad+5]=byte((g_template[head]&4)>>2);             
  g_map[ad+6]=byte((g_template[head]&2)>>1);
  g_map[ad+7]=byte(g_template[head]&1); 
}
                    
void format_import(String fname)
{
    int x, y, x2, y2, y3, head, xx, yy, yp, ad, valu;
    int p1, p2, p3;
    head=0;
    
    if (machine==SPECTRUM) //SCR=SCREEN$
    {
        // 32*24*8 bytes of bitmap
        // 32*24 bytes of attributes
        import_program(fname);
        if(g_template.length<6912){message("FALSE");return;}
        for (y=0; y<=2; y++) {
            for (y2=0; y2<=7; y2++) {
                for (yy=0; yy<=7; yy++) {
                    for (x=0; x<=31; x++) {
                        yp=y*64+yy*8+y2;
                        ad=1024+yp*256+x*8;
                        pushbyte(ad,head);
                        head++;
                    }
                }
            }
        }
        for (y=0; y<=23; y++) {
            for (x=0; x<=31; x++) {
                ad=65536+x+y*(32*8);
                valu=g_template[head];
                int ink=valu&7;
                int pap=valu&56;
                pap=pap>>3;
                int bri=valu&64;
                bri=bri>>6;
                ink=ink+bri*8;
                pap=pap+bri*8;
                if (pap==8) {
                    pap=0;
                }
                for (y2=0; y2<=7; y2++) {
                    g_map[ad+y2*32]=byte(ink);
                    g_map[ad+y2*32+MX*MY*8]=byte(pap);
                }
                head++;
            }
        }
    }

    if (machine==C64) {
        //0x0002->bitmap
        //0x1f42->colormap
        //0x232a=border (take the lower nybble)
        import_program(fname); //art studio
        if(g_template.length<9006){message("FALSE");return;}
        if (g_template.length>=0x232a) {
            g_map[0]=byte(g_template[0x232a]&15);
        }
        for (y=0; y<25; y++) {
            for (x=0; x<40; x++) {
                for (y2=0; y2<=7; y2++) {
                    head=2+x*8+y*(40*8)+y2;
                    ad=1024+x*8+y*(320*8)+y2*320;
                    pushbyte(ad,head);
                    p1=g_template[0x1f42+x+y*40]&15;
                    p2=g_template[0x1f42+x+y*40]&240;
                    p2=p2>>4;             
                    g_map[65536+x+y*40*8+y2*40]=byte(p2);
                    g_map[65536+MX*MY*8+x+y*40*8+y2*40]=byte(p1);
                }
            }
        }
    }
    
    if (machine==PLUS4) { // Botticelli
        //g.hires.prg = botticelli
        //2 - luminance 40*25
        //1026 - colors 40*25
        //2050 - bitmappi 40*25*8    
        import_program(fname); 
        
        if(g_template.length<10050){message("FALSE");return;}
        int l1,l2;
        for (y=0; y<25; y++) {
            for (x=0; x<40; x++) {
                for (y2=0; y2<=7; y2++) {
                    head=2050+x*8+y*(40*8)+y2;                    
                    ad=1024+x*8+y*(320*8)+y2*320;
                    pushbyte(ad,head);

                    p1=g_template[1026+x+y*40]&15;
                    p2=g_template[1026+x+y*40]&240;
                    p2=p2>>4;
                    l1=g_template[2+x+y*40]&15;
                    l2=g_template[2+x+y*40]&240;
                    l2=l2>>4;                    
                    g_map[65536+x+y*40*8+y2*40]=byte(convertlumi(l1,p2));
                    g_map[65536+MX*MY*8+x+y*40*8+y2*40]=byte(convertlumi(l2,p1));
                }
            }
        }
                 
    }
    
    if (machine==PLUS4M) { // Multi Botticelli
        //m.multi.prg = multi botticelli
        //2- lumins 40*25
        //1024 - bäkki1
        //1025 - bäkki2
        //1026 - colors 40*25
        //2050 - bitmap 40*25*8    
        import_program(fname);
        
        if(g_template.length<10050){message("FALSE");return;}
        int l1,l2;
        for (y=0; y<25; y++) {
            for (x=0; x<40; x++) {
                for (y2=0; y2<=7; y2++) {
                    head=2050+x*8+y*(40*8)+y2;                    
                    ad=1024+x*8+y*(320*8)+y2*320;
                    pushbyte(ad,head);

                    p1=g_template[1026+x+y*40]&15;
                    p2=g_template[1026+x+y*40]&240;
                    p2=p2>>4;
                    l1=g_template[2+x+y*40]&15;
                    l2=g_template[2+x+y*40]&240;
                    l2=l2>>4;                    
                    g_map[65536+x+y*40+1000]=byte(convertlumi(l1,p2));
                    g_map[65536+x+y*40+0000]=byte(convertlumi(l2,p1));
                }
            }
        }
      p1=int(g_template[1025])&240;
      l1=int(g_template[1025])&15;
      p1=p1>>4;           
      g_map[1]=byte(convertlumi(l1,p1));
      p1=int(g_template[1024])&240;
      l1=int(g_template[1024])&15;
      p1=p1>>4;       
      g_map[2]=byte(convertlumi(l1,p1));
    }
    
    if (machine==C64M) {//advanced art studio      
        //adv. art studio (=multicolor) 10018 bytes
        //0x0002 bitmap (40*25*8)
        //0x1f42 colors1 (40*25)
        //0x232a border
        //0x232b background
        //0x233a colors2 (40*25)
        import_program(fname); 
        if(g_template.length<10018){message("FALSE");return;}
        for (y=0; y<25; y++) {
            for (x=0; x<40; x++) {
                for (y2=0; y2<8; y2++) {
                    head=2+x*8+y*(40*8)+y2;
                    ad=1024+x*8+y*(320*8)+y2*320;
                    pushbyte(ad,head);

                    p1=g_template[0x1f42+x+y*40]&15;
                    p2=g_template[0x1f42+x+y*40]&240;
                    p2=p2>>4;
                    p3=g_template[0x233a+x+y*40]&15;
                    g_map[65536+x+y*40]=byte(p1);
                    g_map[65536+x+y*40+1000]=byte(p2);
                    g_map[65536+x+y*40+2000]=byte(p3);
                    g_map[0]=byte(g_template[0x232a]&15);//bord
                    g_map[1]=byte(g_template[0x232b]&15);//baku
                }
            }
        }
    }

    if(machine==MSX){        // sc2
        // 7=bitmap 32*24*8
        // 7+(32*24*8)=colormap 32*24
        import_program(fname);
        if(g_template.length<14343){message("FALSE");return;}
            for (y=0; y<24; y++) {
              for (x=0; x<32; x++) {
                for (y2=0; y2<=7; y2++) {
                    head=7+x*8+y*(32*8)+y2;
                    ad=1024+x*8+y*(256*8)+y2*256;
                    pushbyte(ad,head);
                    p1=g_template[(8199)+x*8+((y*8*32)+y2)]&15;
                    p2=g_template[(8199)+x*8+((y*8*32)+y2)]&240;                 
                    p2=p2>>4;             
                    if(p1==0){p1=1;}
                    if(p2==0){p2=1;}
                    g_map[65536+x+y*32*8+y2*32]=byte(p2);
                    g_map[65536+MX*MY*8+x+y*32*8+y2*32]=byte(p1);
                }
            }
        }    
    }
    
    if(machine==CPC){ // a studio?
        import_program(fname);
        message("Not|Working");
    }    
    
    consistency();
    refresh();
    g_boxreconstruct=2;
}

void format_export(String fname)
{
    int val1, val2, val3;
    int y, y2, yy, x, yp, xp, ad, valu, valu2, bri;

    if (machine==PLUS4) {// botticelli hires
        load_template("g.hires.prg");
        set_head(0x02);
        colorexport(40, 25, 65536, 5);//lumis
        set_head(1026);
        colorexport(40, 25, 65536, 4);//colors  
        set_head(2050);
        bitmapexport(40, 25);
        export_program(fname);
    }
    
    if (machine==PLUS4M) {// multi botticelli multicolor
        load_template("m.multi.prg");
        val2=getpluscolor(int(g_map[1]));
        val1=getplusluminance(int(g_map[1]));
        val3=val2*16+val1;
        set_head(1025);
        write_head(val3);
        val2=getpluscolor(int(g_map[2]));
        val1=getplusluminance(int(g_map[2]));
        val3=val2*16+val1;
        set_head(1024);
        write_head(val3);
        set_head(1026);
        colorexport(40, 25, 65536, 6);//colors
        set_head(2);
        colorexport(40, 25, 65536, 7);//lumis 
        set_head(2050);
        bitmapexport(40, 25);
        export_program(fname);
    }
    
    if (machine==C64) {
        load_template("hires.art");
        set_head(2);
        bitmapexport(40, 25);
        set_head(0x1f42);
        colorexport(40, 25, 65536, 0);
        set_head(0x232a);
        write_head(int(g_map[0]));
        export_program(fname);
    }
    
    if (machine==C64M) {
        if(fname.indexOf(".kla")==-1){
          load_template("multic.ocp");
          set_head(2);
          bitmapexport(40, 25);
          set_head(0x1f42);
          colorexport(40, 25, 65536, 1);
          set_head(0x233a);
          colorexport(40, 25, 65536+2000, 2);
          set_head(0x232a);
          write_head(int(g_map[0]));
          set_head(0x232b);
          write_head(int(g_map[1]));
          export_program(fname);
        }
        
        //koala
        
        if(fname.indexOf(".kla")>=0){
          load_template("multic.kla");
          set_head(2);
          bitmapexport(40,25);
          set_head(0x1f42);
          colorexport(40,25,65536,1);
          set_head(0x232a);
          colorexport(40,25,65536+2000,2);
          set_head(0x2712);
          write_head(int(g_map[1]&15));
          export_program(fname);
        }
        
      }

    if (machine==MSX) {
        load_template("msx-screen2.sc2");
        set_head(7); 
        bitmapexport(32, 24);
        set_head(7+(32*24*8)+768+1280);
        colorexport(32, 24, 65536, 3);//there's an exception for msx-style
        export_program(fname);
    } 

    if (machine==SPECTRUM)
    {
        load_template("zx-screen.scr");
        set_head(0);
        for (y=0; y<=2; y++) {
            for (y2=0; y2<=7; y2++) {
                for (yy=0; yy<=7; yy++) {
                    for (x=0; x<=31; x++) {
                        yp=y*64+yy*8+y2;
                        ad=1024+yp*256+x*8;
                        valu=g_map[ad+0]*128+g_map[ad+1]*64+g_map[ad+2]*32+g_map[ad+3]*16+g_map[ad+4]*8+g_map[ad+5]*4+g_map[ad+6]*2+g_map[ad+7]*1;  
                        write_head(int(valu));
                    }
                }
            }
        }
        for (y=0; y<=23; y++) {
            for (x=0; x<=31; x++) {
                ad=65536+x+y*256;
                valu=int(g_map[ad]);
                valu2=int(g_map[ad+MX*MY*8]);
                bri=0;
                if (valu>=8) {
                    bri=1;
                    valu=valu-8;
                    valu2=valu2-8;
                    if (valu2<=0) {
                        valu2=0;
                    }
                }
                if (bri==1) {
                    valu=valu+64;
                }
                write_head(int(valu+valu2*8));
            }
        }
        export_program(fname);
    }
}

void machine_export(String fname, int sorsa)
{
    int yy, xx, x, y2, y, checksum;
    int xp, yp;
    int valu, valu2;
    int val1, val2, val3;
    int ad, by;
    int bri, skyp;
    g_sorsaa=sorsa;//aargh another global

    if (sorsa==1) {
        exwriter=createWriter(fname);
    }

    // any common text headers
    by=0;
    skyp=0;
    outputter(";machine="+str(machine)+" ("+g_name+")", true);

    if (machine==C64) { //C64 HIRES

        load_template("c64show.prg");
        set_head(0X0227);
        bitmapexport(40, 25);
        set_head(0X2167);
        write_head(g_map[0]);//=border
        set_head(0X2168);
        write_head(g_map[1]);//=background mutta ei tarvita
        set_head(0X2169);
        outputter("; The following two first values are border and background", true);
        colorexport(40, 25, 65536, 0);
        export_program(fname);

        //c64show.prg
        //offsets
        //0x0227->bitmappi (40x25 x 8 bytee)
        //0x2167:borderi väri
        //0x2169->värikartta (40x25 bytee, nyppelit foreg/backg)
    }

    if (machine==C64M) { //C64 MULTICOLOR

        load_template("c64mshow.prg");
        set_head(0x0239);
        bitmapexport(40, 25);

        // first color information
        set_head(0x2179);
        write_head(g_map[0]);
        set_head(0x217A);
        write_head(g_map[1]);
        set_head(0x217B);
        outputter("; The following two first values are border and background", true);
        colorexport(40, 25, 65536, 1);

        // second color information
        set_head(0x2563);
        outputter("; The following goes to $D800 onwards", true);  
        colorexport(40, 25, 65536+2000, 2);
        export_program(fname);

        //c64 multicolor
        //offsets
        //0x0239->bitmappi (40x25 x 8 bytee)
        //0x2179:borderi väri
        //0x217A:bäkkis väri
        //0x217B->värikartta 1 (40x25 bytee, nyppelit foreg/backg ilmeisesti)
        //0x2563->värikartta 2 (40x25 bytee, nyppeli 3-väri nepan osoitteessa $d800-)
    }

    if (machine==PLUS4M) { //PLUS4 MULTICOLOR
        load_template("showpfourm.prg");
        outputter("  .global _bitmap", true);
        outputter("  .global _color1", true);
        outputter("  .global _color2", true);
        outputter("  .global _border", true);
        outputter("  .global _back1", true);
        outputter("  .global _back2", true);
        outputter("_bitmap:", true);
        set_head(0x013e);
        bitmapexport(40, 25);
        outputter("_border:", true);
        val1=getpluscolor(int(g_map[0]));
        val2=getplusluminance(int(g_map[0]));
        val3=val2*16+val1;
        set_head(0x207e);
        write_head(val3);
        outputter("  .byte "+val3, true);
        outputter("_back1:", true);
        val1=getpluscolor(int(g_map[1]));
        val2=getplusluminance(int(g_map[1]));
        val3=val2*16+val1;
        set_head(0x207f);
        write_head(val3);
        outputter("  .byte "+val3, true);
        outputter("_back2:", true);
        val1=getpluscolor(int(g_map[2]));
        val2=getplusluminance(int(g_map[2]));
        val3=val2*16+val1;
        set_head(0x2080);
        write_head(val3);
        outputter("  .byte "+val3, true);
        outputter("_color1:", true);
        set_head(0x2081);
        colorexport(40, 25, 65536, 6);
        outputter("_color2:", true);
        set_head(0x2469);
        colorexport(40, 25, 65536, 7);
        export_program(fname);
        //plus4 multic
        //0x013e bitmap (40 x 25 x 8)
        //0x207e border
        //0x207f background 1
        //0x2080 background 2
        //0x2081 colors (40 x 25)
        //0x2469 luminance (40 x 25)
    }

    if (machine==PLUS4) {// Plus 4 hires
        load_template("showpfour.prg");
        outputter("  .global _bitmap", true);
        outputter("  .global _color", true);
        outputter("  .global _lumi", true);
        outputter("  .global _border", true);
        outputter("_bitmap:", true);
        set_head(0x0137);
        bitmapexport(40, 25);
        val1=getpluscolor(int(g_map[0]));
        val2=getplusluminance(int(g_map[0]));
        val3=val2*16+val1;
        set_head(0x2077);
        write_head(val3); //border

        set_head(0x2078);
        colorexport(40, 25, 65536, 4);//colors
        set_head(0x2460);
        colorexport(40, 25, 65536, 5);//lumis
        export_program(fname);
        //plus4 hires
        //0x0137   bitmap (40 x 25 x 8)
        //0x2077   borderi
        //0x2078   colors (40 x 25)
        //0x2460   luminance (40 x 25)
    }

    if (machine==MSX) { // MSX
        load_template("msxshow.com");
        set_head(0x00f9);
        outputter(char(9)+".globl _nimi1,_nimi2", true);
        outputter(char(9)+".area _CODE", true);
        outputter("_nimi1:", true);
        bitmapexport(32, 24);
        set_head(0x18f9);
        //write_head(g_map[1]); //backg
        //outputter("; The first following value is background", true);
        outputter("_nimi2:", true);
        colorexport(32, 24, 65536, 3);//there's an exception for msx-style
        export_program(fname);
        //msx comm
        //0x00f9 bitmap (32x24 x 8 bytes)
        //0x18f9 background color
        //0x18fa colors (32*24 bytes)
    }

    if (machine==SPECTRUM) { // ZX Spectrum

        //would need some cleaning up

        //  outputter("  .area  _DATA",true);
        //  outputter("  .globl _taustakuva",true);
        //  outputter("",true);
        //  outputter("_taustakuva:",true);
        load_template("specshow.tap");
        int stad;

        checksum=0xc9;
        for (y=0x1d24; y<=0x1d3d; y++) { //1d3e
            checksum=checksum^int(g_template[y]);
        }
        //TAP requires fiddling with the checksum
        //println("Checksum:"+hex(checksum,2));
        set_head(0x0223);
        outputter(".byte "+(str(g_map[0]))+" ;border", true);
        write_head(int(g_map[0]));
        checksum=checksum^int(g_map[0]);
        for (y=0; y<=2; y++) {
            for (y2=0; y2<=7; y2++) {
                for (yy=0; yy<=7; yy++) {

                    outputter(".byte ", false);
                    for (x=0; x<=31; x++) {
                        yp=y*64+yy*8+y2;
                        xp=x;
                        ad=1024+yp*256+x*8;
                        valu=g_map[ad+0]*128+g_map[ad+1]*64+g_map[ad+2]*32+g_map[ad+3]*16+g_map[ad+4]*8+g_map[ad+5]*4+g_map[ad+6]*2+g_map[ad+7]*1;
                        outputter(str(int(valu)), false);
                        by++;
                        write_head(int(valu));
                        checksum=checksum^int(valu);
                        if (x<=30) {
                            outputter(",", false);
                        }
                    }
                    outputter("", true);
                }
            }
        }

        outputter("; attributes", true);
        for (y=0; y<=23; y++) {
            outputter(".byte ", false);
            for (x=0; x<=31; x++) {
                ad=65536+x+y*256;
                valu=int(g_map[ad]);
                valu2=int(g_map[ad+MX*MY*8]);
                bri=0;
                if (valu>=8) {
                    bri=1;
                    valu=valu-8;
                    valu2=valu2-8;
                    if (valu2<=0) {
                        valu2=0;
                    }
                }
                if (bri==1) {
                    valu=valu+64;
                }
                outputter(str(valu+valu2*8), false);
                by++;
                write_head(int(valu+valu2*8));
                checksum=checksum^int(valu+valu2*8);
                if (x<=30) {
                    outputter(",", false);
                }
            }
            outputter("", true);
        }
        //println("checksum:"+hex(checksum,2));
        set_head(0x1d3e);
        write_head(int(checksum));
        export_program(fname);
    }

    if (machine==CPC) {
        load_template("cpc-mode0.bin");

        set_head(69);//bitmap offset
        bitmapexport_cpc(160, 200);
        set_head(16453);
        outputter(";palette", true);
        outputter(".byte ", false);
        for (int i=0; i<g_maxcolors; i++) {//fixed # of palette entries, just trying to be generic
            val1=int(g_g[i]/(256/g_palsteps));
            val2=int(g_r[i]/(256/g_palsteps));
            val3=int(g_b[i]/(256/g_palsteps));
            write_head(val1*9+val2*3+val3);
            outputter(str(val1*9+val2*3+val3), false);
            if (i<g_maxcolors-1) {
                outputter(",", false);
            }
        }
        outputter("", true);
        outputter(";border", true);
        outputter(".byte ", false);  
        set_head(16469);
        valu=int(g_map[0]);
        val1=int(g_g[valu]/(256/g_palsteps));
        val2=int(g_r[valu]/(256/g_palsteps));
        val3=int(g_b[valu]/(256/g_palsteps));
        write_head(val1*9+val2*3+val3);
        outputter(str(val1*9+val2*3+val3), false);
        //cpc
        //69    bitmap 16384 bytes
        //16453 palette 16 bytes (0..26)
        //16469 border color (0..26)
        export_program(fname);
    }

    // any common lead-outs

    if (sorsa==1) {
        exwriter.flush();
        exwriter.close();
    }
}

void bitmapexport_cpc(int xwid, int yy)
{
    int x, y, ad, val1, val2, y2;
    int pix0b0, pix0b1, pix0b2, pix0b3;
    int pix1b0, pix1b1, pix1b2, pix1b3;
    int pp;
    pp=0;
    outputter(";bitmap", true);
    for (y2=0; y2<=7; y2++) {
        for (y=0; y<25; y++) {
            outputter("  .byte ", false); 
            for (x=0; x<xwid/2; x++) {
                ad=1024+(y*8)*X+(y2*X)+x*4;
 
                val1=int(g_map[ad]);
                pix0b0=0;pix0b1=0;pix0b2=0;pix0b3=0;
                if ((val1&1)!=0) pix0b0=1;
                if ((val1&2)!=0) pix0b1=1;
                if ((val1&4)!=0) pix0b2=1;
                if ((val1&8)!=0) pix0b3=1;

                val1=int(g_map[ad+2]);

                pix1b0=0;pix1b1=0;pix1b2=0;pix1b3=0;
                if ((val1&1)!=0) pix1b0=1;
                if ((val1&2)!=0) pix1b1=1;
                if ((val1&4)!=0) pix1b2=1;
                if ((val1&8)!=0) pix1b3=1;
                
                val2=pix1b3+pix0b3*2+pix1b1*4+pix0b1*8+pix1b2*16+pix0b2*32+pix1b0*64+pix0b0*128;
                outputter(str(int(val2)), false);
                write_head(val2);
                pp++;
                if (x<xwid/2-1) {
                    outputter(",", false);
                }
            }
            outputter("", true);
        }
        outputter("  .byte ", false); 
        for (int j=0; j<=47; j++) {
            write_head(0);
            outputter(str(int(0)), false);
            pp++;
            if (j<47) {
                outputter(",", false);
            }
        }
        outputter("", true);
    }
    outputter("", true);
}

void bitmapexport(int xx, int yy)
{
    int xwid, ywid, x, y, y2, value, ad, linep;
    linep=0;
    xwid=xx*8;
    ywid=yy*8;
    //outputter("unsigned char img[]={",false);

    for (y=0; y<yy; y++) {
        for (x=0; x<xx; x++) {
//            outputter("  .byte ", false);
           outputter(char(9)+".db ",false); 
            for (y2=0; y2<=7; y2++) {
                ad=1024+y*(xwid*8)+(y2*xwid)+x*8;
                value=g_map[ad+0]*128+g_map[ad+1]*64+g_map[ad+2]*32+g_map[ad+3]*16+g_map[ad+4]*8+g_map[ad+5]*4+g_map[ad+6]*2+g_map[ad+7]*1;       
                outputter(str(int(value)), false);
                write_head(int(value));
                if (y2<=6) {
                    outputter(",", false);
                }
            }  
            outputter("", true);
            linep++;
            if (linep==xx) {
                linep=0;
                outputter("", true);
            }
        }
    }
    outputter("", true);
}

int convertlumi(int l,int f)
{
    int res=0;
    if(f==0)return 0;
    if(l==0)res=0+f;
    if(l==1)res=15+f;
    if(l==2)res=30+f;
    if(l==3)res=45+f;
    if(l==4)res=60+f;
    if(l==5)res=75+f;
    if(l==6)res=90+f;
    if(l==7)res=105+f;
    return res;
}

int getplusluminance(int c)
{
    int res=0;
    if (c==0)res=0;
    if (c>=1&&c<=15)res=0;
    if (c>=16&&c<=30)res=1;
    if (c>=31&&c<=45)res=2;
    if (c>=46&&c<=60)res=3;
    if (c>=61&&c<=75)res=4;
    if (c>=76&&c<=90)res=5;
    if (c>=91&&c<=105)res=6;
    if (c>=106&&c<=120)res=7;
    return res;
}

int getpluscolor(int c)
{
    int res=0;
    if (c==0)res=0;
    if (c>=1&&c<=15)res=c;
    if (c>=16&&c<=30)res=c-15;
    if (c>=31&&c<=45)res=c-30;
    if (c>=46&&c<=60)res=c-45;
    if (c>=61&&c<=75)res=c-60;
    if (c>=76&&c<=90)res=c-75;
    if (c>=91&&c<=105)res=c-90;
    if (c>=106&&c<=120)res=c-105;
    return res;
}

void colorexport(int xx, int yy, int source, int param)
{
    int x, y, y2, valu, valu2, kalu, muista, ad, linep, xwid, ywid, xoor, yline, myrpsi;
    xwid=xx*8;
    ywid=yy*8;
    valu=0;
    valu2=0;
    myrpsi=0;
    xoor=xx;
    if (param==0||param==4||param==5) {
        xoor=xx*8;
    }
    if (machine==MSX) {
        myrpsi=7;
    }
    if (param<2) {
        outputter("colora:", true);
    }
    if (param==2) {
        outputter("colorb:", true);
    }     
    if (param<2) {
        outputter("  .byte "+int(g_map[0])+","+int(g_map[1]), true);
    }
    if (param==3) {
     //   outputter("color:", true);
     //   outputter("  .byte ", false);
      //  outputter(g_map[0]+" ", true);
        xoor=xx*8;
    }
    if (param==4) {
        outputter("_border:", true);
        outputter("  .byte ", false);
        kalu=getpluscolor(int(g_map[0]));
        valu2=getplusluminance(int(g_map[0]));
        valu=valu2*16+kalu;
        outputter(valu+" ", true);
        outputter("_color:", true);
    }
    if (param==5) {
        outputter("_lumi:", true);
    }
    for (y=0; y<yy; y++) {
        //outputter("  .byte ", false);
        outputter(char(9)+".db ", false);
        for (x=0; x<xx; x++) {
            for (yline=0; yline<=myrpsi; yline++) {
                ad=source+x+y*xoor+yline*xx;
                if (param==0) {
                    valu=int(g_map[ad]);
                    valu2=int(g_map[ad+MX*MY*8]);
                }
                if (param==1) {
                    valu2=int(g_map[ad]);
                    valu=int(g_map[ad+1000]);
                }   
                if (param==2) {
                    valu2=int(g_map[ad]);
                    valu=0;
                }  
                if (param==3) {
                    valu=int(g_map[ad]);
                    valu2=int(g_map[ad+MX*MY*8]);
                }

                if (param==4) {//plus4 colortable
                    kalu=int(g_map[ad]);
                    valu=getpluscolor(kalu);
                    kalu=int(g_map[ad+MX*MY*8]);
                    valu2=getpluscolor(kalu);
                }        
                
                if (param==5) {//plus4 lumitable
                    kalu=int(g_map[ad]);
                    valu2=getplusluminance(kalu);
                    kalu=int(g_map[ad+MX*MY*8]);
                    valu=getplusluminance(kalu);
                }
                
                if (param==6) {//plus4 multic1
                    valu2=getpluscolor(int(g_map[ad]));
                    valu=getpluscolor(int(g_map[ad+1000]));
                }
                
                if (param==7) {//plus4 multic2
                    valu=getplusluminance(int(g_map[ad]));
                    valu2=getplusluminance(int(g_map[ad+1000]));
                }
                
                outputter(str(valu*16+valu2), false);
                write_head(int(valu*16+valu2));                           
                if (x<(xx-1)||yline<myrpsi) {
                    outputter(",", false);
                }
            }
        }
        outputter("", true);
    }
    outputter("", true);
}

void load_template(String fname)
{
    g_template=loadBytes("templates/"+fname);
}

void import_program(String fname)
{
    g_template=loadBytes(fname);
}

void set_head(int pos)
{
    g_headpos=pos;
}

void write_head(int bb)
{
    g_template[g_headpos]=byte(bb);
    g_headpos++;
}

void export_program(String fname)
{
    if (g_sorsaa==1) {
        return;
    }
    saveBytes(fname, g_template);
}

void outputter(String oput, boolean eol)
{
    if (g_sorsaa==0)return;
    if (eol==false)exwriter.print(oput);
    if (eol==true)exwriter.println(oput);
}


void import_image(String name)
{
    PImage image;
    image = loadImage(name);
    int balx, baly, xx, yy, x2, y2, rr, gg, bb, avg, molox, i, j, target;
    int cx, cy;
    int aas, bbs, swap, idefix, avx, avy;
    int[] pixut= new int[260];
    int[] idx=new int[260];
    int[] histog=new int[8192];
    float ww, hh, fld, compa, fx2, fy2;
    color c;
    int xcolors, limitter, vertti, erkki;
    int rh,gh,bh;

    xcolors=g_maxcolors;
    vertti=8;
    erkki=1;
    limitter=2;
    if (g_britemode==1) {
        xcolors=8;
    }
    if (g_attrimode==0) {
        vertti=1;
        erkki=8;
    }
    if (g_multic==1) {
        limitter=4;
    }//because zero color can be anywhere?
    if (g_multic==2) {
        limitter=16;
    }
    molox=1;
    command('O');//special clear screen
    if (g_multic==1||g_hzoomer==2) {
        molox=2;
    }
    ww=image.width;
    hh=image.height;
    if (ww<=16||hh<=16) {
        return;
    }
    balx=int(ww/X);
    balx=balx*molox;
    baly=int(hh/Y);
    if (balx<1) {
        balx=1;
    }
    if (baly<1) {
        baly=1;
    }

    if(g_palsteps>0){
      for(i=0;i<g_maxcolors;i++){
        makecolor(i,0,0,0);
      }
        
      int maxhis,palls,psteps;
      psteps=int(g_palsteps-1);
      maxhis=0;palls=int(255/psteps);
        for (cy=0; cy<MY*erkki; cy++) {
        for (cx=0; cx<MX; cx++) {
            for (yy=cy*vertti; yy<=cy*vertti+vertti-1; yy++) {
                for (xx=cx*8; xx<=cx*8+7; xx=xx+molox) {
                    fx2=(ww/X)*xx;
                    fy2=(hh/Y)*yy;
                    x2=int(fx2);
                    y2=int(fy2);
                    rr=0;
                    gg=0;
                    bb=0;
                    avg=0;

                    for (avy=0; avy<baly; avy++) {
                        for (avx=0; avx<balx; avx++) {
                            c=image.get(x2+avx, y2+avy);
                            rr=rr+int(red(c));
                            gg=gg+int(green(c));
                            bb=bb+int(blue(c));
                            avg++;
                        }
                    }
                    rh=rr/(avg);
                    gh=gg/(avg);
                    bh=bb/(avg);
                    rh=int(rh)/palls;
                    gh=int(gh)/palls;
                    bh=int(bh)/palls;
                    histog[int(rh*(g_palsteps*g_palsteps)+gh*(g_palsteps)+bh)]++;
                    if(histog[int(rh*(g_palsteps*g_palsteps)+gh*(g_palsteps)+bh)]>maxhis){maxhis=histog[int(rh*(g_palsteps*g_palsteps)+gh*(g_palsteps)+bh)];}
                }
              }
            }
          }
    
      int step;
      step=0;
      for(j=maxhis;j>0;j--){
        for(i=0;i<=4096;i++){
           if(histog[i]==j){
              rh=i/int(g_palsteps*g_palsteps);
              gh=i-int(rh*(g_palsteps*g_palsteps));gh=gh/int(g_palsteps);
              bh=i-int(rh*(g_palsteps*g_palsteps));bh=bh-int(gh*g_palsteps);
              rh=rh*int(palls);
              gh=gh*int(palls);
              bh=bh*int(palls);
              if(step<g_maxcolors){
                makecolor(step,rh,gh,bh);step++;
              }
            }
          }
        }

    }
                            
    for (cy=0; cy<MY*erkki; cy++) {
        for (cx=0; cx<MX; cx++) {
            for (i=0; i<xcolors; i++) {
                pixut[i]=0;
                idx[i]=i;
            }  
            for (yy=cy*vertti; yy<=cy*vertti+vertti-1; yy++) {
                for (xx=cx*8; xx<=cx*8+7; xx=xx+molox) {
                    fx2=(ww/X)*xx;
                    fy2=(hh/Y)*yy;
                    x2=int(fx2);
                    y2=int(fy2);
                    rr=0;
                    gg=0;
                    bb=0;
                    avg=0;
                    for (avy=0; avy<baly; avy++) {
                        for (avx=0; avx<balx; avx++) {
                            c=image.get(x2+avx, y2+avy);
                            rr=rr+int(red(c));
                            gg=gg+int(green(c));
                            bb=bb+int(blue(c));
                            avg++;
                        }
                    }
                    rr=rr/(avg);
                    gg=gg/(avg);
                    bb=bb/(avg);
                    g_farge=0;
                    target=-1;
                    compa=9999;
                    for (i=0; i<xcolors; i++) {
                        fld=dist(rr, gg, bb, g_r[i], g_g[i], g_b[i]);
                        if (fld<compa) {
                            compa=fld;
                            target=i;
                        }
                    }

                    g_farge=target;
                    pixut[target]++;//histogramming
                }
            }

            for (aas=0; aas<xcolors; aas++) {
                for (bbs=0; bbs<=aas; bbs++) {
                    if (pixut[aas]>pixut[bbs]) {
                        swap=pixut[aas];
                        pixut[aas]=pixut[bbs];
                        pixut[bbs]=swap;
                        swap=idx[aas];
                        idx[aas]=idx[bbs];
                        idx[bbs]=swap;
                    }
                }
            }

            for (idefix=0; idefix<limitter; idefix++) {
                i=idx[idefix];
                for (yy=cy*vertti; yy<=cy*vertti+vertti-1; yy++) {
                    for (xx=cx*8; xx<=cx*8+7; xx=xx+molox) {

                        fx2=(ww/X)*xx;
                        fy2=(hh/Y)*yy;
                        x2=int(fx2);
                        y2=int(fy2);

                        rr=0;
                        gg=0;
                        bb=0;
                        avg=0;
                        for (avy=0; avy<baly; avy++) {
                            for (avx=0; avx<balx; avx++) {
                                c=image.get(x2+avx, y2+avy);
                                rr=rr+int(red(c));
                                gg=gg+int(green(c));
                                bb=bb+int(blue(c));
                                avg++;
                            }
                        }
                        rr=rr/(avg);
                        gg=gg/(avg);
                        bb=bb/(avg);
                        g_farge=0;
                        target=-1;
                        compa=9999;
                        for (j=0; j<limitter; j++) {
                            fld=dist(rr, gg, bb, g_r[idx[j]], g_g[idx[j]], g_b[idx[j]]);
                            if (fld<compa) {
                                compa=fld;
                                target=idx[j];
                            }
                        }
                        if (i==target) {

                            g_farge=target;
                            makepoint(xx, yy);
                        }
                    }
                }
                if (idefix==0) {

                    for (yy=cy*vertti; yy<=cy*vertti+vertti-1; yy++) {
                        for (xx=cx*8; xx<=cx*8+7; xx=xx+molox) {
                            g_farge=idx[0];
                            makepoint(xx, yy);
                        }
                    }
                }
            }
        }
    }

}

void export_image(String name)
{
    //output the visible graphics as image
    //with border
    //processing style
    int xx, yy, f, x2;
    color c;
    for (xx=0; xx<output.width; xx++) {
        for (yy=0; yy<output.width; yy++) {
            c=color(g_r[259], g_g[259], g_b[259]);
            output.set(xx, yy, c);
        }
    }

    for (xx=0; xx<X; xx++) {
        for (yy=0; yy<Y; yy++) {
            x2=xx; 
            f=getabsa(x2, yy, 0);
            if (g_multic==1||g_hzoomer==2) {
                x2=xx/2;
                x2=x2*2; 
                f=getmultic(x2, yy, 0);
            }
            if (machine==MSX) {
                if (f==0) {
                    f=g_map[1];
                }
            }
            c=color(g_r[f], g_g[f], g_b[f]);
            for (int vertti=0; vertti<=g_omag; vertti++) {
                for (int mortti=0; mortti<=g_omag; mortti++) {
                    output.set((g_bordh*g_omag)/2+xx*g_omag+mortti, (g_bordv*g_omag)/2+yy*g_omag+vertti, c);
                }
            }
        }
    }
    output.save(name);
}

void export_image_sans_border(String name)
{
    //output the visible graphics as image
    //processing style
    //without border
    int xx, yy, f, x2;
    color c;

    for (xx=0; xx<outputsans.width; xx++) {
        for (yy=0; yy<outputsans.width; yy++) {
            c=color(g_r[259], g_g[259], g_b[259]);
            outputsans.set(xx, yy, c);
        }
    }

    for (xx=0; xx<X; xx++) {
        for (yy=0; yy<Y; yy++) {
            x2=xx;
            f=getabsa(x2, yy, 0);
            if (g_multic==1||g_hzoomer==2) {
                x2=xx/2;
                x2=x2*2;  
                f=getmultic(x2, yy, 0);
            }

            if (machine==MSX) {
                if (f==0) {
                    f=g_map[1];
                }
            }
            c=color(g_r[f], g_g[f], g_b[f]);
            for (int vertti=0; vertti<=g_omag; vertti++) {
                for (int mortti=0; mortti<=g_omag; mortti++) {
                    outputsans.set(xx*g_omag+mortti, yy*g_omag+vertti, c);
                }
            }
        }
    }
    outputsans.save(name);
}

void make_c64_palette()
{
    // Pepto's murky C64 palette: http://www.pepto.de/projects/colorvic
    int rgb[]={#000000,#FFFFFF,#68372B,#70A4B2,#6F3D86,#588D43,#352879,#B8C76F,
                     #6F4F25,#433900,#9A6759,#444444,#6C6C6C,#9AD284,#6C5EB5,#959595};
    for(int i=0;i<g_maxcolors;i++){
      rgb[i]=rgb[i]&0xffffff;
      g_grids[i]=rgb[i]+#282828;
      makecolor(i,rgb[i]>>16,(rgb[i]&#00FF00)>>8,rgb[i]&#0000FF);
    }
    g_grids[1]=#d0d0d0;g_gridmode=NEW;
    g_map[13]=byte(C64);
}

void make_plus4_palette()
{
  int rgb[]={
    #000000,#2C2C2C,#621307,#00424C,#510378,#004E00,#27188E,#303E00,#582100,#463000,#244400,#630448,#004E0C,#0E2784,#33118E,#184800,
    #3B3B3B,#702419,#00505A,#601685,#125D00,#36289B,#3F4C00,#663100,#553F00,#345200,#711656,#005C1D,#1F3691,#42229B,#285700,
    #424242,#772C21,#055861,#661E8C,#1B6400,#3E30A2,#475400,#6D3900,#5C4700,#3B5900,#771F5D,#046325,#273E98,#492AA1,#305E00,
    #515151,#843B31,#17656F,#742E99,#2B7100,#4C3FAF,#556200,#7A4709,#6A5500,#4A6700,#852F6B,#177135,#364CA5,#5739AE,#3F6B00,
    #7A7A7A,#AC665C,#468E97,#9C5AC0,#57992E,#766AD5,#7E8A13,#A2713A,#927E20,#748F14,#AC5A93,#459960,#6276CB,#8064D4,#6A9419,
    #959595,#C58178,#62A8B1,#B675D9,#73B34C,#9185ED,#99A433,#BB8C57,#AC993E,#8FAA34,#C676AD,#62B37B,#7D91E4,#9B80ED,#85AE38,
    #AFAFAF,#DE9B93,#7DC2CA,#CF90F2,#8DCD68,#AB9FFF,#B3BE51,#D5A673,#C6B35B,#A9C351,#DF91C7,#7DCC96,#97ABFD,#B59AFF,#9FC755,
    #E1E1E1,#FFCFC6,#B2F4FC,#FFC4FF,#C1FE9D,#DDD2FF,#E5F088,#FFD9A8,#F7E591,#DBF588,#FFC4F9,#B1FEC9,#CBDDFF,#E7CDFF,#D2F98C
  };
    for(int i=0;i<g_maxcolors;i++){
      rgb[i]=rgb[i]&0xffffff;
      makecolor(i,rgb[i]>>16,(rgb[i]&#00FF00)>>8,rgb[i]&#0000FF);
    }
}

void make_msx_palette()
{
    int rgb[]={
    #000000,
    #000000,
    #3EB849,
    #74D07D,
    #5955E0,
    #8076F1,
    #B95E51,
    #65DBEF,
    #DB6559,
    #FF897D,
    #CCC35E,
    #DED087,
    #3AA241,
    #B766B5,
    #CCCCCC,
    #FFFFFF};

    for(int i=0;i<g_maxcolors;i++){
      rgb[i]=rgb[i]&0xffffff;
      g_grids[i]=rgb[i]+#1f1f1f;
      makecolor(i,(rgb[i]>>16),(rgb[i]&#00FF00)>>8,rgb[i]&#0000FF);
    }
    g_grids[5]=#9f95Ff;
    g_grids[7]=#84faEF;
    g_grids[9]=#ffa99d;
    g_grids[15]=#d8d8d8;g_gridmode=NEW;
}

void make_spectrum_palette()
{
  int rgb[]={#000000,#0000C0,#C00000,#C000C0,#00C000,#00C0C0,#C0C000,#C0C0C0,
              #000000,#0000FF,#FF0000,#FF00FF,#00FF00,#00FFFF,#FFFF00,#FFFFFF};
              
  g_grids[9]=#0000d8;
  g_grids[10]=#d80000;
  g_grids[11]=#d800d8;
  g_grids[12]=#00d800;
  g_grids[13]=#00d8d8;
  g_grids[14]=#d8d800;
  g_grids[15]=#d8d8d8;
    for(int i=0;i<g_maxcolors;i++){
      rgb[i]=rgb[i]&0xffffff;
      if(i<=8){g_grids[i]=rgb[i]+#282828;}
      makecolor(i,(rgb[i]>>16),(rgb[i]&#00FF00)>>8,rgb[i]&#0000FF);
    }
    g_gridmode=NEW;
}

void set_machine(int m)
{
    machine=m;
    g_expname="none";
    g_map[3]=byte(machine);g_map[13]=byte(machine);
    g_palsteps=0;g_farge=1;g_backg=0;g_britemode=0;
    g_charlimit=0;g_hzoomer=1;g_backmode=0;
    g_formatname="";
    g_formatextension="";
    g_maxcolors=16;X=320;Y=200;

    if (machine==C64) {//c64 hires
        g_expname="prg";
        g_formatname="Art Studio";
        g_formatextension="art";
        g_name="c64";
        g_attrimode=1;
        g_map[1]=byte(255);
        g_map[0]=6;
        make_c64_palette();
    }

    if (machine==CPC) {  //Amstrad CPC mode 0
        g_hzoomer=2;
        g_palsteps=3;
        g_name="cpc";g_expname="bin";
        g_formatname="";g_formatextension="";
        g_multic=2;
        g_attrimode=0;
        g_map[1]=byte(255);g_map[0]=1;

        makecolor(0, 0, 0, 0);
        makecolor(1, 0x0, 0x0, 0x80);
        makecolor(2, 0x00, 0x00, 0xFF);
        makecolor(3, 0x80, 0x00, 0x00);
        makecolor(4, 0x80, 0x00, 0x80);
        makecolor(5, 0x80, 0x00, 0xFF);
        makecolor(6, 0xFF, 0x00, 0x00);
        makecolor(7, 0xFF, 0x00, 0x80);
        makecolor(8, 0xFF, 0x00, 0xFF);
        makecolor(9, 0x00, 0x80, 0x00);
        makecolor(10, 0x00, 0x80, 0x80);
        makecolor(11, 0x00, 0x80, 0xFF);
        makecolor(12, 0x80, 0x80, 0x00);
        makecolor(13, 0x80, 0x80, 0x80);
        makecolor(14, 0x80, 0x80, 0xFF);
        makecolor(15, 0xFF, 0xFF, 0xFF);
    }

    if (machine==MSX) {    // MSX
        g_name="msx";
        g_expname="com";
        g_formatname="Screen 2";
        g_formatextension="sc2";
        X=256;Y=192;
        g_attrimode=0;
        g_backmode=1;
        g_farge=15;
        g_backg=0; 

        //TI99 variant
        /*
        makecolor(0,0,0,0);
        makecolor(1,0,0,0);

        makecolor(2,0x21,0xc8,0x42); //21c842 medgreen
        makecolor(3,0x5e,0xdc,0x78);//5edc78 light green
        makecolor(4,0x54,0x55,0xed);//5455ed dark blue
        makecolor(5,0x7d,0x76,0xFc);//7d76fc light blue
        
        makecolor(6,0xd4,0x52,0x4d); //d4524d dark red
        makecolor(7,0x42,0xeb,0xf5); //42ebf5 cyan
        makecolor(8,0xfc,0x55,0x54); //fc5554 medium red
        makecolor(9,0xff,0x79,0x78); //ff7978 light red
        makecolor(10,0xd4,0xc1,0x54);// d4c154 dark yellow
        makecolor(11,0xe6,0xce,0x80);// e6ce80 light yellow
        makecolor(12,0x21,0xb0,0x3b);// 21b03b dark green
        makecolor(13,0xc9,0x5b,0xba);// c95bba magenta
        makecolor(14,0xCc,0xcc,0xCc);// gray 
        makecolor(15,0xFF,0xFF,0xFF);
        */
        make_msx_palette();
    }

    if (machine==SPECTRUM) { // ZX Spectrum
        g_name="spec";
        g_expname="tap";
        X=256;Y=192;
        g_formatname="Screen$";g_formatextension="scr";
        g_farge=7;
        g_backg=0;
        g_attrimode=1;
        g_britemode=1;
        g_map[0]=1;
        g_map[1]=byte(255);
        make_spectrum_palette();
    }

    if (machine==TIMEX) {    // timex sinclair
        g_name="tmx";
        X=256;Y=192;
        g_farge=7;
        g_backg=0;
        g_attrimode=0;
        g_britemode=1;
        g_map[1]=byte(255);
        make_spectrum_palette();
    }

    if (machine==JR200) {  // Panasonic JR200
        g_name="jr200";
        X=256;Y=192;
        g_maxcolors=8;
        g_farge=7;
        g_backg=0;
        g_attrimode=1;
        g_map[1]=byte(255);
        make_spectrum_palette();//cheating
    }

    if (machine==PLUS4M||machine==PLUS4) { // Commodore plus/4
        g_backmode=1;
        g_multic=1;    
        g_name="plus4m";g_expname="prg";
        g_attrimode=1;
        g_maxcolors=121;
        g_charlimit=2;
        g_map[1]=0;g_map[2]=61;g_farge=61;
        g_formatname="M.Botticelli";g_formatextension="prg";
        if (machine==PLUS4) { // plus/4 hires
            g_formatname="Botticelli";g_formatextension="prg";
            g_multic=0;
            g_backmode=0;
            g_charlimit=0;
            g_name="plus4";
            g_attrimode=1;
            g_map[1]=byte(255);
        }
        g_map[0]=6;
        make_plus4_palette();
    }

    if (machine==C64M) {    //c64 multicolor
        g_backmode=1;
        g_charlimit=3;
        g_multic=1;
        g_name="c64m";g_expname="prg";
        g_formatname="A. A. Studio";
        g_formatextension="ocp";
        g_attrimode=1;
        g_map[1]=byte(0);  
        g_map[0]=6;
        make_c64_palette();
    }

    if (machine==AMIGA) {    //generic 16bit
        g_backmode=1;
        g_maxcolors=32;g_palsteps=16;
        g_name="test";
        g_multic=2;
        g_attrimode=2;
        g_map[1]=byte(0);
        for (int z=0; z<g_maxcolors; z++) {
            if (z<16) {
                makecolor(z, z*17, z*17, z*17);
            } else
            {
                makecolor(z, (z-16)*17, 0, 0);
            }
        }
    }

    if (machine==C64FLI) {    //c64 hires FLI = AFLI
        g_expname="prg";
        g_formatname="";g_formatextension="";
        g_name="afli";
        g_attrimode=0;
        g_map[1]=byte(255);
        g_map[0]=6;
        make_c64_palette();
    }

    if (machine==C64FLIM) {    //C64 FLI multicolor 
        g_hzoomer=2;
        g_maxcolors=16;
        g_name="fli";g_expname="";
        g_formatname="";g_formatextension="";
        g_multic=2;
        g_attrimode=0;
        g_map[1]=byte(255);
        g_map[0]=6;
        make_c64_palette();
    }
    
    if (machine==FAKEX) {    // Fake 8-bit computer
        g_name="fake";
        g_expname="";
        g_formatname="";
        g_formatextension="";
        X=320;Y=200;
        g_multic=2;
        g_attrimode=2;//g_palsteps=4;
        g_farge=15;
        g_backg=0; 
        make_c64_palette();
    }
    
    if (machine==PICO8) {    // Pico-8 fantasy console
        g_name="pico8";
        g_expname="";
        g_formatname="";
        g_formatextension="";
        X=128;Y=128;
        g_farge=15;
        g_backg=0; 
        g_multic=2;
        g_attrimode=2;
        makecolor(0, 0, 0, 0);
        makecolor(1, 32, 51, 123);
        makecolor(2, 126, 37, 83);
        makecolor(3, 0, 144, 61);        
        makecolor(4, 171, 82, 54);
        makecolor(5, 52, 54, 53);
        makecolor(6, 194, 195, 199);
        makecolor(7, 255, 241, 232);      
        makecolor(8, 255, 0, 77);
        makecolor(9, 255, 155, 0);
        makecolor(10, 255, 231, 39);
        makecolor(11, 0, 226, 50);       
        makecolor(12, 41, 173, 255);
        makecolor(13, 132, 112, 169);
        makecolor(14, 255, 119, 168);
        makecolor(15, 255, 214, 197);
    }
        if (machine==UNIA) {    // Unia digital palette
        g_name="unia";
        g_expname="";
        g_formatname="";
        g_formatextension="";
        X=256;Y=192;
        g_farge=15;
        g_backg=0; 
        g_multic=2;
        g_attrimode=2;
        makecolor(0, 0, 0 , 0);
        makecolor(1, 0xff, 0xff, 0xff);
        makecolor(2, 0xff, 0xfd, 0x38);
        makecolor(3, 0xff, 0xc5, 0x00);        
        makecolor(4, 0xff, 0x00, 0x00);
        makecolor(5, 0xff, 0x3c, 0xb4);
        makecolor(6, 0xa0, 0x23, 0xbc);
        makecolor(7, 0x1b, 0xa1, 0xfc);      
        makecolor(8, 0xe1, 0xe1, 0xe1);
        makecolor(9, 0xb9, 0x63, 0x00);
        makecolor(10, 0xff, 0xaa, 0xbe);
        makecolor(11, 0xd2, 0x9b, 0xd7);       
        makecolor(12, 0xad, 0xad, 0xad);
        makecolor(13, 0x00, 0xb7, 0xb7);
        makecolor(14, 0x23, 0xaf, 0x32);
        makecolor(15, 0x29, 0xf7, 0xa7);
    }
}

void packer()
{
    int i, dat, amo;
    int head;
    amo=1;
    i=0;
    head=0;
    //0=repeated element [n repetitions, element length, element]
    //1-255=repeat byte [element]

    while (i<=g_map.length-3) {
        dat=int(g_map[i]);
        while (int (g_map[i+1])==dat&&i<=g_map.length-3) {
            if (int(g_map[i+1])==dat) {
                if (amo<65535) {
                    amo++;
                    i++;
                }
                if (amo==65535) {
                    //pask[head]=dat;pask[head+1]=255;
                    println(dat+" x "+amo);
                    head=head+3;
                    amo=0;
                }
            }
        }
        println(dat+" x "+amo);
        amo=0;
        //  pask[head]=dat;pask[head+1]=amo;
        head++;
        head++;
        head++;
        i++;
    }
    println(head);

    for (i=0; i<=g_map.length; i++) {
    }
    message("Packing|test|"+str(head));
}

