
// Pure Java UI elements, such as a file selector
// Adapted from Marq's PETSCII editor
// (this crap really makes me lose all my will to live, but it's needed now)

import java.awt.event.*;
import javax.swing.*;
import javax.swing.filechooser.FileNameExtensionFilter;
import java.awt.Dimension;
import java.awt.GridLayout;

class Selector extends JPanel implements ActionListener
{
    int selection;
    protected JButton b[];
    
    Selector(String s) // Split string into options
    {
        String splitz[]=splitTokens(s,",");
        b=new JButton[splitz.length];
        
        setLayout(new GridLayout(splitz.length,1,1,1));
        
        for(int i=0;i<splitz.length;i++)
        {
            b[i]=new JButton(splitz[i]);
            b[i].setActionCommand(str(i+'0'));
            b[i].addActionListener(this);
            b[i].setHorizontalAlignment(SwingConstants.LEFT);
            
            add(b[i]);
        }
        
        selection=-1;
    }
    public void actionPerformed(ActionEvent e)
    {
        for(int i=0;i<b.length;i++)
        {
            if(str(i+'0').equals(e.getActionCommand()))
                selection=i;
        }
    }
}

// Select from a list
int selector(String title,String opt)
{
    JFrame frame=new JFrame(title);
    frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    frame.setLocationRelativeTo(null);
    
    Selector s=new Selector(opt);
    s.setOpaque(true);
    frame.setContentPane(s);
 
    //Display the window.
    frame.pack();
    frame.setVisible(true);
    
    frame.setLocationRelativeTo(null); // About in the middle
    
    while(s.selection==-1)
    {
        frame.toFront(); // A bit of a kludge to force the window on top
        frame.repaint();
        try { Thread.sleep(200); }
        catch(Exception e){};
    }
    
    frame.setVisible(false);
    
    System.gc(); // It'll leak anyway...
    return(s.selection);
}

final int LOADPIX=0,
          LOADIMG=1,
          SAVEIMG=2,
          SAVETXT=3,
          SAVEEMU=4,
          SAVEFMT=5,
          LOADFMT=6;

// File selector
String fileselector(String dir,int mode)
{
    JFileChooser fc=new JFileChooser(dir);
    
    fc.setPreferredSize(new Dimension(480, 500));
    fc.setDialogTitle("Select a File");
    
    if(mode==LOADPIX) // Show image files
        fc.setFileFilter(new FileNameExtensionFilter("Images (*.png,*.gif,*.jpg)",
                         "png","gif","jpg","jpeg"));
    if(mode==LOADIMG||mode==SAVEIMG)
        fc.setFileFilter(new FileNameExtensionFilter("Multipaint files (*.bin) or png (*.png)","bin","png","jpg"));
    if(mode==SAVEEMU)
        fc.setFileFilter(new FileNameExtensionFilter("Export files (*."+g_expname+") ",g_expname));
    if(mode==SAVETXT)
        fc.setFileFilter(new FileNameExtensionFilter("Export source (*.txt) ","c","asm","txt"));
    if(mode==SAVEFMT||mode==LOADFMT)
        fc.setFileFilter(new FileNameExtensionFilter(g_formatname+" (*."+g_formatextension+")",g_formatextension));
        
    if(mode<=LOADIMG||mode==LOADFMT)
        fc.setApproveButtonText("Load");
    if(mode==SAVEIMG)
        fc.setApproveButtonText("Save");
    if(mode==SAVETXT|mode==SAVEEMU||mode==SAVEFMT)
        fc.setApproveButtonText("Export");        
    int returnVal = fc.showOpenDialog(null);
    
    if(returnVal==JFileChooser.APPROVE_OPTION)
    {
        // Save cwd for next time
        if(mode==LOADPIX)
            refpath=fc.getCurrentDirectory().getPath();
        else
            path=fc.getCurrentDirectory().getPath();
        
        File file = fc.getSelectedFile();
        return file.getPath();
    }
    else
        return null;
}
