/*
 Generateur de table de DB a partir d'un fichier binaire
 */

#include <iostream>
#include <fstream>

int main (int argc, char **argv)
{
	if (argc != 3)
	{
		std::cout << argv[0] << " <filename.bin> <filename.z80>" << std::endl;
		return -1;
	}
	std::ifstream in(argv[1],std::ios::binary);
	std::ofstream out(argv[2]);

	int nbVal = 0;
	out << "; Original Datas : " << argv[1];
	while (!in.eof())
	{
		unsigned char c;
		in.read((char*)&c,1);
		if (!in.eof())
		{
			if (nbVal % 8 == 0)
			{
				out << "\n\tdb\t" << std::hex << "#" << (unsigned int)c;
			}
			else
			{
				out << "," << std::hex << "#" << (unsigned int)c;
			}
			nbVal ++;
		}
	}
	out << std::endl;

	return 0;
}