;
; Entre :
; - HL = Buffer (fichier compact)
; - DE = Destination
; Sortie :
; - AF, BC, DE, HL modifis
;
DepkLzw:
        XOR     A
        LD      (BclLzw+1),A
;
TstBitLzw:
        LD      A,(HL)
        INC     HL
        RRA                         ; Rotation rapide calcul seulement flag C
        SET     7,A                 ; Positionne bit 7 en gardant flag C
        LD      (BclLzw+1),A
        JR      C,TstCodeLzw

        LDI
;
BclLzw:
        LD      A,0
        RR      A                   ; Rotation avec calcul Flags C et Z
        LD      (BclLzw+1),A
        JR      Z,TstBitLzw
        JR      C,TstCodeLzw

        LDI
        JR      BclLzw
;
TstCodeLzw:
;
;       a = inbuffer[ inbytes ];
;
        LD      A,(HL)
        AND     A
;
; Plus d'octets  traiter
; = fini
;
        RET     Z

        INC     HL
        LD      B,A
        RLCA
        JR      NC,TstLzw40
;
;       length = 3 + ( ( inbuffer[ inbytes ] >> 4 ) & 7 );
;       index = ( inbuffer[ inbytes++ ] & 15 ) << 8;
;       index |= inbuffer[ inbytes++ ];
;       index++;
;
        PUSH    HL
        LD      C,(HL)                  ; C = poids faible index
        LD      L,B                     ; L = inbuffer[inbytes]
        RLCA
        RLCA
        RLCA
        AND     7
        ADD     A,3
        LD      H,A                     ; H = length
        LD      A,L
        AND     #0F
        LD      B,A                     ; B = poids fort index
        LD      A,H                     ; A = Length
        LD      H,D
        LD      L,E
        SBC     HL,BC
        DEC     HL
        LD      B,0
        LD      C,A
        LDIR
        POP     HL
        INC     HL
        JR      BclLzw
;
TstLzw40:
        RLCA
        JR      NC,TstLzw20
;
;       length = 2;
;       index = inbuffer[ inbytes++ ] & 0x3f;
;       index++;
;
        LD      C,B
        RES     6,C
        LD      B,0         ; BC = index -1, pas de +1 car flag C = 1
        PUSH    HL
        LD      H,D
        LD      L,E
        SBC     HL,BC
        LDI
        LDI
        POP     HL
        JR      BclLzw
;
TstLzw20:
        RLCA
        JR      NC,TstLzw10
;
;       length = 2 + ( inbuffer[ inbytes++ ] & 31 );
;       index = inbuffer[ inbytes++ ];
;       index++;
;
        PUSH    HL
        LD      A,B
        RES     5,A
        LD      C,(HL)                  ; C = index
        LD      B,0
        LD      H,D
        LD      L,E
        SBC     HL,BC
        ADD     A,2
        LD      C,A                     ; C = length
        LDIR
        POP     HL
        INC     HL
        JR      BclLzw

;
TstLzw10:
        RLCA
        JR      NC,CodeLzw0F
;
;       index = ( inbuffer[ inbytes++ ] & 15 ) << 8;
;       index |= inbuffer[ inbytes++ ];
;       length = inbuffer[ inbytes++ ] + 1;
;       index++;
;
        RES     4,B                     ; B = index(high)
        LD      C,(HL)                  ; C = index(low)
        INC     HL
        LD      A,(HL)                  ; A = length - 1
        PUSH    HL
        LD      H,D
        LD      L,E
        SBC     HL,BC                   ; Flag C=1 -> hl=hl-(bc+1)
        LD      B,0
        LD      C,A
        INC     BC                      ; BC = length
        LDIR
        POP     HL
        INC     HL
        JR      BclLzw
;
CodeLzw0F:
        PUSH    HL
        LD      A,B
        CP      #0F
        JR      NZ,CodeLzw02
;
;       length = index = inbuffer[ inbytes + 1 ] + 1;
;       inbytes += 2;
;
        LD      C,(HL)
        XOR     A
        LD      B,A
        INC     BC
        LD      H,D
        LD      L,E
        SBC     HL,BC
        LDIR
        POP     HL
        INC     HL
        JP      BclLzw
;
CodeLzw02:
        LD      H,D
        LD      L,E
        CP      2
        JR      C,CodeLzw01
;
;       length = index = inbuffer[ inbytes ];
;
        LD      C,A
        XOR     A
        LD      B,A
        SBC     HL,BC
        LDIR
        POP     HL
        JP      BclLzw
;
;       length = index = 256;
;
CodeLzw01:                              ; Ici, A = B = 1
        XOR     A
        LD      C,A
        DEC     H
        LDIR
        POP     HL
        JP      BclLzw
