;
; Routine de dcompactage et d'affichage des images
; en "mode 3" gnres par ConvImgCPC V0.9
;
        ORG     #A400

Couleur EQU     #8000                   ; Les couleurs se trouvent juste
                                        ; aprs les donnes de l'image
ImgCmp  EQU     #1400                   ; Adresse image compacte

ImgDcmp EQU     #5C00

;
; REMARQUE - l'image dcompacte occupe #4800 octets (avec la palette de
; couleurs par ligne), il doit donc y avoir au moins #4800 octets entre
; l'adresse de l'image compacte et l'adresse de l'image dcompacte.
; C'est pourquoi, on a ici -> #1400 + #4800 = #5C00
; (Le buffer de dcompactage ne doit pas chevaucher l'image compacte)
;

        LD      HL,ImgCmp
        LD      DE,ImgDcmp
        CALL    DepkLzw                 ; Dcompactage
        LD      HL,ImgDcmp
        LD      DE,#4000                ; Replacer l'image en #4000
        LD      BC,#4800                ; Ainsi que la table des couleurs en #8000
        LDIR
        DI
        LD      HL,(#38)
        PUSH    HL                      ; Sauvegarde ancien vecteur #38
        LD      HL,#C9FB
        LD      (#38),HL                ; EI et RET en #38
        LD      BC,#BC0C
        OUT     (C),C
        LD      BC,#BD10                ; Passer adresse cran en #4000
        OUT     (C),C
        LD      HL,#57D1                ; Adresse de la valeur de la couleur 0
        LD      BC,#7F00
        OUT     (C),C                   ; Slectionner couleur 0
        OUTI                            ; Et affecter
Boucle:
        LD      B,#F5
WaitVBL:
        IN      A,(C)                   ; Attendre la VBL
        RRA
        JR      NC,WaitVBL
        CALL    TCLAV                   ; test clavier
        RLA                             ; touche espace (bit 7 dans flag C) ?
        JP      C,FIN                   ; si oui, fini
        EI
        HALT                            ; Attendre 2 interruptions
        HALT
        DI
        LD      B,158
Wait1:
        LD      HL,0                    ; Pause pour se synchroniser au dbut
        DJNZ    Wait1                   ; de l'cran visible
        XOR     A                       ; A = 0 pour tester fin des couleurs
        LD      BC,#7F01                ; C = ink 1
        LD      HL,Couleur
        LD      DE,#203                 ; D = ink 2, E = ink 3
SetCoul:
        OUT     (C),C                   ; ink 1
        OUTI
        OUT     (C),D                   ; ink 2
        OUTI
        OUT     (C),E                   ; ink 3
        OUTI
        NOP
        NOP                             ; Temps d'attente
        LD      BC,#7F01                ; Repositionner registre B
        OUT     (C),C                   ; ink 1
        OUTI
        OUT     (C),D                   ; ink 2
        OUTI
        OUT     (C),E                   ; ink 3
        OUTI
        CP      (HL)                    ; Valeur = 0 ?
        JR      NZ,SetCoul              ; Si non, on continue
        JR      Boucle                  ; Boucle attente touche

;
; Lecture clavier
;
TCLAV:
        XOR     A
        LD      BC,#F40E                ; Registre 14 du PSG
        OUT     (C),C
        LD      BC,#F6C0                ; Ecriture numro registre
        OUT     (C),C
        OUT     (C),A
        LD      BC,#F792                ; Port A PPI en lecture
        OUT     (C),C
        LD      BC,#F645                ; ligne = 5 (pour touche espace)
        OUT     (C),C
        LD      B,#F4                   ; Lecture registre
        IN      A,(C)
        CPL
        LD      BC,#F782                ; Repasse port A PPI en criture
        OUT     (C),C
        RET

Fin:
        DI
        POP      HL
        LD      (#38),HL                ; Restaurer ancien vecteur #38
        LD      BC,#BC0C
        OUT     (C),C
        LD      BC,#BD30                ; Repasser adresse cran en #C000
        OUT     (C),C
        EI
        RET

;
; Entre :
; - HL = Buffer (fichier compact)
; - DE = Destination
; Sortie :
; - AF, BC, DE, HL modifis
;
DepkLzw:
        XOR     A
        LD      (BclLzw+1),A
;
TstBitLzw:
        LD      A,(HL)
        INC     HL
        RRA                         ; Rotation rapide calcul seulement flag C
        SET     7,A                 ; Positionne bit 7 en gardant flag C
        LD      (BclLzw+1),A
        JR      C,TstCodeLzw

        LDI
;
BclLzw:
        LD      A,0
        RR      A                   ; Rotation avec calcul Flags C et Z
        LD      (BclLzw+1),A
        JR      Z,TstBitLzw
        JR      C,TstCodeLzw

        LDI
        JR      BclLzw
;
TstCodeLzw:
;
;       a = inbuffer[ inbytes ];
;
        LD      A,(HL)
        AND     A
;
; Plus d'octets  traiter
; = fini
;
        RET     Z

        INC     HL
        LD      B,A
        RLCA
        JR      NC,TstLzw40
;
;       length = 3 + ( ( inbuffer[ inbytes ] >> 4 ) & 7 );
;       index = ( inbuffer[ inbytes++ ] & 15 ) << 8;
;       index |= inbuffer[ inbytes++ ];
;       index++;
;
        PUSH    HL
        LD      C,(HL)                  ; C = poids faible index
        LD      L,B                     ; L = inbuffer[inbytes]
        RLCA
        RLCA
        RLCA
        AND     7
        ADD     A,3
        LD      H,A                     ; H = length
        LD      A,L
        AND     #0F
        LD      B,A                     ; B = poids fort index
        LD      A,H                     ; A = Length
        LD      H,D
        LD      L,E
        SBC     HL,BC
        DEC     HL
        LD      B,0
        LD      C,A
        LDIR
        POP     HL
        INC     HL
        JR      BclLzw
;
TstLzw40:
        RLCA
        JR      NC,TstLzw20
;
;       length = 2;
;       index = inbuffer[ inbytes++ ] & 0x3f;
;       index++;
;
        LD      C,B
        RES     6,C
        LD      B,0         ; BC = index -1, pas de +1 car flag C = 1
        PUSH    HL
        LD      H,D
        LD      L,E
        SBC     HL,BC
        LDI
        LDI
        POP     HL
        JR      BclLzw
;
TstLzw20:
        RLCA
        JR      NC,TstLzw10
;
;       length = 2 + ( inbuffer[ inbytes++ ] & 31 );
;       index = inbuffer[ inbytes++ ];
;       index++;
;
        PUSH    HL
        LD      A,B
        RES     5,A
        LD      C,(HL)                  ; C = index
        LD      B,0
        LD      H,D
        LD      L,E
        SBC     HL,BC
        ADD     A,2
        LD      C,A                     ; C = length
        LDIR
        POP     HL
        INC     HL
        JR      BclLzw

;
TstLzw10:
        RLCA
        JR      NC,CodeLzw0F
;
;       index = ( inbuffer[ inbytes++ ] & 15 ) << 8;
;       index |= inbuffer[ inbytes++ ];
;       length = inbuffer[ inbytes++ ] + 1;
;       index++;
;
        RES     4,B                     ; B = index(high)
        LD      C,(HL)                  ; C = index(low)
        INC     HL
        LD      A,(HL)                  ; A = length - 1
        PUSH    HL
        LD      H,D
        LD      L,E
        SBC     HL,BC                   ; Flag C=1 -> hl=hl-(bc+1)
        LD      B,0
        LD      C,A
        INC     BC                      ; BC = length
        LDIR
        POP     HL
        INC     HL
        JR      BclLzw
;
CodeLzw0F:
        PUSH    HL
        LD      A,B
        CP      #0F
        JR      NZ,CodeLzw02
;
;       length = index = inbuffer[ inbytes + 1 ] + 1;
;       inbytes += 2;
;
        LD      C,(HL)
        XOR     A
        LD      B,A
        INC     BC
        LD      H,D
        LD      L,E
        SBC     HL,BC
        LDIR
        POP     HL
        INC     HL
        JP      BclLzw
;
CodeLzw02:
        LD      H,D
        LD      L,E
        CP      2
        JR      C,CodeLzw01
;
;       length = index = inbuffer[ inbytes ];
;
        LD      C,A
        XOR     A
        LD      B,A
        SBC     HL,BC
        LDIR
        POP     HL
        JP      BclLzw
;
;       length = index = 256;
;
CodeLzw01:                              ; Ici, A = B = 1
        XOR     A
        LD      C,A
        DEC     H
        LDIR
        POP     HL
        JP      BclLzw
