#include  <afxwin.h>


typedef struct
    {
    BYTE b, v, r, a;
    } StRVB;


#include  "Constantes.h"


static int corr[ 4 ];

static char Msg[ 128 ];

static int RgbCPC[ 27 ] =
    {
     0x000000,                 // Noir              (0)
     0x00007F,                 // Bleu              (1)
     0x0000FF,                 // Bleu vif          (2)
     0x7F0000,                 // Rouge             (3)
     0x7F007F,                 // Magenta           (4)
     0x7F00FF,                 // Mauve             (5)
     0xFF0000,                 // Rouge vif         (6)
     0xFF007F,                 // Pourpre           (7)
     0xFF00FF,                 // Magenta vif       (8)
     0x007F00,                 // Vert              (9)
     0x007F7F,                 // Turquoise        (10)
     0x007FFF,                 // Bleu ciel        (11)
     0x7F7F00,                 // Jaune            (12)
     0x7F7F7F,                 // Blanc            (13)
     0x7F7FFF,                 // Bleu pastel      (14)
     0xFF7F00,                 // Orange           (15)
     0xFF7F7F,                 // Rose             (16)
     0xFF7FFF,                 // Magenta pastel   (17)
     0x00FF00,                 // Vert vif         (18)
     0x00FF7F,                 // Vert Marin       (19)
     0x00FFFF,                 // Turquoise vif    (20)
     0x7FFF00,                 // Vert citron      (21)
     0x7FFF7F,                 // Vert pastel      (22)
     0x7FFFFF,                 // Turquoise pastel (23)
     0xFFFF00,                 // Jaune vif        (24)
     0xFFFF7F,                 // Jaune Pastel     (25)
     0xFFFFFF                  // Blanc Brillant   (26)
    };


static void CalcDiff( int OldComp, int NewComp )
{
    int diff = OldComp - NewComp;
    int absdiff = abs( diff );
    corr[ 0 ] = corr[ 1 ] = corr[ 2 ] = corr[ 3 ] = 0;
    int sumdiff = absdiff;
    corr[ 0 ] = min(sumdiff, ( absdiff * 7 ) / 16 );
    sumdiff -= corr[ 0 ];
    corr[ 2 ] = min(sumdiff, ( absdiff * 5 ) / 16 );
    sumdiff -= corr[ 2 ];
    corr[ 1 ] = min(sumdiff, ( absdiff * 3 ) / 16 );
    sumdiff -= corr[ 1 ];
    corr[ 3 ] = min(sumdiff, ( absdiff * 1 ) / 16 );
    sumdiff -= corr[ 3 ];
    if ( diff < 0 )
        {
        corr[ 0 ] = -corr[ 0 ];
        corr[ 1 ] = -corr[ 1 ];
        corr[ 2 ] = -corr[ 2 ];
        corr[ 3 ] = -corr[ 3 ];
        }
}


static int ConvertComp( int comp )
{
    int diff = comp;

    if ( comp < 86 )
        comp = 0x00;
    else
        if ( comp < 171 )
            comp = 0x7F;
        else
            comp = 0xFF;

    CalcDiff( diff, comp );
    return( comp );
}


static void AddPixel( int * Bitmap, int x, int y, int corr, int comp, int Tx )
{
    int Mask = 0xFF << comp;
    for ( ; Tx--; )
        if ( x + Tx < TAILLE_X && y < TAILLE_Y && x + Tx >= 0 )
            {
            int * p = &Bitmap[ Tx + x + TAILLE_X * y ];
            int val = ( * p + ( corr << comp ) ) & Mask;
            * p &= ~Mask;
            * p |= val;
            }
}


static void SetPixel( int * Bitmap, int x, int y, int corr, int comp, int Tx )
{
    for ( ; Tx--; )
        if ( x + Tx < TAILLE_X && y < TAILLE_Y && x + Tx >= 0 )
            Bitmap[ Tx + x + TAILLE_X * y ] = ( corr << comp );
}


static void AddPixelCor( int * Bitmap
                       , int x
                       , int y
                       , int corr[ 4 ]
                       , int comp
                       , int Tx
                       )
{
    if ( x >= Tx )
        AddPixel( Bitmap, x - Tx, y + 2, corr[ 0 ], comp, Tx );

    AddPixel( Bitmap, x + Tx, y, corr[ 1 ], comp, Tx );
    AddPixel( Bitmap, x, y + 2, corr[ 2 ], comp, Tx );
    AddPixel( Bitmap, x + Tx, y + 2, corr[ 3 ], comp, Tx );
}


//
// Recherche la couleur la plus proche de la couleur 'p' (24 bits)
// dans la palette du cpc
//
static int RechercheProche( int p, int CMax[ 16 ], int maxCoul )
{
    int Dist, OldDist = 0x7FFFFFF;
    int Choix = 0;
    for ( int i = 0; i < maxCoul; i++ )
        {
        StRVB * s = ( StRVB * )&p;
        StRVB * d = ( StRVB * )&RgbCPC[ CMax[ i ] ];
        Dist = abs( s->r - d->r ) * 299
             + abs( s->v - d->v ) * 587
             + abs( s->b - d->b ) * 114;
        if ( Dist < OldDist )
            {
            OldDist = Dist;
            Choix = i;
            }
        }
    return( RgbCPC[ CMax[ Choix ] ] );
}


//
// Passe 1 : Rduit les composantes R, V, B de 256 valeurs  3 valeurs
// Effectue galement un traitement de l'erreur si demand.
//
static void Passe1( int * Bitmap, int correct1, int Tx )
{
    for ( int y = 0; y < TAILLE_Y; y += 2 )
        for ( int x = 0; x < TAILLE_X; x += Tx )
            for ( int i = 0; i < Tx; i++ )
                {
                StRVB p1 = * ( StRVB * )&Bitmap[ x + TAILLE_X * y ];
                p1.r = ConvertComp( p1.r );
                SetPixel( Bitmap, x, y, p1.r, 16, Tx );
                if ( correct1 )
                    AddPixelCor( Bitmap, x, y, corr, 16, Tx );

                p1.v = ConvertComp( p1.v );
                AddPixel( Bitmap, x, y, p1.v, 8, Tx );
                if ( correct1 )
                    AddPixelCor( Bitmap, x, y, corr, 8, Tx );

                p1.b = ConvertComp( p1.b );
                AddPixel( Bitmap, x, y, p1.b, 0, Tx );
                if ( correct1 )
                    AddPixelCor( Bitmap, x, y, corr, 0, Tx );
                }
}


//
// Calcule le nombre de couleurs utilises dans l'image, et
// remplit un tableau avec ces couleurs
//
static int CalcNbCoul( int * Bitmap, int Tx, int Coul[ 27 ] )
{
    for ( int y = 0; y < TAILLE_Y; y+= 2 )
        for ( int x = 0; x < TAILLE_X; x += Tx )
            {
            BOOL Trouve = FALSE;
            int c = Bitmap[ x + TAILLE_X * y ];
            for ( int i = 0; i < 27; i++ )
                {
                if ( c == RgbCPC[ i ] )
                    {
                    Coul[ i ]++;
                    Trouve = TRUE;
                    }
                }
            }
    int NbCol = 0;
    for ( int i = 0; i < 27; i++ )
        if ( Coul[ i ] )
            NbCol++;

    return( NbCol );
}


//
// Recherche les x couleurs les plus utilises parmis les 27 possibles
//
static void RechercheCMax( int MaxCol
                         , int Coul[ 27 ]
                         , int CMax[ 16 ]
                         , int Bloque[ 16 ]
                         )
{
    for ( int x = 0; x < MaxCol; x++ )
        {
        if ( Bloque[ x ] )
            Coul[ CMax[ x ] ] = 0;
        }
    for ( x = 0; x < MaxCol; x++ )
        {
        int valMax = 0;
        if ( ! Bloque[ x ] )
            {
            for ( int i = 0; i < 27; i++ )
                {
                if ( valMax < Coul[ i ] )
                    {
                    valMax = Coul[ i ];
                    CMax[ x ] = i;
                    }
                }
            Coul[ CMax[ x ] ] = 0;
            }
        }
}


//
// Passe 2 : rduit l'image  X couleurs.
// Effectue galement un traitement de l'erreur si demand.
//
static void Passe2( int * Bitmap
                  , int correct2
                  , int Tx
                  , int CMax[ 16 ]
                  , int MaxCol
                  )
{
    for ( int y = 0; y < TAILLE_Y; y += 2 )
        for ( int x = 0; x < TAILLE_X; x += Tx )
            for ( int i = 0; i < Tx; i++ )
                {
                StRVB p1 = * ( StRVB * )&Bitmap[ x + TAILLE_X * y ];
                int q = RechercheProche( * ( int * )&p1, CMax, MaxCol );
                StRVB * q1 = ( StRVB * )&q;
                SetPixel( Bitmap, x, y, q, 0, Tx );
                if ( correct2 )
                    {
                    CalcDiff( p1.r, q1->r );
                    AddPixelCor( Bitmap, x, y, corr, 16, Tx );
                    CalcDiff( p1.v, q1->v );
                    AddPixelCor( Bitmap, x, y, corr, 8, Tx );
                    CalcDiff( p1.b, q1->b );
                    AddPixelCor( Bitmap, x, y, corr, 0, Tx );
                    }
                }
}


//
// Lissage du bitmap en fonction de la rsolution du CPC :
// 160x200 en Mode 0, 320x200 en Mode 1, 640x200 en Mode 2
//
static void LisseBitmap( int * Bitmap, int Tx )
{
    for ( int y = 0; y < TAILLE_Y; y += 2 )
        for ( int x = 0; x < TAILLE_X; x += Tx )
            for ( int i = 0; i < Tx; i++ )
                Bitmap[ i + x + TAILLE_X * y ] =
                Bitmap[ TAILLE_X + i + x + TAILLE_X * y ] = Bitmap[ x + TAILLE_X * y ];
}


void Convert( CListBox * Liste
            , int correct1
            , int correct2
            , int Mode
            , int * Bitmap
            , int CMax[ 16 ]
            , int Bloque[ 16 ]
            )
{
    int Coul[ 27 ];
    int Tx = 4 >> Mode, MaxCol;

    switch( Mode )
        {
        case 0 :
            MaxCol = 16;
            break;

        case 1 :
            MaxCol = 4;
            break;

        case 2 :
            MaxCol = 2;
        }
    Liste->AddString( "Calcul passe 1..." );
    Liste->SetTopIndex( Liste->GetCount() - 1 );
    Liste->UpdateWindow();
    Passe1( Bitmap, correct1, Tx );

    Liste->AddString( "Calcul du nombre de couleurs..." );
    Liste->SetTopIndex( Liste->GetCount() - 1 );
    Liste->UpdateWindow();
    memset( Coul, 0, 27 * sizeof( int ) );
    int NbCol = CalcNbCoul( Bitmap, Tx, Coul );
    wsprintf( Msg, "Nombre de couleurs diffrentes : %d/27", NbCol );
    Liste->AddString( Msg );

    if ( NbCol > MaxCol )
        {
        wsprintf( Msg, "Recherche des %d couleurs les plus utilises...", MaxCol );
        Liste->AddString( Msg );
        Liste->SetTopIndex( Liste->GetCount() - 1 );
        Liste->UpdateWindow();
        for ( int i = 0; i < 16; i++ )
            if ( ! Bloque[ i ] )
                CMax[ i ] = 0;

        RechercheCMax( MaxCol, Coul, CMax, Bloque );
        wsprintf( Msg, "%d couleurs les plus utilises : ", MaxCol );
        for ( i = 0; i < MaxCol; i++ )
            {
            char Tmp[ 16 ];
            if ( ! Bloque[ i ] )
                wsprintf( Tmp, "%d ", CMax[ i ] );
            else
                wsprintf( Tmp, "<%d> ", CMax[ i ] );

            strcat( Msg, Tmp );
            }
        Liste->AddString( Msg );

        Liste->AddString( "Calcul passe 2..." );
        Liste->SetTopIndex( Liste->GetCount() - 1 );
        Liste->UpdateWindow();
        Passe2( Bitmap, correct2, Tx, CMax, MaxCol );
        }

    LisseBitmap( Bitmap, Tx );
    Liste->AddString( "Calcul termin." );
    Liste->SetTopIndex( Liste->GetCount() - 1 );
    Liste->UpdateWindow();
}


static BYTE AdjComp( int Comp )
{
    if ( Comp < 0 )
        Comp = 0;

    if ( Comp > 255 )
        Comp = 255;

    return( ( BYTE )Comp );
}


void AjusteContraste( int * Bitmap, int contraste )
{
    for ( int y = 0; y < TAILLE_Y; y++ )
        for ( int x = 0; x < TAILLE_X; x++ )
            {
            StRVB p1 = * ( StRVB * )&Bitmap[ x + TAILLE_X * y ];
            p1.r = AdjComp( p1.r * contraste / 100 );
            p1.v = AdjComp( p1.v * contraste / 100 );
            p1.b = AdjComp( p1.b * contraste / 100 );
            Bitmap[ x + TAILLE_X * y ] = * ( int * )&p1;
            }
}


static int GetCPCCol( int c24 )
{
    for ( int i = 0; i < 27; i++ )
        if ( c24 == RgbCPC[ i ] )
            return( i );

    return( -1 );
}


BYTE GetCPCPoint( int Palette[ 16 ], int c24 )
{
    for ( int i = 0; i < 16; i++ )
        if ( Palette[ i ] == GetCPCCol( c24 ) )
            return( ( BYTE )i );

    return( 0xFF );
}


int GetRgbCPC( int Coul )
{
    if ( Coul >= 0 && Coul < 27 )
        {
        int i = RgbCPC[ Coul ];
        return( ( ( i & 0xFF ) << 16 ) | ( i & 0xFF00 ) | ( i >> 16 ) );
        }
    return( -1 );
}
