#include  <afxwin.h>

#include  "Conversion.h"


static BYTE RoutineAffiche[ 48 ] =     // Routine  mettre en #C7D0
    {
    0x3A, 0xD0, 0xD7,       //      LD      A,  (#D7D0)
    0xCD, 0x1C, 0xBD,       //      CALL    #BD1C
    0x21, 0xD1, 0xD7,       //      LD      HL, #D7D1
    0x46,                   //      LD      B,  (HL)
    0x48,                   //      LD      C,  B
    0xCD, 0x38, 0xBC,       //      CALL    #BC38
    0xAF,                   //      XOR     A
    0x21, 0xD1, 0xD7,       //      LD      HL, #D7D1
    0x46,                   // BCL: LD      B,  (HL)
    0x48,                   //      LD      C,  B
    0xF5,                   //      PUSH    AF
    0xE5,                   //      PUSH    HL
    0xCD, 0x32, 0xBC,       //      CALL    #BC32
    0xE1,                   //      POP     HL
    0xF1,                   //      POP     AF
    0x23,                   //      INC     HL
    0x3C,                   //      INC     A
    0xFE, 0x10,             //      CP      #10
    0x20, 0xF1,             //      JR      NZ,BCL
    0xC3, 0x18, 0xBB,       //      JP      #BB18
    };


static BYTE ModeCouleur[ 48 ];


typedef struct
    {
    BYTE    UserNumber;             // User
    BYTE    FileName[ 15 ];         // Nom + extension
    BYTE    BlockNum;               // Numro du premier bloc (disquette)
    BYTE    LastBlock;              // Numro du dernier bloc (disquette)
    BYTE    FileType;               // Type de fichier
    USHORT  Length;                 // Longueur
    USHORT  Adress;                 // Adresse
    BYTE    FirstBlock;             // Premier bloc de fichier (disquette)
    USHORT  LogicalLength;          // Longueur logique
    USHORT  EntryAdress;            // Point d'entre
    BYTE    Unused[ 0x24 ];
    USHORT  RealLength;             // Longueur relle
    BYTE    BigLength;              // Longueur relle (3 octets)
    USHORT  CheckSum;               // Checksum Amsdos
    BYTE    Unused2[ 0x3B ];
    } StAmsdos;


static BYTE MemBloc[ 2000 ];


static void CreeEntete( FILE * fp, char * NomFic )
{
    static char Nom[ 12 ];
    static StAmsdos Entete;
    int Checksum = 0;

    memset( &Entete, 0, sizeof( Entete ) );
    memset( Nom, 0, sizeof( Nom ) );
    char * p = NULL;
    do
        {
        p = strchr( NomFic, '\\' );
        if ( p )
            NomFic = ++p;
        }
    while( p );
    p = strchr( NomFic, '.' );
    if ( p )
        * p++ = 0;

    int l = strlen( NomFic );
    if ( l > 8 )
        l = 8;

    for ( int i = 0; i < l; i++ )
        Nom[ i ] = toupper( NomFic[ i ] );

    if ( p )
        for ( i = 0; i < 3; i++ )
            Nom[ i + 8 ] = toupper( p[ i ] );

    memcpy( Entete.FileName, Nom, 11 );
    BYTE * pEntete = ( BYTE * )&Entete;
    Entete.Adress = 0xC000;
    Entete.Length = Entete.RealLength = Entete.LogicalLength = 0x4000;
    Entete.FileType = 2;
    Entete.EntryAdress = 0xC7D0;

    for ( i = 0; i < 67; i++ )
        Checksum += * pEntete++;

    Entete.CheckSum = ( USHORT )Checksum;
    fwrite( &Entete, sizeof( Entete ), 1, fp );
}


static void SauveEcran( int * Bitmap, int Mode, int Palette[ 16 ], FILE * fp )
{
    BYTE Pix0, Pix1, Pix2, Pix3, Pix4, Pix5, Pix6, Pix7;

    for ( int Block = 0; Block < 8; Block++ )
        {
        for ( int y = 0; y < 25; y++ )
            for ( int x = 0; x < 80; x++ )
                {
                int l = x * 8 + 1280 * ( Block + y * 8 );
                Pix0 = GetCPCPoint( Palette, Bitmap[ l ] );
                switch( Mode )
                    {
                    case 0 :
                        Pix1 = GetCPCPoint( Palette, Bitmap[ 4 + l ] );
                        MemBloc[ x + 80 * y ] = ( ( Pix0 & 1 ) << 7 ) +
                                                ( ( Pix0 & 2 ) << 2 ) +
                                                ( ( Pix0 & 4 ) << 3 ) +
                                                ( ( Pix0 & 8 ) >> 2 ) +
                                                ( ( Pix1 & 1 ) << 6 ) +
                                                ( ( Pix1 & 2 ) << 1 ) +
                                                ( ( Pix1 & 4 ) << 2 ) +
                                                ( ( Pix1 & 8 ) >> 3 );
                        break;

                    case 1 :
                        Pix1 = GetCPCPoint( Palette, Bitmap[ 2 + l ] );
                        Pix2 = GetCPCPoint( Palette, Bitmap[ 4 + l ] );
                        Pix3 = GetCPCPoint( Palette, Bitmap[ 6 + l ] );
                        MemBloc[ x + 80 * y ] = ( ( Pix0 & 1 ) << 7 ) +
                                                ( ( Pix0 & 2 ) << 2 ) +
                                                ( ( Pix1 & 1 ) << 6 ) +
                                                ( ( Pix1 & 2 ) << 1 ) +
                                                ( ( Pix2 & 1 ) << 5 ) +
                                                ( Pix2 & 2 ) +
                                                ( ( Pix3 & 1 ) << 4 ) +
                                                ( ( Pix3 & 2 ) >> 1 );
                        break;

                    case 2 :
                        Pix1 = GetCPCPoint( Palette, Bitmap[ 1 + l ] );
                        Pix2 = GetCPCPoint( Palette, Bitmap[ 2 + l ] );
                        Pix3 = GetCPCPoint( Palette, Bitmap[ 3 + l ] );
                        Pix4 = GetCPCPoint( Palette, Bitmap[ 4 + l ] );
                        Pix5 = GetCPCPoint( Palette, Bitmap[ 5 + l ] );
                        Pix6 = GetCPCPoint( Palette, Bitmap[ 6 + l ] );
                        Pix7 = GetCPCPoint( Palette, Bitmap[ 7 + l ] );
                        MemBloc[ x + 80 * y ] = ( Pix0 << 7 ) +
                                                ( Pix1 << 6 ) +
                                                ( Pix2 << 5 ) +
                                                ( Pix3 << 4 ) +
                                                ( Pix4 << 3 ) +
                                                ( Pix5 << 2 ) +
                                                ( Pix6 << 1 ) +
                                                Pix7;
                        break;
                    }
                }
        fwrite( MemBloc, sizeof( MemBloc ), 1, fp );
        if ( ! Block )
            fwrite( RoutineAffiche, sizeof( RoutineAffiche ), 1, fp );
        else
            fwrite( ModeCouleur, sizeof( ModeCouleur ), 1, fp );
        }
}


BOOL SauveCPC( char * NomFic, int * Bitmap, int Mode, int Palette[ 16 ] )
{
    ModeCouleur[ 0 ] = Mode;
    for ( int i = 0; i < 16; i++ )
        ModeCouleur[ 1 + i ] = Palette[ i ];

    FILE * fp = fopen( NomFic, "wb" );
    if ( fp )
        {
        CreeEntete( fp, NomFic );
        SauveEcran( Bitmap, Mode, Palette, fp );
        fclose( fp );
        return( TRUE );
        }
    return( FALSE );
}
