/*-----------------------------------------------------------------------------

	ST-Sound ( YM files player library )

	Copyright (C) 1995-1999 Arnaud Carre ( http://leonard.oxg.free.fr )

	ST-Sound library "C-like" interface wrapper

-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------

	This file is part of ST-Sound

	ST-Sound is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	ST-Sound is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with ST-Sound; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

-----------------------------------------------------------------------------*/


#include "YmMusic.h"

typedef void		YMMUSIC;
#define	NULL		(0L)

YMMUSIC	*	ymMusicLoad(char *fName)
{
	CYmMusic *pMusic = new CYmMusic;
	if (pMusic)
	{
		if (!pMusic->load(fName))
		{
			delete pMusic;
			return NULL;
		}
	}
	return pMusic;
}

YMMUSIC	*	ymMusicLoadMemory(void *pBlock,unsigned long size)
{
	CYmMusic *pMusic = new CYmMusic;
	if (pMusic)
	{
		if (!pMusic->loadMemory(pBlock,size))
		{
			delete pMusic;
			return NULL;
		}
	}
	return pMusic;
}

void	ymMusicUnload(YMMUSIC *_pMus)
{
	CYmMusic *pMusic = (CYmMusic*)_pMus;
	pMusic->unLoad();
	delete pMusic;
}

YM_BOOL	ymMusicCompute(YMMUSIC *_pMus,YM_SAMPLE *pBuffer,int nbSample)
{
	CYmMusic *pMusic = (CYmMusic*)_pMus;
	return pMusic->update(pBuffer,nbSample);
}

void	ymMusicSetLoopMode(YMMUSIC *_pMus,YM_BOOL bLoop)
{
	CYmMusic *pMusic = (CYmMusic*)_pMus;
	pMusic->setLoopMode(bLoop);
}

char	*ymMusicGetLastError(YMMUSIC *_pMus)
{
	CYmMusic *pMusic = (CYmMusic*)_pMus;
	return pMusic->getLastError();
}

int		ymMusicGetRegister(YMMUSIC *_pMus,int reg)
{
	CYmMusic *pMusic = (CYmMusic*)_pMus;
	return pMusic->readYmRegister(reg);
}

void	ymMusicGetInfo(YMMUSIC *_pMus,ymMusicInfo_t *pInfo)
{
	CYmMusic *pMusic = (CYmMusic*)_pMus;
	pMusic->getMusicInfo(pInfo);
}

void	ymMusicPlay(YMMUSIC *_pMus)
{
	CYmMusic *pMusic = (CYmMusic*)_pMus;
	pMusic->play();
}

void	ymMusicPause(YMMUSIC *_pMus)
{
	CYmMusic *pMusic = (CYmMusic*)_pMus;
	pMusic->pause();
}

void	ymMusicStop(YMMUSIC *_pMus)
{
	CYmMusic *pMusic = (CYmMusic*)_pMus;
	pMusic->stop();
}

YM_BOOL		ymMusicIsSeekable(YMMUSIC *_pMus)
{
	CYmMusic *pMusic = (CYmMusic*)_pMus;
	return pMusic->isSeekable() ? YM_TRUE : YM_FALSE;
}

unsigned long	ymMusicGetPos(YMMUSIC *_pMus)
{
	CYmMusic *pMusic = (CYmMusic*)_pMus;
	if (!pMusic->isSeekable())
		return 0;

	return pMusic->getPos();
}

void		ymMusicSeek(YMMUSIC *_pMus,unsigned long timeInMs)
{
	CYmMusic *pMusic = (CYmMusic*)_pMus;
	if (pMusic->isSeekable())
	{
		pMusic->setMusicTime(timeInMs);
	}
}
