/*-----------------------------------------------------------------------------

	ST-Sound ( YM files player library )

	Copyright (C) 1995-1999 Arnaud Carre ( http://leonard.oxg.free.fr )

	Manage YM file depacking and parsing

-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------

	This file is part of ST-Sound

	ST-Sound is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	ST-Sound is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with ST-Sound; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

-----------------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "YmMusic.h"
#include "Depacker.h"

static	unsigned short ymVolumeTable[16] =
{	62,161,265,377,580,774,1155,1575,2260,3088,4570,6233,9330,13187,21220,32767};


static	void	signeSample(unsigned char *ptr,long size)
{

		if (size>0)
		{
			do
			{
				*ptr++ ^= 0x80;
			}
			while (--size);
		}
}

char	*mstrdup(char *in)
{
		char *out = (char*)malloc(strlen(in)+1);
		if (out) strcpy(out,in);
		return out;
}

UD      readMotorolaDword(UB **ptr)
{
UD n;
UB *p = *ptr;

        n = (p[0]<<24)|(p[1]<<16)|(p[2]<<8)|p[3];
        p+=4;
        *ptr = p;
        return n;
}

UW      readMotorolaWord(UB **ptr)
{
UW n;
UB *p = *ptr;

        n = (p[0]<<8)|p[1];
        p+=2;
        *ptr = p;
        return n;
}

char    *readNtString(char **ptr)
{
char *p;

		p = mstrdup(*ptr);
		(*ptr) += strlen(*ptr)+1;
        return p;
}

unsigned char	*CYmMusic::depackFile(void)
 {
 lzhHeader_t *pHeader;
 UB	*pNew;
 UB	*pSrc;

		pHeader = (lzhHeader_t*)pBigMalloc;

		if ((pHeader->size==0) ||
			(strncmp(pHeader->id,"-lh5-",5)))
		{ // Le fichier n'est pas compresse, on retourne l'original.
			return pBigMalloc;
		}

		fileSize = (UD)-1;

		if (pHeader->level != 0)
		{ // Compression LH5, header !=0 : Error.
			free(pBigMalloc);
			pBigMalloc = NULL;
			setLastError("LHARC Header must be 0 !");
			return NULL;
		}

		fileSize = pHeader->original;
		pNew = (UB*)malloc(pHeader->original);
		if (!pNew)
		{
			setLastError("MALLOC Failed !");
			free(pBigMalloc);
			pBigMalloc = NULL;
			return NULL;
		}

		pSrc = pBigMalloc+sizeof(lzhHeader_t)+pHeader->name_lenght;

		// Gros patch: PAS BO DU TOUT mais tant pis !!
//		*((UD*)pSrc) = pHeader->original;

		pSrc += 2;		// skip CRC16

		if (!LzhDepackBlock(pSrc,pNew,pHeader->original))
		{
			setLastError("LH5 Depacking Error !");
			free(pNew);
			free(pBigMalloc);
			pNew = NULL;
			pBigMalloc = NULL;
			return NULL;
		}

		// Tout est bon, le fichier est depack, on free le bloque
		// pack et on retourne le nouveau...
		free(pBigMalloc);
		return pNew;
 }





static size_t	fileSizeGet(FILE *h)
 {
 size_t size;
 size_t old;

		old = ftell(h);
		fseek(h,0,SEEK_END);
		size = ftell(h);
		fseek(h,old,SEEK_SET);
		return size;
 }


YM_BOOL	CYmMusic::deInterleave(void)
 {
 long	nextPlane[32];
 UB	*pW,*tmpBuff;
 long	j,k;


		if (attrib&A_STREAMINTERLEAVED)
		{

			tmpBuff = (UB*)malloc(nbFrame*streamInc);
			if (!tmpBuff)
			{
				setLastError("Malloc error in deInterleave()\n");
				return YM_FALSE;
			}

			// Precalcul les offsets.
			for (j=0;j<streamInc;j++) nextPlane[j] = nbFrame*j;

			pW = tmpBuff;
			for (j=0;j<nextPlane[1];j++)
			{
				for (k=0;k<streamInc;k++)
				{
					pW[k] = pDataStream[j + nextPlane[k]];
				}
				pW += streamInc;
			}

			free(pBigMalloc);
			pBigMalloc = tmpBuff;
			pDataStream = tmpBuff;

			attrib &= (~A_STREAMINTERLEAVED);
		}
		return TRUE;
 }



YM_BOOL	CYmMusic::ymDecode(void)
 {
 ymHeader_t *pHeader;
 UD *pUD;
 UB	*ptr;
 int skip;
 int i;
 unsigned long sampleSize;
 long tmp;


		pHeader = (ymHeader_t*)pBigMalloc;
		switch (pHeader->id)
		{
			case '!2MY':		// MADMAX specific.
				songType = YM_V2;
				nbFrame = (fileSize-4)/14;
				loopFrame = 0;
				ymChip.setClock(ATARI_CLOCK);
				setPlayerRate(50);
				pDataStream = pBigMalloc+4;
				streamInc = 14;
				nbDrum = 0;
				setAttrib(A_STREAMINTERLEAVED|A_TIMECONTROL);
				pSongName = "";
				pSongAuthor = mstrdup("Unkonwn");
				pSongComment = mstrdup("Converted by Leonard.");
				pSongType = mstrdup("YM 2");
				pSongPlayer = mstrdup("YM-Chip driver.");
				break;

			case '!3MY':		// Standart YM-Atari format.
				songType = YM_V3;
				nbFrame = (fileSize-4)/14;
				loopFrame = 0;
				ymChip.setClock(ATARI_CLOCK);
				setPlayerRate(50);
				pDataStream = pBigMalloc+4;
				streamInc = 14;
				nbDrum = 0;
				setAttrib(A_STREAMINTERLEAVED|A_TIMECONTROL);
				pSongName = ""; //mstrdup(tmpFName);
				pSongAuthor = mstrdup("Unkonwn");
				pSongComment = mstrdup("");
				pSongType = mstrdup("YM 3");
				pSongPlayer = mstrdup("YM-Chip driver.");
				break;

			case 'b3MY':		// Standart YM-Atari format + Loop info.
				pUD = (UD*)(pBigMalloc+fileSize-4);
				songType = YM_V3;
				nbFrame = (fileSize-4)/14;
				loopFrame = *pUD;
				ymChip.setClock(ATARI_CLOCK);
				setPlayerRate(50);
				pDataStream = pBigMalloc+4;
				streamInc = 14;
				nbDrum = 0;
				setAttrib(A_STREAMINTERLEAVED|A_TIMECONTROL);
				pSongName = ""; //mstrdup(tmpFName);
				pSongAuthor = mstrdup("Unkonwn");
				pSongComment = mstrdup("");
				pSongType = mstrdup("YM 3b (loop)");
				pSongPlayer = mstrdup("YM-Chip driver.");
				break;

			case '!4MY':		// Extended ATARI format.
				setLastError("No more YM4! support. Use YM5! format.");
				return YM_FALSE;
				break;

			case '!5MY':		// Extended YM2149 format, all machines.
			case '!6MY':		// Extended YM2149 format, all machines.
				if (strncmp((const char*)(pBigMalloc+4),"LeOnArD!",8))
				{
					setLastError("Not a valid YM format !");
					return YM_FALSE;
				}
				ptr = pBigMalloc+12;
				nbFrame = readMotorolaDword(&ptr);
				setAttrib(readMotorolaDword(&ptr));
				nbDrum = readMotorolaWord(&ptr);
				ymChip.setClock(readMotorolaDword(&ptr));
				setPlayerRate(readMotorolaWord(&ptr));
				loopFrame = readMotorolaDword(&ptr);
				skip = readMotorolaWord(&ptr);
				ptr += skip;
				if (nbDrum>0)
				{
					pDrumTab=(digiDrum_t*)malloc(nbDrum*sizeof(digiDrum_t));
					for (i=0;i<nbDrum;i++)
					{
						pDrumTab[i].size = readMotorolaDword(&ptr);
						if (pDrumTab[i].size)
						{
							pDrumTab[i].pData = (UB*)malloc(pDrumTab[i].size);
							memcpy(pDrumTab[i].pData,ptr,pDrumTab[i].size);
							if (attrib&A_DRUM4BITS)
							{
								UD j;
								UB *pw = pDrumTab[i].pData;
								for (j=0;j<pDrumTab[i].size;j++)
								{
									*pw++ = ymVolumeTable[(*pw)&15]>>7;
								}
							}
							ptr += pDrumTab[i].size;
						}
						else
						{
							pDrumTab[i].pData = NULL;
						}
					}
					attrib &= (~A_DRUM4BITS);
				}
				pSongName = readNtString((char**)&ptr);
				pSongAuthor = readNtString((char**)&ptr);
				pSongComment = readNtString((char**)&ptr);
				songType = YM_V5;
				if (pHeader->id=='!6MY')
				{
					songType = YM_V6;
					pSongType = mstrdup("YM 6");
				}
				else
				{
					pSongType = mstrdup("YM 5");
				}
				pDataStream = ptr;
				streamInc = 16;
				setAttrib(A_STREAMINTERLEAVED|A_TIMECONTROL);
				pSongPlayer = mstrdup("YM-Chip driver.");
				break;

			case '1XIM':		// ATARI Remix digit format.

				if (strncmp((const char*)(pBigMalloc+4),"LeOnArD!",8))
				{
					setLastError("Not a valid YM format !");
					return YM_FALSE;
				}
				ptr = pBigMalloc+12;
				songType = YM_MIX1;
				tmp = readMotorolaDword(&ptr);
				setAttrib(0);
				if (tmp&1) setAttrib(A_DRUMSIGNED);
				sampleSize = readMotorolaDword(&ptr);
				nbMixBlock = readMotorolaDword(&ptr);
				pMixBlock = (mixBlock_t*)malloc(nbMixBlock*sizeof(mixBlock_t));
				for (i=0;i<nbMixBlock;i++)
				{	// Lecture des block-infos.
					pMixBlock[i].sampleStart = readMotorolaDword(&ptr);
					pMixBlock[i].sampleLength = readMotorolaDword(&ptr);
					pMixBlock[i].nbRepeat = readMotorolaWord(&ptr);
					pMixBlock[i].replayFreq = readMotorolaWord(&ptr);
				}
				pSongName = readNtString((char**)&ptr);
				pSongAuthor = readNtString((char**)&ptr);
				pSongComment = readNtString((char**)&ptr);

				pBigSampleBuffer = (unsigned char*)malloc(sampleSize);
				memcpy(pBigSampleBuffer,ptr,sampleSize);

				if (!(attrib&A_DRUMSIGNED))
				{
					signeSample(pBigSampleBuffer,sampleSize);
					setAttrib(A_DRUMSIGNED);
				}

				mixPos = -1;		// numero du block info.
				pSongType = mstrdup("MIX1");
				pSongPlayer = mstrdup("Digi-Mix driver.");

				break;

			case '1TMY':		// YM-Tracker
			case '2TMY':		// YM-Tracker
/*;
; Format du YM-Tracker-1
;
; 4  YMT1
; 8  LeOnArD!
; 2  Nb voice
; 2  Player rate
; 4  Music lenght
; 4  Music loop
; 2  Nb digidrum
; 4  Flags		; Interlace, signed, 8 bits, etc...
; NT Music Name
; NT Music author
; NT Music comment
; nb digi *
*/
				if (strncmp((const char*)(pBigMalloc+4),"LeOnArD!",8))
				{
					setLastError("Not a valid YM format !");
					return YM_FALSE;
				}
				ptr = pBigMalloc+12;
				songType = YM_TRACKER1;
				nbVoice = readMotorolaWord(&ptr);
				setPlayerRate(readMotorolaWord(&ptr));
				nbFrame= readMotorolaDword(&ptr);
				loopFrame = readMotorolaDword(&ptr);
				nbDrum = readMotorolaWord(&ptr);
				attrib = readMotorolaDword(&ptr);
				pSongName = readNtString((char**)&ptr);
				pSongAuthor = readNtString((char**)&ptr);
				pSongComment = readNtString((char**)&ptr);
				if (nbDrum>0)
				{
					pDrumTab=(digiDrum_t*)malloc(nbDrum*sizeof(digiDrum_t));
					for (i=0;i<(int)nbDrum;i++)
					{
						pDrumTab[i].size = readMotorolaWord(&ptr);
						pDrumTab[i].repLen = pDrumTab[i].size;
						if (pHeader->id=='2TMY')
						{
							pDrumTab[i].repLen = readMotorolaWord(&ptr);	// repLen
							readMotorolaWord(&ptr);		// flag
						}
						if (pDrumTab[i].repLen>pDrumTab[i].size)
						{
							pDrumTab[i].repLen = pDrumTab[i].size;
						}

						if (pDrumTab[i].size)
						{
							pDrumTab[i].pData = (UB*)malloc(pDrumTab[i].size);
							memcpy(pDrumTab[i].pData,ptr,pDrumTab[i].size);
							ptr += pDrumTab[i].size;
						}
						else
						{
							pDrumTab[i].pData = NULL;
						}
					}
				}

				ymTrackerFreqShift = 0;
				if (pHeader->id=='2TMY')
				{
					ymTrackerFreqShift = (attrib>>28)&15;
					attrib &= 0x0fffffff;
					pSongType = mstrdup("YM-T2");
				}
				else
				{
					pSongType = mstrdup("YM-T1");
				}


				pDataStream = ptr;
				ymChip.setClock(ATARI_CLOCK);

				ymTrackerInit(100);		// 80% de volume maxi.
				streamInc = 16;
				setTimeControl(YM_TRUE);
				pSongPlayer = mstrdup("Universal Tracker");
				break;

			default:
				setLastError("Unknow YM format !");
				return YM_FALSE;
				break;
		}

		if (!deInterleave())
		{
			return YM_FALSE;
		}

		return YM_TRUE;
 }


YM_BOOL	CYmMusic::load(char *fileName)
{
FILE	*in;


		stop();
		unLoad();

		in = fopen(fileName,"rb");
		if (!in)
		{
			setLastError("File not Found");
			return NULL;
		}

		//---------------------------------------------------
		// Allocation d'un buffer pour lire le fichier.
		//---------------------------------------------------
		fileSize = fileSizeGet(in);
		pBigMalloc = (unsigned char*)malloc(fileSize);
		if (!pBigMalloc)
		{
			setLastError("MALLOC Error");
			fclose(in);
			return YM_FALSE;
		}

		//---------------------------------------------------
		// Chargement du fichier complet.
		//---------------------------------------------------
		if (fread(pBigMalloc,1,fileSize,in)!=fileSize)
		{
			free(pBigMalloc);
			setLastError("File is corrupted.");
			fclose(in);
			return YM_FALSE;
		}
		fclose(in);

		//---------------------------------------------------
		// Transforme les donnes en donnes valides.
		//---------------------------------------------------
//		pMus->fileSize = fileSize;
		pBigMalloc = depackFile();
		if (!pBigMalloc)
		{
			return YM_FALSE;
		}

		//---------------------------------------------------
		// Lecture des donnes YM:
		//---------------------------------------------------
		if (!ymDecode())
		{
			free(pBigMalloc);
			pBigMalloc = NULL;
			return YM_FALSE;
		}

		ymChip.reset();
		bMusicOk = YM_TRUE;
		bPause = YM_FALSE;
		return YM_TRUE;
 }

YM_BOOL	CYmMusic::loadMemory(void *pBlock,unsigned long size)
{


		stop();
		unLoad();

		//---------------------------------------------------
		// Allocation d'un buffer pour lire le fichier.
		//---------------------------------------------------
		fileSize = size;
		pBigMalloc = (unsigned char*)malloc(fileSize);
		if (!pBigMalloc)
		{
			setLastError("MALLOC Error");
			return YM_FALSE;
		}

		//---------------------------------------------------
		// Chargement du fichier complet.
		//---------------------------------------------------
		memcpy(pBigMalloc,pBlock,size);

		//---------------------------------------------------
		// Transforme les donnes en donnes valides.
		//---------------------------------------------------
		pBigMalloc = depackFile();
		if (!pBigMalloc)
		{
			return YM_FALSE;
		}

		//---------------------------------------------------
		// Lecture des donnes YM:
		//---------------------------------------------------
		if (!ymDecode())
		{
			free(pBigMalloc);
			pBigMalloc = NULL;
			return YM_FALSE;
		}

		ymChip.reset();
		bMusicOk = YM_TRUE;
		bPause = YM_FALSE;
		return YM_TRUE;
 }

void	myFree(void **pPtr)
{
		if (*pPtr) free(*pPtr);
		*pPtr = NULL;
}

void	CYmMusic::unLoad(void)
{

		bMusicOk = YM_FALSE;
		bPause = YM_TRUE;
		bMusicOver = YM_FALSE;
//		myFree((void**)&pSongName);
		myFree((void**)&pSongAuthor);
		myFree((void**)&pSongComment);
		myFree((void**)&pSongType);
		myFree((void**)&pSongPlayer);
		myFree((void**)&pBigMalloc);
		if (nbDrum>0)
		{
			for (int i=0;i<nbDrum;i++)
			{
				myFree((void**)&pDrumTab[i].pData);
			}
			nbDrum = 0;
			myFree((void**)&pDrumTab);
		}
		myFree((void**)&pBigSampleBuffer);
		myFree((void**)&pMixBlock);

}

void	CYmMusic::stop(void)
{
	bPause = YM_TRUE;
	currentFrame = 0;
	mixPos = -1;
}

void	CYmMusic::play(void)
{
	bPause = YM_FALSE;
}

void	CYmMusic::pause(void)
{
	bPause = YM_TRUE;
}
