/*-----------------------------------------------------------------------------

	ST-Sound ( YM files player library )

	Copyright (C) 1995-1999 Arnaud Carre ( http://leonard.oxg.free.fr )

	Manage YM file depacking and parsing

-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------

	This file is part of ST-Sound

	ST-Sound is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	ST-Sound is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with ST-Sound; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

-----------------------------------------------------------------------------*/

#ifndef __YMLOAD__
#define	__YMLOAD__

#ifdef __cplusplus
extern "C" {
#endif

#ifndef UB
typedef unsigned char	UB;
#endif
#ifndef UW
typedef unsigned short	UW;
#endif
#ifndef UD
typedef unsigned long	UD;
#endif
#ifndef SB
typedef signed char	SB;
#endif
#ifndef SW
typedef signed short	SW;
#endif
#ifndef SD
typedef signed long	SD;
#endif
#ifndef BOOL
typedef int		BOOL;
#endif
#ifndef FALSE
#define FALSE	0
#endif
#ifndef TRUE
#define TRUE	(!FALSE)
#endif


#pragma pack(push)
#pragma pack(1)

typedef struct
{
	UB	size;
	UB	sum;
	char	id[5];
	UD	packed;
	UD	original;
	UB	reserved[5];
	UB	level;
	UB	name_lenght;
} lzhHeader_t;

typedef struct
{
	UD	id;
	char	checkString[8];
} ymHeader_t;

typedef struct
{
	UD	nbVbl;
	UD	attrib;
	UW	nbDrum;
} ym4Header_t;

typedef struct
{
	UD	nbVbl;
	UD	attrib;
	UW	nbDrum;
	UD	ymFreq;
	UW	playerFreq;
	UD	vblLoop;
	UW	extendedSize;
} ym5Header_t;

#pragma pack(pop)

#ifdef __cplusplus
}
#endif

#endif


