/*
 * Decompiled with CFR 0.152.
 */
package lha;

import java.io.IOException;
import java.io.InputStream;
import lha.LhaDecompressor;
import lha.LhaException;

public class LH5Decompressor
implements LhaDecompressor {
    private static final int UCHAR_MAX = 255;
    private static final int OFFSET = 253;
    private static final int CHAR_BIT = 8;
    private static final int MAX_DICBIT = 16;
    private static final int MAXMATCH = 256;
    private static final int THRESHOLD = 3;
    private static final int NC = 510;
    private static final int NPT = 128;
    private static final int USHRT_BIT = 16;
    private static final int NT = 19;
    private static final int TBIT = 5;
    private static final int CBIT = 9;
    private InputStream in;
    private long origsize;
    private int dicbit;
    private int dicsiz;
    private int dicsiz1;
    private byte[] text;
    private int loc_b;
    private int loc_e;
    private int bitbuf;
    private int subbitbuf;
    private int bitcount;
    private int[] left;
    private int[] right;
    private int[] c_len;
    private int[] c_table;
    private int[] pt_len;
    private int[] pt_table;
    private int np;
    private int pbit;
    private int blocksize;

    public LH5Decompressor(InputStream in, long origsize, int dicbit) throws IOException {
        this.in = in;
        this.origsize = origsize;
        this.dicbit = dicbit;
        this.dicsiz = 1 << dicbit;
        this.dicsiz1 = this.dicsiz - 1;
        this.text = new byte[this.dicsiz];
        this.loc_b = 0;
        this.loc_e = 0;
        this.bitbuf = 0;
        this.subbitbuf = 0;
        this.bitcount = 0;
        this.left = new int[1019];
        this.right = new int[1019];
        this.c_len = new int[510];
        this.c_table = new int[4096];
        this.pt_len = new int[128];
        this.pt_table = new int[256];
        if (dicbit <= 13) {
            this.np = 14;
            this.pbit = 4;
        } else {
            this.np = dicbit == 16 ? 17 : 16;
            this.pbit = 5;
        }
        this.blocksize = 0;
        this.fillbuf(16);
    }

    /*
     * Unable to fully structure code
     */
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        sl = len;
        rs = this.loc_e - this.loc_b;
        if (rs < 0) {
            rs += this.dicsiz;
            bl = this.dicsiz - this.loc_b;
            if (bl >= len) {
                System.arraycopy(this.text, this.loc_b, b, off, len);
                this.loc_b += len;
                if (this.loc_b == this.dicsiz) {
                    this.loc_b = 0;
                }
                return sl;
            }
            System.arraycopy(this.text, this.loc_b, b, off, bl);
            off += bl;
            this.loc_b = 0;
            if (this.loc_e >= (len -= bl)) {
                System.arraycopy(this.text, 0, b, off, len);
                this.loc_b = len;
                return sl;
            }
            if (this.loc_e != 0) {
                System.arraycopy(this.text, 0, b, off, this.loc_e);
                off += this.loc_e;
                len -= this.loc_e;
                this.loc_b = this.loc_e;
            }
        } else {
            if (rs >= len) {
                System.arraycopy(this.text, this.loc_b, b, off, len);
                this.loc_b += len;
                return sl;
            }
            if (rs != 0) {
                System.arraycopy(this.text, this.loc_b, b, off, rs);
                off += rs;
                len -= rs;
                this.loc_b = this.loc_e;
            }
        }
        if (this.origsize > 0L) ** GOTO lbl66
        return -1;
lbl-1000:
        // 1 sources

        {
            c = this.decode_c();
            if (c <= 255) {
                --this.origsize;
                --len;
                ++this.loc_b;
                v0 = off++;
                v1 = (byte)c;
                b[v0] = v1;
                this.text[this.loc_e++] = v1;
                if (this.loc_e != this.dicsiz) continue;
                this.loc_e = 0;
                this.loc_b = 0;
                continue;
            }
            j = c - 253;
            i = this.loc_e - this.decode_p() - 1 & this.dicsiz1;
            this.origsize -= (long)j;
            k = 0;
            while (k < j) {
                t = (byte)(this.text[i + k & this.dicsiz1] & 255);
                this.text[this.loc_e++] = t;
                if (len > 0) {
                    --len;
                    ++this.loc_b;
                    if (this.loc_b == this.dicsiz) {
                        this.loc_b = 0;
                    }
                    b[off++] = t;
                }
                if (this.loc_e == this.dicsiz) {
                    this.loc_e = 0;
                }
                ++k;
            }
lbl66:
            // 4 sources

            ** while (this.origsize > 0L && len > 0)
        }
lbl67:
        // 1 sources

        return sl - len;
    }

    public synchronized void close() throws IOException {
        this.in = null;
        this.text = null;
        this.left = null;
        this.right = null;
        this.c_len = null;
        this.c_table = null;
        this.pt_len = null;
        this.pt_table = null;
    }

    private final int getbits(int n) throws IOException {
        int x = this.bitbuf >>> 16 - n;
        this.fillbuf(n);
        return x;
    }

    private final void fillbuf(int n) throws IOException {
        while (n > this.bitcount) {
            n -= this.bitcount;
            this.bitbuf = (this.bitbuf << this.bitcount) + (this.subbitbuf >>> 8 - this.bitcount);
            int c = this.in.read();
            this.subbitbuf = c > 0 ? c : 0;
            this.bitcount = 8;
        }
        this.bitcount -= n;
        this.bitbuf = (this.bitbuf << n) + (this.subbitbuf >>> 8 - n) & 0xFFFF;
        this.subbitbuf = this.subbitbuf << n & 0xFF;
    }

    private final void make_table(int nchar, int[] bitlen, int tablebits, int[] table) throws LhaException {
        int[] cnttable = new int[17];
        int[] weight = new int[17];
        int[] start = new int[17];
        int a = nchar;
        int i = 1;
        while (i <= 16) {
            cnttable[i] = 0;
            weight[i] = 1 << 16 - i;
            ++i;
        }
        i = 0;
        while (i < nchar) {
            int n = bitlen[i];
            cnttable[n] = cnttable[n] + 1;
            ++i;
        }
        int total = 0;
        i = 1;
        while (i <= 16) {
            start[i] = total;
            total += weight[i] * cnttable[i];
            ++i;
        }
        if ((total & 0xFFFF) != 0) {
            throw new LhaException("bad table");
        }
        int m = 16 - tablebits;
        i = 1;
        while (i <= tablebits) {
            int n = i;
            start[n] = start[n] >>> m;
            int n2 = i++;
            weight[n2] = weight[n2] >>> m;
        }
        int j = start[tablebits + 1] >>> m;
        int k = 1 << tablebits;
        if (j != 0) {
            i = j;
            while (i < k) {
                table[i] = 0;
                ++i;
            }
        }
        j = 0;
        while (j < nchar) {
            k = bitlen[j];
            if (k != 0) {
                int l = start[k] + weight[k];
                if (k <= tablebits) {
                    i = start[k];
                    while (i < l) {
                        table[i] = j;
                        ++i;
                    }
                } else {
                    int[] t = table;
                    i = start[k];
                    int p = i >>> m;
                    i <<= tablebits;
                    int n = k - tablebits;
                    while (--n >= 0) {
                        if (t[p] == 0) {
                            this.left[a] = 0;
                            this.right[a] = 0;
                            t[p] = a++;
                        }
                        p = t[p];
                        t = (i & 0x8000) != 0 ? this.right : this.left;
                        i <<= 1;
                    }
                    t[p] = j;
                }
                start[k] = l;
            }
            ++j;
        }
    }

    private final int decode_c() throws IOException {
        if (this.blocksize == 0) {
            this.blocksize = this.getbits(16);
            this.read_pt_len(19, 5, 3);
            this.read_c_len();
            this.read_pt_len(this.np, this.pbit, -1);
        }
        --this.blocksize;
        int j = this.c_table[this.bitbuf >>> 4];
        if (j < 510) {
            this.fillbuf(this.c_len[j]);
        } else {
            this.fillbuf(12);
            int mask = 32768;
            do {
                j = (this.bitbuf & mask) != 0 ? this.right[j] : this.left[j];
                mask >>>= 1;
            } while (j >= 510);
            this.fillbuf(this.c_len[j] - 12);
        }
        return j;
    }

    private final int decode_p() throws IOException {
        int j = this.pt_table[this.bitbuf >>> 8];
        if (j < this.np) {
            this.fillbuf(this.pt_len[j]);
        } else {
            this.fillbuf(8);
            int mask = 32768;
            do {
                j = (this.bitbuf & mask) != 0 ? this.right[j] : this.left[j];
                mask >>>= 1;
            } while (j >= this.np);
            this.fillbuf(this.pt_len[j] - 8);
        }
        if (j != 0) {
            j = (1 << j - 1) + this.getbits(j - 1) & 0xFFFF;
        }
        return j;
    }

    private final void read_pt_len(int nn, int nbit, int i_special) throws IOException {
        int n = this.getbits(nbit);
        if (n == 0) {
            int c = this.getbits(nbit);
            int i = 0;
            while (i < nn) {
                this.pt_len[i] = 0;
                ++i;
            }
            i = 0;
            while (i < 256) {
                this.pt_table[i] = c;
                ++i;
            }
        } else {
            int i = 0;
            while (i < n) {
                int c = this.bitbuf >>> 13;
                if (c == 7) {
                    int mask = 4096;
                    while ((mask & this.bitbuf) != 0) {
                        mask >>>= 1;
                        ++c;
                    }
                }
                this.fillbuf(c < 7 ? 3 : c - 3);
                this.pt_len[i++] = c;
                if (i != i_special) continue;
                c = this.getbits(2);
                while (--c >= 0) {
                    this.pt_len[i++] = 0;
                }
            }
            while (i < nn) {
                this.pt_len[i++] = 0;
            }
            this.make_table(nn, this.pt_len, 8, this.pt_table);
        }
    }

    private final void read_c_len() throws IOException {
        int n = this.getbits(9);
        if (n == 0) {
            int c = this.getbits(9);
            int i = 0;
            while (i < 510) {
                this.c_len[i] = 0;
                ++i;
            }
            i = 0;
            while (i < 4096) {
                this.c_table[i] = c;
                ++i;
            }
        } else {
            int i = 0;
            while (i < n) {
                int c = this.pt_table[this.bitbuf >>> 8];
                if (c >= 19) {
                    int mask = 128;
                    do {
                        c = (this.bitbuf & mask) != 0 ? this.right[c] : this.left[c];
                        mask >>>= 1;
                    } while (c >= 19);
                }
                this.fillbuf(this.pt_len[c]);
                if (c <= 2) {
                    c = c == 0 ? 1 : (c == 1 ? this.getbits(4) + 3 : this.getbits(9) + 20);
                    while (--c >= 0) {
                        this.c_len[i++] = 0;
                    }
                    continue;
                }
                this.c_len[i++] = c - 2;
            }
            while (i < 510) {
                this.c_len[i++] = 0;
            }
            this.make_table(510, this.c_len, 12, this.c_table);
        }
    }
}

