/*
 * Decompiled with CFR 0.152.
 */
package lha;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Hashtable;
import lha.LhaDecompressInputStream;
import lha.LhaEntry;
import lha.LhaEntryReader;
import lha.LhaException;

public class LhaFile {
    private RandomAccessFile raf;
    private String encoding;
    private String name;
    private Hashtable entries;
    private int size;
    private long pos;

    public LhaFile(File file) throws LhaException, IOException {
        this(file.getPath(), "MS932");
    }

    public LhaFile(String name) throws LhaException, IOException {
        this(name, "MS932");
    }

    public LhaFile(File file, String encoding) throws LhaException, IOException {
        this(file.getPath(), encoding);
    }

    public LhaFile(String name, String encoding) throws LhaException, IOException {
        this.raf = new RandomAccessFile(name, "r");
        this.encoding = encoding;
        this.name = name;
        this.entries = new Hashtable();
        this.makeEntryMap();
    }

    public LhaEntry getEntry(String name) {
        return (LhaEntry)this.entries.get(name);
    }

    public InputStream getInputStream(LhaEntry entry) throws IOException {
        return new LhaDecompressInputStream(new LhaFileInputStream(this, entry), entry);
    }

    public String getName() {
        return this.name;
    }

    public Enumeration entries() {
        return this.entries.elements();
    }

    private synchronized int read(long pos, byte[] b, int off, int len) throws IOException {
        int n;
        if (pos != this.pos) {
            this.raf.seek(pos);
        }
        if ((n = this.raf.read(b, off, len)) > 0) {
            this.pos = pos + (long)n;
        }
        return n;
    }

    private synchronized int read(long pos) throws IOException {
        int n;
        if (pos != this.pos) {
            this.raf.seek(pos);
        }
        if ((n = this.raf.read()) > 0) {
            this.pos = pos + 1L;
        }
        return n;
    }

    public int size() {
        return this.size;
    }

    public void close() throws IOException {
        if (this.raf != null) {
            this.raf.close();
            this.raf = null;
        }
    }

    private void makeEntryMap() throws LhaException, IOException {
        LhaEntry e;
        LhaEntryReader hr = new LhaEntryReader(this.encoding){

            protected int _read(byte[] b) throws IOException {
                return LhaFile.this.raf.read(b);
            }
        };
        this.size = 0;
        while ((e = hr.readHeader()) != null) {
            e.setOffset(this.raf.getFilePointer());
            this.entries.put(e.getFile().getPath(), e);
            ++this.size;
            int skipSize = (int)e.getCompressedSize();
            if (this.raf.skipBytes(skipSize) == skipSize) continue;
            throw new LhaException("Header is broken (makeEntryMap)");
        }
    }

    private class LhaFileInputStream
    extends InputStream {
        private LhaFile file;
        private long pos;
        private long count;

        public LhaFileInputStream(LhaFile file, LhaEntry entry) {
            if (file == null || entry == null) {
                throw new NullPointerException();
            }
            this.file = file;
            this.pos = entry.getOffset();
            this.count = entry.getCompressedSize();
        }

        public int read(byte[] b, int off, int len) throws IOException, LhaException {
            if (this.count == 0L) {
                return -1;
            }
            if ((long)len > this.count) {
                len = (int)Math.min(this.count, Integer.MAX_VALUE);
            }
            if ((len = this.file.read(this.pos, b, off, len)) == -1) {
                throw new LhaException("premature EOF");
            }
            this.pos += (long)len;
            this.count -= (long)len;
            return len;
        }

        public int read() throws IOException, LhaException {
            if (this.count == 0L) {
                return -1;
            }
            int n = this.file.read(this.pos);
            if (n == -1) {
                throw new LhaException("premature EOF");
            }
            ++this.pos;
            --this.count;
            return n;
        }
    }
}

