/*
 * Decompiled with CFR 0.152.
 */
import java.util.BitSet;
import java.util.Vector;

public class Cruncher {
    private Vector arrRawData;
    private boolean blnVerbose = false;
    StringBuffer str_debug = new StringBuffer();

    public Cruncher(Vector arrToCrunch, boolean blnParamVerbose) {
        this.arrRawData = arrToCrunch;
        this.blnVerbose = blnParamVerbose;
    }

    private void info(String strMsg) {
        this.str_debug.append(strMsg);
        this.str_debug.append("\r\n");
    }

    private void debug(String strMsg) {
        if (this.blnVerbose) {
            this.info(strMsg);
        }
    }

    public String getDebugMsg() {
        return this.str_debug.toString();
    }

    private boolean isEqual(int index1, int index2, int curr_size) {
        int i = 0;
        while (i < curr_size) {
            int curr_ind1 = index1 + i;
            int curr_ind2 = index2 + i;
            if (!this.arrRawData.elementAt(curr_ind1).equals(this.arrRawData.elementAt(curr_ind2))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private int get_indexPattern(int curr_index, int curr_size, int intBufferSize) {
        int max_index;
        int min_index = curr_index - intBufferSize;
        min_index = min_index > 0 ? min_index : 0;
        int i = max_index = curr_index - 1;
        while (i >= min_index) {
            if (this.isEqual(i, curr_index, curr_size)) {
                return curr_index - i;
            }
            --i;
        }
        return 0;
    }

    public Vector doCrunch(byte bytFormat, int intBuffSize) {
        switch (bytFormat) {
            case 1: {
                return this.doAYCCrunch(intBuffSize);
            }
        }
        return this.doYMCCrunch();
    }

    private Byte bsToByte(BitSet bs) {
        byte bytRet = 0;
        int b = 7;
        while (b > 0) {
            bytRet = (byte)(bytRet | (bs.get(b) ? 1 : 0));
            bytRet = (byte)(bytRet << 1);
            b = (byte)(b - 1);
        }
        bytRet = (byte)(bytRet | (bs.get(0) ? 1 : 0));
        return new Byte(bytRet);
    }

    public Vector doAYLCrunch(int intVBL) {
        Vector<Byte> arrCrunchedData = new Vector<Byte>();
        int i = 0;
        while (i < intVBL) {
            byte j = 0;
            while (j < 14) {
                byte bytValue = (Byte)((Vector)this.arrRawData.elementAt(j)).elementAt(i);
                arrCrunchedData.add(new Byte(0));
                arrCrunchedData.add(new Byte(j));
                arrCrunchedData.add(new Byte(bytValue));
                arrCrunchedData.add(new Byte(bytValue));
                j = (byte)(j + 1);
            }
            ++i;
        }
        this.debug("  - New Size : " + arrCrunchedData.size() + " bytes");
        this.debug("  - Compression ratio ~ " + (float)arrCrunchedData.size() * 100.0f / (float)this.arrRawData.size() + " %");
        return arrCrunchedData;
    }

    private Vector doAYCCrunch(int intBuffSize) {
        Vector<Byte> arrCrunchedData = new Vector<Byte>();
        byte bytData = (Byte)this.arrRawData.elementAt(0);
        arrCrunchedData.add(new Byte(bytData));
        int curr_index = 1;
        BitSet bsFlag = new BitSet(8);
        bsFlag.clear();
        int intOffsetFlag = 1;
        int intSeqCounter = 8;
        while (curr_index < this.arrRawData.size()) {
            int max_size;
            if (intSeqCounter <= 0) {
                intSeqCounter = 8;
                arrCrunchedData.add(intOffsetFlag, this.bsToByte(bsFlag));
                intOffsetFlag = arrCrunchedData.size();
                bsFlag.clear();
            }
            int curr_size = (max_size = this.arrRawData.size() - curr_index) < 256 ? max_size : 256;
            while (curr_size > 3) {
                int index_pattern = this.get_indexPattern(curr_index, curr_size, intBuffSize);
                if (index_pattern != 0) {
                    short bytPrevOffset;
                    short bytIndexPattern;
                    short bytCurrOffset;
                    byte bytNegLength = (byte)(-curr_size & 0xFF);
                    arrCrunchedData.add(new Byte(bytNegLength));
                    if (intBuffSize <= 256) {
                        bytCurrOffset = (short)(curr_index & 0xFF);
                        bytIndexPattern = (short)(index_pattern & 0xFF);
                        bytPrevOffset = (short)(bytCurrOffset - bytIndexPattern);
                        arrCrunchedData.add(new Byte((byte)bytPrevOffset));
                    } else {
                        bytCurrOffset = (short)(curr_index & 0xFFFF);
                        bytIndexPattern = (short)(index_pattern & 0xFFFF);
                        bytPrevOffset = (short)(bytCurrOffset - bytIndexPattern);
                        arrCrunchedData.add(new Byte((byte)(bytPrevOffset & 0xFF)));
                        arrCrunchedData.add(new Byte((byte)(bytPrevOffset >> 8 & 3)));
                    }
                    bsFlag.set(--intSeqCounter);
                    curr_index += curr_size;
                    break;
                }
                --curr_size;
            }
            if (curr_size > 3) continue;
            bytData = (Byte)this.arrRawData.elementAt(curr_index);
            arrCrunchedData.add(new Byte(bytData));
            --intSeqCounter;
            ++curr_index;
        }
        arrCrunchedData.add(intOffsetFlag, this.bsToByte(bsFlag));
        this.debug("  - New Size : " + arrCrunchedData.size() + " bytes");
        this.debug("  - Compression ratio ~ " + (float)arrCrunchedData.size() * 100.0f / (float)this.arrRawData.size() + " %");
        return arrCrunchedData;
    }

    private Vector doYMCCrunch() {
        Vector<Integer> arrCrunchedData = new Vector<Integer>();
        boolean blnNewSeq = true;
        int nbNewSeq = 1;
        int offNewSeqHead = 0;
        arrCrunchedData.add(new Integer(0));
        arrCrunchedData.add((Integer)this.arrRawData.elementAt(0));
        int curr_index = 1;
        while (curr_index < this.arrRawData.size()) {
            int max_size = this.arrRawData.size() - curr_index;
            int curr_size = max_size < 255 ? max_size : 255;
            while (curr_size > 3) {
                int index_pattern = this.get_indexPattern(curr_index, curr_size, 255);
                if (index_pattern != 0) {
                    if (blnNewSeq) {
                        arrCrunchedData.insertElementAt(new Integer(nbNewSeq), offNewSeqHead + 1);
                        blnNewSeq = false;
                        nbNewSeq = 0;
                    }
                    int seq_header = index_pattern;
                    int seq_size = curr_size;
                    arrCrunchedData.add(new Integer(seq_header));
                    arrCrunchedData.add(new Integer(seq_size));
                    curr_index += seq_size;
                    break;
                }
                --curr_size;
            }
            if (curr_size > 3) continue;
            int seq_header = 0;
            if (!blnNewSeq) {
                blnNewSeq = true;
                offNewSeqHead = arrCrunchedData.size();
                arrCrunchedData.add(new Integer(seq_header));
            }
            arrCrunchedData.add((Integer)this.arrRawData.elementAt(curr_index));
            nbNewSeq = (byte)(nbNewSeq + 1);
            if (nbNewSeq < 255 && ++curr_index < this.arrRawData.size()) continue;
            arrCrunchedData.insertElementAt(new Integer(nbNewSeq), offNewSeqHead + 1);
            blnNewSeq = false;
            nbNewSeq = 0;
        }
        this.debug("  - New Size : " + arrCrunchedData.size() + " bytes");
        this.debug("  - Compression ratio ~ " + (float)arrCrunchedData.size() * 100.0f / (float)this.arrRawData.size() + " %");
        return arrCrunchedData;
    }
}

