/**
* @class CCPCDataDisc
* Classe permettant la gestion d'un disc CPC Data (utilisation de la sous-lib DSK)
* @author Thierry JOUIN
* @version 1.1
* @date 31/10/2001
*/

#pragma warning( disable : 4786 )

#include <iostream>

#include <string>
#include <stdio.h>
#include <stdlib.h>
#include "libdsk.h"
#include <errno.h>
#include <string.h>

#include <vector>

#include "CCPCDisc.h"

#ifndef _CCPCDATADISC_HH_
#define _CCPCDATADISC_HH_

class CCPCDataDisc:public CCPCDisc
{
private:
protected:
	/// Affiche l'occupation du disc
	virtual void scanBlock(std::ostream &io_os) const;
	/// Renvoie la liste des block libres
	virtual void getEmptyBlock(std::vector<unsigned int> &o_block) const;
	
	/// Pour une entree du catalogue, affiche la position des donnees sur le disc
	virtual void printBlockForEntry(std::ostream &io_os, unsigned int i_entry) const;
	
	/// Lit le buffer catalogue sur le disc
	virtual void readCatalogueBuffer();
	/// Ecrit le buffer catalogue sur le disc
	virtual void writeCatalogueBuffer();
	
public:
	//! Constructeur
	CCPCDataDisc();
	//! Constructeur, on connait le driver et la gomtrie
	CCPCDataDisc(DSK_PDRIVER i_driver, const TDisc format);

	/// Ouverture d'un DSK deja existant
	virtual void open(const std::string &i_filename, int i_inside = 0);
	/// Ouverture en creation d'un DSK
	virtual void create(TDisc i_type, const std::string &i_filename, int i_inside = 0);
	/// Formattage du DSK
	virtual void format(bool interlaced = true);
	
	/// Lit un secteur sur le disc (buffer deja alloue !)
	virtual void readSector(const unsigned char i_cylinder, const unsigned char i_head, const unsigned char i_sectorID, void* i_buffer) const;
	/// Ecrit un secteur sur le disc
	virtual void writeSector(const unsigned char i_cylinder, const unsigned char i_head, const unsigned char i_sectorID, const void* i_buffer);
	/// Lit un bloc sur le disc (buffer deja alloue !)
	virtual void readBlock(const unsigned char i_idBlock, void* i_buffer) const;
	/// Ecrit un secteur sur le disc
	virtual void writeBlock(const unsigned char i_idBlock, const void* i_buffer);
	
};

#endif
