/**
* Petit utilitaire de transfert, mode texte, ligne de commande uniquement
* @author Thierry JOUIN
* @version 1.1
* @date 31/10/2001
*/

#include "CCPCDisc.h"
#include "CCPCBinaryFile.h"
#include "CCPCAsciiFile.h"

#include <stdio.h>

enum TCommand
{
    Catalogue,
		Format,
		PutFile,
		GetFile,
		GetAllFile,
		RenameFile,
		DeleteFile,
		PrintDisc,
		PrintFile,
		Unknown
};

void GetAmsdosParamFromName(const std::string &filename, std::string &filenameams, 
							int &user, bool &system, bool &writeProtected, 
							int &start, int &exec)
{
	std::string s,f;
	
	user = 0;
	system = false;
	writeProtected = false;
	start = -1;
	exec = -1;

	f = filename;

	for (int i=0;i<f.size();i++)
	{
		f[i] = toupper(f[i]);
	}

	if (f.find(':') != std::string::npos)
	{
		s = filename.substr(0,filename.find(':'));

		if (s.size() == 1)
		{
			if (s[0] >= '0' && s[0] < '9')
			{
				// we've got a user, try to convert to value
				user = strtol(s.c_str(), NULL, 0);
				f = f.substr(f.find(':')+1, f.size() - f.find(':'));
			}
		}
		else
		{
			// we've got a user, try to convert to value
			user = strtol(s.c_str(), NULL, 0);
			f = f.substr(f.find(':')+1, f.size() - f.find(':'));
		}
	}
	if (f.find(',') != std::string::npos)
	{
		s = f.substr(f.find(',')+1,f.size() - f.find(','));
		f = f.substr(0, f.find(','));

		bool nostart = true;
		bool noexec = true;
		std::string tok;

		while (s.size() > 0)
		{
			if (s.find(',') != std::string::npos)
			{
				tok = s.substr(0, s.find(','));
				s = s.substr(s.find(',')+1,s.size() - s.find(','));
			}
			else
			{
				tok = s;
				s = "";
			}

			if (tok == "S")
			{
				system = true;
			}
			else if (tok == "P")
			{
				writeProtected = true;
			}
			else if (nostart)
			{
				start = strtol(tok.c_str(), NULL, 0);
				nostart = false;
			}
			else if (noexec)
			{
				exec = strtol(tok.c_str(), NULL, 0);
				noexec = false;
			}
		}
	}
	filenameams = f;
}

int main(int argc, char* argv[])
{
	std::cout << "cpcFS (c) Ramlaid 2005" << std::endl << std::endl;

	std::vector<std::string> fileNames;
	
	if (argc < 3)
    {
		std::cerr << argv[0] << " <disc> <command> [option] [file *] [-s]" << std::endl;
		std::cerr << "Commands : " << std::endl;
		std::cerr << "\tc  : catalogue" << std::endl;
		std::cerr << "\tf  : disc format" << std::endl;
		std::cerr << "\tp  : put file" << std::endl;
		std::cerr << "\t     -ch : header creation when putting" << std::endl;
		std::cerr << "\t     -b : binary mode" << std::endl;
		std::cerr << "\tg  : get file" << std::endl;
		std::cerr << "\t     -nh : no header when getting" << std::endl;
		std::cerr << "\tga : get all file" << std::endl;
		std::cerr << "\t     -nh : no header when getting" << std::endl;
		std::cerr << "\tr  : rename file" << std::endl;
		std::cerr << "\td  : delete file" << std::endl;
		std::cerr << "\ti  : print disc info" << std::endl;
		std::cerr << "\th  : print file header" << std::endl;
		std::cerr << "Options : " << std::endl;
		std::cerr << "\t-s : select side B" << std::endl;
		std::cerr << "When putting or getting file, you can use [<user>:]name.ext[,S][,P][,start][,exec]" << std::endl;
		return -1;
    }
	
	std::string discFilename(argv[1]);
	std::string c(argv[2]);
	TCommand command = Unknown;
	
	if (c==std::string("c"))
	{
		command=Catalogue;
	}
	else
	{
		if (c==std::string("f"))
		{
			command=Format;
		}
		else
		{
			if (c==std::string("p"))
			{
				command=PutFile;
			}
			else
			{
				if (c==std::string("g"))
				{
					command=GetFile;
				}
				else
				{
					if (c==std::string("ga"))
					{
						command=GetAllFile;
					}
					else
					{
						if (c==std::string("r"))
						{
							command=RenameFile;
						}
						else
						{
							if (c==std::string("d"))
							{
								command=DeleteFile;
							}
							else
							{
								if (c==std::string("i"))
								{
									command=PrintDisc;
								}
								else
								{
									if (c==std::string("h"))
									{
										command=PrintFile;
									}
								}									
							}
						}
					}
				}
			}
		}
	}
	int i=3;
	
	int side=0;
	bool headerCreation = false;
	bool headerSaving = true;
	bool binary = false;
	CCPCDisc::TDisc typeDisc = CCPCDisc::Data;
	
	for (i=3;i<argc;i++)
	{
		if (std::string(argv[i])==std::string("-s"))
		{
			MSG("Side B");
			side = 1;
		}
		else
			if (std::string(argv[i])==std::string("-ch"))
			{
				MSG("Create header when putting");
				headerCreation = true;
			}
			else
				if (std::string(argv[i])==std::string("-nh"))
				{
					MSG("No header when getting");
					headerSaving = false;
				}
				else
					if (std::string(argv[i])==std::string("-b"))
					{
						MSG("Binary mode");
						binary = true;
					}
					else
						fileNames.push_back(std::string(argv[i]));
	}
	
	try
	{
		switch (command)
		{
		case Catalogue :
			{
				CCPCDisc *disc = CCPCDisc::openDisc(discFilename,side);
				
				disc->catalogue(std::cout);
				
				disc->close();
				delete disc;
				break;
			}
		case Format :
			{
				CCPCDisc *disc = CCPCDisc::createDisc(discFilename,typeDisc,side);
				
				disc->format();
				
				disc->close();
				delete disc;
				break;
			}
		case PutFile :
			{
				CCPCDisc *disc = CCPCDisc::openDisc(discFilename,side);
				
				for (unsigned int i=0;i<fileNames.size();i++)
				{
					std::string filename;
					int user;
					bool sys,pro;
					int start, exec;
					
					GetAmsdosParamFromName(fileNames[i], filename, user, sys, pro, start, exec);

					if (binary)
					{
						CCPCBinaryFile fileIn;
						try
						{
							fileIn.openFile(filename,headerCreation);
						}
						catch (tools::CException &e)
						{
							std::cerr << e << std::endl;
							TOOLS_ERRORMSG("Error opening binary file " << filename)
						}
						std::cout << "Putting binary file <" << filename << "> " << fileIn.getSize() << " bytes";
						if (start != -1)
						{
							fileIn.setAdress(start);
							std::cout << " [start address &" << std::hex << start << "]" << std::dec;
						}
						if (exec != -1)
						{
							fileIn.setExecute(exec);
							std::cout << " [execute address &" << std::hex << start << "]" << std::dec;
						}
						std::cout << std::endl;
						disc->putFile(fileIn,filename, user, sys, pro);
					}
					else
					{
						CCPCAsciiFile fileIn;
						try
						{
							fileIn.openFile(filename,headerCreation);
						}
						catch (tools::CException &e)
						{
							std::cerr << e << std::endl;
							TOOLS_ERRORMSG("Error opening ascii file " << filename)
						}
						std::cout << "Putting ascii file <" << filename << "> " << fileIn.getSize() << " bytes" << std::endl;
						disc->putFile(fileIn,filename, user, sys, pro);
					}
		  }
		  
		  disc->close();
		  delete disc;
		  break;
	  }
	case GetFile :
		{
			CCPCDisc *disc = CCPCDisc::openDisc(discFilename,side);
			
			TOOLS_ASSERTMSG( (fileNames.size() != 0) , "No file to get !");
			
			for (unsigned int i=0;i<fileNames.size();i++)
			{
				std::string filename;
				int user;
				bool sys,pro;
				int start, exec;
				
				GetAmsdosParamFromName(fileNames[i], filename, user, sys, pro, start, exec);
			
				CCPCFile *file = disc->getFile(filename, user);
				std::cout << "Getting ";
				if (file->getType() == Binary)
				{
					std::cout << "Bin :";
				}
				else
				{
					std::cout << "Asc :";
				}
				std::cout << "<" << user << ":" << filename << "> \t";
				std::cout << file->getSize() << " bytes \t" << (float)file->getSize()/1024.0f << "Kb " << std::endl;
				file->saveFile(filename,headerSaving);
				delete file;
			}
			
			disc->close();
			delete disc;
			break;
		}
	case GetAllFile :
		{
			CCPCDisc *disc = CCPCDisc::openDisc(discFilename,side);
			
			for (unsigned int i=0;i<disc->getNbFiles();i++)
			{
				int user;
				std::string filename = disc->getFilename(i, user);
				CCPCFile *file = disc->getFile(filename, user);
				std::cout << "Getting ";
				if (file->getType() == Binary)
				{
					std::cout << "Bin :";
				}
				else
				{
					std::cout << "Asc :";
				}
				std::cout << "<" << user << ":" << filename << "> \t";
				std::cout << file->getSize() << " bytes \t" << (float)file->getSize()/1024.0f << "Kb " << std::endl;
				if (user != 0)
				{
					char userStr[16];
					sprintf(userStr, "%d_", user);
					filename = userStr + filename;
				}
				file->saveFile(filename,headerSaving);
				delete file;
			}
			
			disc->close();
			delete disc;
			break;
		}
	case RenameFile :
		{
			TOOLS_ASSERTMSG( (fileNames.size() == 2) , "2 fileNames for rename");
			CCPCDisc *disc = CCPCDisc::openDisc(discFilename,side);
			
			std::string o_filename;
			int o_user;
			bool o_sys, o_pro;
			int o_start, o_exec;
			
			GetAmsdosParamFromName(fileNames[0], o_filename, o_user, o_sys, o_pro, o_start, o_exec);

			std::string n_filename;
			int n_user;
			bool n_sys, n_pro;
			int n_start, n_exec;
			
			GetAmsdosParamFromName(fileNames[1], n_filename, n_user, n_sys, n_pro, n_start, n_exec);

			std::cout << "Rename file <" << o_user << ":" << o_filename << "> to <" << n_user << ":" << n_filename << ">" << std::endl;
			disc->renameFile(	o_filename,n_filename, o_user, n_user,
								o_sys, n_sys, o_pro, n_pro);
			
			disc->close();
			delete disc;
			break;
		}
	case DeleteFile :
		{
			CCPCDisc *disc = CCPCDisc::openDisc(discFilename,side);
			
			for (unsigned int i=0;i<fileNames.size();i++)
			{
				std::string filename;
				int user;
				bool sys,pro;
				int start, exec;
				
				GetAmsdosParamFromName(fileNames[i], filename, user, sys, pro, start, exec);

				std::cout << "Delete file <" << user << ":" << filename << ">" << std::endl;
				disc->eraseFile(filename, user);
			}
			
			disc->close();
			
			delete disc;
			break;
		}
	case PrintDisc :
		{
			CCPCDisc *disc = CCPCDisc::openDisc(discFilename,side);
			
			disc->printInfo(std::cout);
			
			disc->close();
			delete disc;
			break;
		}
	case PrintFile :
		{
			CCPCDisc *disc = CCPCDisc::openDisc(discFilename,side);
			
			TOOLS_ASSERTMSG( (fileNames.size() != 0) , "No file to print !");
			
			for (unsigned int i=0;i<fileNames.size();i++)
			{
				std::string filename;
				int user;
				bool sys,pro;
				int start, exec;
				
				GetAmsdosParamFromName(fileNames[i], filename, user, sys, pro, start, exec);

				CCPCFile *file = disc->getFile(filename, user);
				std::cout << "File header <" << user << ":" << filename << ">" << std::endl;
				
				std::cout << *file << std::endl;
				file->printHeader(std::cout);
				
				delete file;
			}
			
			disc->close();
			delete disc;
			break;
		}
	default :
		{
			TOOLS_ERRORMSG( "Unknown command : " << c);
		}
	}
    }
	catch (tools::CException &e)
    {
		std::cerr << e << std::endl;
		return -1;
    }
	
	return 0;
}
