// DirectoryBrowse.cpp: implementation of the CDirectoryBrowse class.
//
// Author:	Bill Oatman
// Version:	1.1
// WebPage:	http://www.netacc.net/~waterbry/dirbrowse/dirbrowse.htm
//
// 1.1 Enhancements made by David Reich of SVT Associates (dareich@tiny.net)
////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "DirectoryBrowse.h"
#include <shlobj.h>

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////
CString CDirectoryBrowse::s_InitialDirectory;

//David Reich modified the constructor to take some arguments
CDirectoryBrowse::CDirectoryBrowse(CString title, CString InitDir, bool bOnlyIfEmpty)
{
	if(title.IsEmpty())
		m_title = "Select Directory";
	else
		m_title = title;

	if(!InitDir.IsEmpty())	//reset initial dir only if a value is provided
		SetInitDir(InitDir,bOnlyIfEmpty);

}

CDirectoryBrowse::~CDirectoryBrowse()
{

}

void CDirectoryBrowse::SetTitle(CString title)
{
	m_title = title;
}

bool CDirectoryBrowse::DoModal()
{
	BROWSEINFO bi;
	char DirName[MAX_PATH];
	int imageIndex = 0;
	LPITEMIDLIST pidl;
    LPMALLOC pmalloc = NULL;

	SHGetMalloc(&pmalloc);

	bi.hwndOwner = NULL;
	bi.pidlRoot = NULL;
	bi.pszDisplayName = DirName;
	bi.lpszTitle = (LPCTSTR)m_title;
	bi.ulFlags = BIF_RETURNONLYFSDIRS;
	
	//David Reich changed this from NULL to CDirectoryBrowse::BrowseCallbackProc
	bi.lpfn = CDirectoryBrowse::BrowseCallbackProc;

	bi.lParam = NULL;
	bi.iImage = imageIndex;

	pidl = SHBrowseForFolder(&bi);

	if(pidl)
	{
		SHGetPathFromIDList(pidl, DirName);
		m_directory = DirName;

		//Cache the result of the directory search.
		//unless reset, the next time this object is used, the folder opens here
		s_InitialDirectory = m_directory;

		pmalloc->Free(pidl);
	}

	pmalloc->Release();

	if(pidl)
		return true;
	else
		return false;
}

void CDirectoryBrowse::GetDirectory(CString & directory)
{
	directory = m_directory;
}

//David Reich added the following functions Feb 5, 1999

//These allow the user to use the CDirectoryBrowse object itself as a string
CDirectoryBrowse::operator CString()
{
	return m_directory;
}

CDirectoryBrowse::operator LPCTSTR()
{
	return (LPCTSTR)m_directory;
}

//resets the cached result of the last directory browse
void CDirectoryBrowse::SetInitDir(CString InitDir, bool bOnlyIfEmpty)
{
	if(!bOnlyIfEmpty)
		s_InitialDirectory = InitDir;
	else
	{
		if(s_InitialDirectory.IsEmpty())
			s_InitialDirectory = InitDir;
	}		
}

//This catches the BFFM_INITIALIZED event fired by the browse dialog.  
//It then sends a window message to the dialog to set the selection
//s_InitialDirectory contains the directory selected the last time
//(s_InitialDirectory can be reset before calling DoModal)
int __stdcall CDirectoryBrowse::BrowseCallbackProc(
                                         HWND hwnd,
                                         UINT uMsg,
                                         LPARAM lParam,   
                                         LPARAM lpData)   
{
	if(uMsg == BFFM_INITIALIZED)
	{
		LPCTSTR InitDir = (LPCTSTR)s_InitialDirectory;

		::SendMessage(hwnd, BFFM_SETSELECTION, 1, (LPARAM)InitDir);
	}

	return 0;
}
