// DirectoryBrowse.h: interface for the CDirectoryBrowse class.
//
// Author:	Bill Oatman
// Version:	1.1
// WebPage:	http://www.netacc.net/~waterbry/dirbrowse/dirbrowse.htm
//
// 1.1 Enhancements made by David Reich of SVT Associates (dareich@tiny.net)
////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_DIRECTORYBROWSE_H__29FA4C6E_380F_11D2_AFC5_AC5658CCFB7E__INCLUDED_)
#define AFX_DIRECTORYBROWSE_H__29FA4C6E_380F_11D2_AFC5_AC5658CCFB7E__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

class CDirectoryBrowse  
{
public:
	CDirectoryBrowse(CString title = CString(), CString InitDir = CString(), bool bOnlyIfEmpty = true);
	virtual ~CDirectoryBrowse();

	void GetDirectory(CString &directory);	// returns selected directory
	bool DoModal();							// invokes dialog.  returns
											// TRUE if OK selected
	void SetTitle(CString title);				// sets title text
	
	// sets initial directory
	void SetInitDir(CString InitDir, bool bOnlyIfEmpty = true);			

	//these make the CDirectoryBrowse look like a CString or LPCSTR
	//if it is used in arguemnts.  Both return the selected directory
	operator CString();
	operator LPCTSTR();

protected:
	
	static CString s_InitialDirectory;
	static int __stdcall BrowseCallbackProc(HWND hwnd, UINT uMsg, LPARAM lParam, LPARAM lpData);
	
	CString m_title;
	CString m_directory;
};

#endif // !defined(AFX_DIRECTORYBROWSE_H__29FA4C6E_380F_11D2_AFC5_AC5658CCFB7E__INCLUDED_)
