// DiscInfoDlg.cpp : implementation file
//

#include "stdafx.h"
#include "cpcfsext.h"
#include "DiscInfoDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDiscInfoDlg dialog


CDiscInfoDlg::CDiscInfoDlg(CWnd* pParent /*=NULL*/)
: CDialog(CDiscInfoDlg::IDD, pParent),
_dsk(NULL)
{
	//{{AFX_DATA_INIT(CDiscInfoDlg)
	_discInfo = _T("");
	//}}AFX_DATA_INIT
}


void CDiscInfoDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDiscInfoDlg)
	DDX_Text(pDX, IDC_DISC_INFO, _discInfo);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDiscInfoDlg, CDialog)
	//{{AFX_MSG_MAP(CDiscInfoDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDiscInfoDlg message handlers

BOOL CDiscInfoDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	if (_dsk != NULL)
	{
		CString discInfo, str;
		const DSK_GEOMETRY &geom = _dsk->getDiscGeometry();

		str.Format("Format name : %s\n",_dsk->getDiscFormatName().c_str());
		discInfo += str;
		str.Format("Format description : %s\n",_dsk->getDiscFormatDescription().c_str());
		discInfo += str;
		str.Format("Nb tracks : %d\n",geom.dg_cylinders);
		discInfo += str;
		str.Format("Nb sector per tracks : %d\n",geom.dg_sectors);
		discInfo += str;
		str.Format("Sector size : %d\n",geom.dg_secsize);
		discInfo += str;
		str.Format("Sector base : 0x%X\n",geom.dg_secbase);
		discInfo += str;
		str.Format("GAP : 0x%X\n",geom.dg_rwgap);
		discInfo += str;

		_discInfo = discInfo;
		UpdateData(FALSE);
	}
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
