// cpcFSDragDropExt.cpp : Implementation of CcpcFSDragDropExt
#include "stdafx.h"
#include "CpcFSExt.h"
#include "cpcFSDragDropExt.h"

/////////////////////////////////////////////////////////////////////////////
// CcpcFSDragDropExt

HRESULT CcpcFSDragDropExt::Initialize ( LPCITEMIDLIST pidlFolder,
									   LPDATAOBJECT  pDO,
									   HKEY          hProgID )
{
    AFX_MANAGE_STATE(AfxGetStaticModuleState());
	
	COleDataObject dataobj;
	HGLOBAL        hglobal;
	HDROP          hdrop;
	TCHAR          szRoot [MAX_PATH];
	TCHAR          szFile [MAX_PATH];
	UINT           uFile, uNumFiles;
	
    dataobj.Attach ( pDO, FALSE );      // FALSE = don't release IDataObject interface when destroyed
	
    // Get the name of the directory where the files were dropped.
	
    if ( !SHGetPathFromIDList ( pidlFolder, szRoot ))
	{
        return E_FAIL;
	}
	
	_dropFilename = szRoot;

    // Get a list of all the objects that were dropped.
	
    hglobal = dataobj.GetGlobalData ( CF_HDROP );
	
    if ( NULL == hglobal )
        return E_INVALIDARG;
	
    hdrop = (HDROP) GlobalLock ( hglobal );
	
    if ( NULL == hdrop )
        return E_INVALIDARG;
	
    // Determine how many files were dropped.
	
    uNumFiles = DragQueryFile ( hdrop, 0xFFFFFFFF, NULL, 0 );
	
    // Check each dropped item.
	
    for ( uFile = 0; uFile < uNumFiles; uFile++ )
	{
        if ( DragQueryFile ( hdrop, uFile, szFile, MAX_PATH ))
		{
            // Add the file to our list of dropped files.
            _draggedFiles.push_back(szFile);
		}
	}   // end for
	
    GlobalUnlock ( hglobal );
	
    return ( _draggedFiles.size() > 0 ) ? S_OK : E_FAIL;
}
