// cpcFSShellExt.cpp : Implementation of CcpcFSShellExt
#include "stdafx.h"
#include "CpcFSExt.h"
#include "cpcFSShellExt.h"

#include "resource.h"

#include "DirectoryBrowse.h"
#include "EditBinaryHeaderDlg.h"
#include "CatalogueDlg.h"
#include "DiscInfoDlg.h"

#include "CCPCBinaryFile.h"
#include "CCPCAsciiFile.h"

/////////////////////////////////////////////////////////////////////////////
// CcpcFSShellExt

CcpcFSShellExt::CcpcFSShellExt() :
_mode(Unknown),
_directoryPath(""),
_fileList(),
_dskFilename(""),
_dskSide(0),
_dskFormat(CCPCDisc::Data)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState());
}

HRESULT CcpcFSShellExt::Initialize ( 
    LPCITEMIDLIST pidlFolder,
    LPDATAOBJECT pDataObj,
    HKEY hProgID )
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState());
	

	FORMATETC fmt = { CF_HDROP, NULL, DVASPECT_CONTENT, -1, TYMED_HGLOBAL };
	STGMEDIUM stg = { TYMED_HGLOBAL };
	HDROP     hDrop;

	if (pDataObj != NULL)
	{
		// Look for CF_HDROP data in the data object.
		if ( FAILED( pDataObj->GetData ( &fmt, &stg )))
		{
			// Nope! Return an "invalid argument" error back to Explorer.
			return E_INVALIDARG;
		}

		// Get a pointer to the actual data.
		hDrop = (HDROP) GlobalLock ( stg.hGlobal );

		// Make sure it worked.
		if ( NULL == hDrop )
		{
			return E_INVALIDARG;
		}

		// Sanity check  make sure there is at least one filename.
		UINT uNumFiles = DragQueryFile ( hDrop, 0xFFFFFFFF, NULL, 0 );

		if ( 0 == uNumFiles )
		{
			GlobalUnlock ( stg.hGlobal );
			ReleaseStgMedium ( &stg );
			return E_INVALIDARG;
		}

		HRESULT hr = S_OK;

		UINT numFiles = DragQueryFile ( hDrop, 0xFFFFFFFF, NULL, 0  );

		for ( UINT uFile = 0; uFile < uNumFiles; uFile++ )
		{
			TCHAR     szFile    [MAX_PATH];

			// Get the next filename.
			if ( DragQueryFile ( hDrop, uFile, szFile, MAX_PATH ) == 0)
				continue;

			if ( (GetFileAttributes(szFile) & FILE_ATTRIBUTE_DIRECTORY) != 0 )
			{
				_directoryList.push_back(szFile);
			}
			else
			{
				_fileList.push_back(szFile);
			}
		}

		GlobalUnlock ( stg.hGlobal );
		ReleaseStgMedium ( &stg );
		
		if (_fileList.size() == 0 && _directoryList.size() == 0)
		{
			return E_INVALIDARG;
		}

		if (_fileList.size() > 0)
		{
			_directoryPath = _fileList[0];
			_directoryPath = _directoryPath.substr(0,_directoryPath.find_last_of('\\'));
		}
		else
		{
			_directoryPath = _directoryList[0];
		}

		if (_fileList.size() == 1)
		{
			if (IsDSK(_fileList[0]))
			{
				_dskFilename = _fileList[0];
				_fileList.clear();
				_mode = RightClickDsk;
			}
			else
			{
				_mode = RightClickFile;
			}
		}
		else
		{
			if (_fileList.size() > 1)
			{
				_mode = RightClickFiles;
				if (IsDSK(_fileList[0]))
				{
					_dskList.clear();
					_dskList.push_back(_fileList[0]);
					for (int i=1;i<_fileList.size();i++)
					{
						if (IsDSK(_fileList[i]))
						{
							_dskList.push_back(_fileList[i]);
						}
					}
					_mode = RightClickDsks;
				}
				else
				{
					_mode = RightClickFiles;
				}
			}
			else
			{
				if (_directoryList.size() == 1)
				{
					_mode = RightClickDirectory;
				}
				else
				{
					_mode = RightClickDirectories;
				}
			}
		}

		return S_OK;
	}
	else
	{
		TCHAR dir [MAX_PATH];
		SHGetPathFromIDList ( pidlFolder, dir );
		_directoryPath = dir;

		_mode = RightClickBackground;

		return ( 1 > 0 ) ? S_OK : E_INVALIDARG;
	}
}

HRESULT CcpcFSShellExt::QueryContextMenu (
    HMENU hmenu,
    UINT  uMenuIndex, 
    UINT  uidFirstCmd,
    UINT  uidLastCmd,
    UINT  uFlags )
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState());

    // If the flags include CMF_DEFAULTONLY then we shouldn't do anything.
    if ( uFlags & CMF_DEFAULTONLY )
        return MAKE_HRESULT ( SEVERITY_SUCCESS, FACILITY_NULL, 0 );

    // First, create and populate a submenu.
    HMENU hSubmenu = CreatePopupMenu();
    UINT uID = uidFirstCmd;

	switch (_mode)
	{
	case RightClickFile:
	case RightClickFiles:
		{
			int idx = 0;
			InsertMenu ( hSubmenu, idx++, MF_BYPOSITION, uID++, _T("&Add to...") );
			std::string dskFile = _fileList[0];
			dskFile = dskFile.substr(0, dskFile.find_last_of('\\'));
			dskFile = dskFile.substr(dskFile.find_last_of('\\')+1, dskFile.size() - dskFile.find_last_of('\\'));
			dskFile += ".dsk";
			std::string message = "&Add to ";
			message += dskFile;
			InsertMenu ( hSubmenu, idx++, MF_BYPOSITION, uID++, message.c_str() );
			InsertMenu ( hSubmenu, idx++, MF_SEPARATOR, uID++, NULL );
			InsertMenu ( hSubmenu, idx++, MF_BYPOSITION, uID++, _T("&Send to A:") );
			InsertMenu ( hSubmenu, idx++, MF_BYPOSITION, uID++, _T("&Send to CPCBooster") );
			if (_mode == RightClickFile)
			{
				InsertMenu ( hSubmenu, idx++, MF_SEPARATOR, uID++, NULL );
				if (IsBinary(_fileList[0]))
				{
					InsertMenu ( hSubmenu, idx++, MF_BYPOSITION, uID++, _T("&Edit header") );
					InsertMenu ( hSubmenu, idx++, MF_BYPOSITION, uID++, _T("&Remove header") );
				}
				else
				{
					InsertMenu ( hSubmenu, idx++, MF_BYPOSITION, uID++, _T("&Add header") );
				}
			}
			break;
		}
	case RightClickDsk:
		{
			int idx = 0;
			InsertMenu ( hSubmenu, idx++, MF_BYPOSITION, uID++, _T("&Extract all to...") );
			InsertMenu ( hSubmenu, idx++, MF_BYPOSITION, uID++, _T("&Extract all here") );
			std::string dir = _dskFilename;
			dir = dir.substr(dir.find_last_of('\\')+1, dir.size()-dir.find_last_of('\\'));
			dir = dir.substr(0,dir.find_last_of('.'));
			std::string message = "&Extract to ";
			message += dir;
			message += "\\..";
			InsertMenu ( hSubmenu, idx++, MF_BYPOSITION, uID++, _T(message.c_str()) );
			InsertMenu ( hSubmenu, idx++, MF_SEPARATOR, uID++, NULL );
			InsertMenu ( hSubmenu, idx++, MF_BYPOSITION, uID++, _T("&Catalogue") );
			InsertMenu ( hSubmenu, idx++, MF_BYPOSITION, uID++, _T("&Disc info") );
			InsertMenu ( hSubmenu, idx++, MF_SEPARATOR, uID++, NULL );
			InsertMenu ( hSubmenu, idx++, MF_BYPOSITION, uID++, _T("&Send to A:") );
			InsertMenu ( hSubmenu, idx++, MF_BYPOSITION, uID++, _T("&Send to CPCBooster") );
			InsertMenu ( hSubmenu, idx++, MF_SEPARATOR, uID++, NULL );
			InsertMenu ( hSubmenu, idx++, MF_BYPOSITION, uID++, _T("&Format") );
			break;
		}
	case RightClickDsks:
		{
			int idx = 0;
			InsertMenu ( hSubmenu, idx++, MF_BYPOSITION, uID++, _T("&Extract all to directories") );
			InsertMenu ( hSubmenu, idx++, MF_BYPOSITION, uID++, _T("&Extract all here") );
			break;
		}
	case RightClickDirectory:
		{
			int idx = 0;
			InsertMenu ( hSubmenu, idx++, MF_BYPOSITION, uID++, _T("&Add all files to...") );
			std::string dir = _directoryList[0];
			dir = dir.substr(dir.find_last_of('\\')+1, dir.size()-dir.find_last_of('\\'));
			std::string message = "&Add all files to ";
			message += dir;
			message += ".dsk";
			InsertMenu ( hSubmenu, idx++, MF_BYPOSITION, uID++, _T(message.c_str()) );
			break;
		}
	case RightClickDirectories:
		{
			int idx = 0;
			InsertMenu ( hSubmenu, idx++, MF_BYPOSITION, uID++, _T("&Add all files to *.dsk") );
			break;
		}
	case RightClickBackground:
		{
			std::string title;
			std::string dskFilename = _directoryPath;
			dskFilename = dskFilename.substr(dskFilename.find_last_of('\\')+1,dskFilename.size() - dskFilename.find_last_of('\\'));
			dskFilename += ".dsk";

			int idx = 0;
			InsertMenu ( hSubmenu, idx++, MF_BYPOSITION, uID++, _T("&Create ...") );
			title = "&Create ";
			title += dskFilename;
			InsertMenu ( hSubmenu, idx++, MF_BYPOSITION, uID++, _T(title.c_str()) );
			break;
		}
	}

    // Insert the submenu into the ctx menu provided by Explorer.
    MENUITEMINFO mii = { sizeof(MENUITEMINFO) };

    mii.fMask = MIIM_SUBMENU | MIIM_STRING | MIIM_ID;
    mii.wID = uID++;
    mii.hSubMenu = hSubmenu;
    mii.dwTypeData = _T("C&pcFS Tools");

    InsertMenuItem ( hmenu, uMenuIndex, TRUE, &mii );

    return MAKE_HRESULT ( SEVERITY_SUCCESS, FACILITY_NULL, uID - uidFirstCmd );
}

HRESULT CcpcFSShellExt::GetCommandString (
    UINT  idCmd,
    UINT  uFlags,
    UINT* pwReserved,
    LPSTR pszName,
    UINT  cchMax )
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState());

    USES_CONVERSION;

    // Check idCmd, it must be 0 since we have only one menu item.
    if ( 0 != idCmd )
        return E_INVALIDARG;

    // If Explorer is asking for a help string, copy our string into the
    // supplied buffer.
    if ( uFlags & GCS_HELPTEXT )
        {
        LPCTSTR szText = _T("CPCFS extension help");

        if ( uFlags & GCS_UNICODE )
            {
            // We need to cast pszName to a Unicode string, and then use the
            // Unicode string copy API.
            lstrcpynW ( (LPWSTR) pszName, T2CW(szText), cchMax );
            }
        else
            {
            // Use the ANSI string copy API to return the help string.
            lstrcpynA ( pszName, T2CA(szText), cchMax );
            }

        return S_OK;
        }

    return E_INVALIDARG;
}

HRESULT CcpcFSShellExt::InvokeCommand ( LPCMINVOKECOMMANDINFO pCmdInfo )
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState());

    // If lpVerb really points to a string, ignore this function call and bail out.
    if ( 0 != HIWORD( pCmdInfo->lpVerb ))
        return E_INVALIDARG;

	switch (_mode)
	{
	case RightClickFile:
	case RightClickFiles:
		{			
			// Get the command index - the only valid one is 0.
			switch ( LOWORD( pCmdInfo->lpVerb ))
			{
			case 0:
				{
					CFileDialog newDsk(TRUE,
						".dsk",
						NULL,
						OFN_OVERWRITEPROMPT,
						"DSK Image file (*.dsk)|*.dsk||");
					int iRet = newDsk.DoModal();

					if(iRet == IDOK)
					{
						try
						{
							_dskFilename = newDsk.GetPathName();

							AddToDSK();
						}
						catch (tools::CException &e)
						{
							std::string errorMessage = e.GetErrorMessage();
							MessageBox ( pCmdInfo->hwnd, errorMessage.c_str(), "CPC File System error", MB_ICONERROR );
							return E_INVALIDARG;
						}
						break;
					}

					break;
				}
			case 1:
				{
					try
					{
						std::string dskFile = _fileList[0];
						dskFile = dskFile.substr(0, dskFile.find_last_of('\\'));
						dskFile = dskFile.substr(dskFile.find_last_of('\\')+1, dskFile.size() - dskFile.find_last_of('\\'));
						dskFile += ".dsk";
						dskFile = _fileList[0].substr(0, _fileList[0].find_last_of('\\')+1) + dskFile;
						
						_dskFilename = dskFile;

						AddToDSK();
					}
					catch (tools::CException &e)
					{
						std::string errorMessage = e.GetErrorMessage();
						MessageBox ( pCmdInfo->hwnd, errorMessage.c_str(), "CPC File System error", MB_ICONERROR );
						return E_INVALIDARG;
					}
					break;
				}
			case 3:
			case 4:
				{
					MessageBox ( pCmdInfo->hwnd, _T("Not implemented yet !"), "CPC File System", MB_ICONWARNING );
					break;
				}
			case 6:
				{
					if (IsBinary(_fileList[0]))
					{
						CCPCBinaryFile file;
						file.openFile(_fileList[0], false);

						CEditBinaryHeaderDlg editDlg;

						editDlg.SetStartValue(file.getAdress());
						editDlg.SetSizeValue(file.getSize());
						editDlg.SetExecValue(file.getExecute());

						if (editDlg.DoModal() == IDOK)
						{
							file.setAdress(editDlg.GetStartValue());
							file.setExecute(editDlg.GetExecValue());
							file.saveFile(_fileList[0], true);
						}
					}
					else
					{
						CCPCBinaryFile file;
						file.openFile(_fileList[0], true);

						CEditBinaryHeaderDlg editDlg;

						editDlg.SetStartValue(file.getAdress());
						editDlg.SetSizeValue(file.getSize());
						editDlg.SetExecValue(file.getExecute());

						if (editDlg.DoModal() == IDOK)
						{
							file.setAdress(editDlg.GetStartValue());
							file.setExecute(editDlg.GetExecValue());
							file.saveFile(_fileList[0], true);
						}
					}
					break;
				}
			case 7:
				{
					if (MessageBox ( pCmdInfo->hwnd, _T("Remove header will delete AMSDOS data\nAre you sure to remove header ?"), "CPC File System", MB_ICONQUESTION| MB_OKCANCEL ) == IDOK)
					{
						if (IsBinary(_fileList[0]))
						{
							CCPCBinaryFile file;
							file.openFile(_fileList[0], false);
							file.saveFile(_fileList[0], false);						
						}
					}
					break;
				}
			default:
				{
					return E_INVALIDARG;
				}
			}
			return S_OK;
			break;
		}
	case RightClickDsk:
		{
			switch ( LOWORD( pCmdInfo->lpVerb ))
			{
			case 0:
				{
					CDirectoryBrowse dlg;

					std::string initPath = _dskFilename;
					initPath = _directoryPath.substr(0,_directoryPath.find_last_of('.'));

					dlg.SetInitDir(initPath.c_str());

					std::string message = "Select directory to extract ";
					std::string file = _dskFilename;
					file = file.substr(file.find_last_of('\\')+1, file.size() - file.find_last_of('\\'));
					message += file;
							
					dlg.SetTitle(message.c_str());

					if(dlg.DoModal())
					{
						CString dirPath;
						dlg.GetDirectory(dirPath);

						_directoryPath = dirPath;

						try
						{
							ExtractToDirectory();
						}
						catch (tools::CException &e)
						{
							std::string errorMessage = e.GetErrorMessage();
							MessageBox ( pCmdInfo->hwnd, errorMessage.c_str(), "CPC File System error", MB_ICONERROR );
							return E_INVALIDARG;
						}
					}

					break;
				}
			case 1:
				{
					try
					{
						ExtractToDirectory();
					}
					catch (tools::CException &e)
					{
						std::string errorMessage = e.GetErrorMessage();
						MessageBox ( pCmdInfo->hwnd, errorMessage.c_str(), "CPC File System error", MB_ICONERROR );
						return E_INVALIDARG;
					}

					break;
				}
			case 2:
				{
					try
					{
						_directoryPath = _dskFilename;
						_directoryPath = _directoryPath.substr(0,_directoryPath.find_last_of('.'));
						
						ExtractToDirectory();
					}
					catch (tools::CException &e)
					{
						std::string errorMessage = e.GetErrorMessage();
						MessageBox ( pCmdInfo->hwnd, errorMessage.c_str(), "CPC File System error", MB_ICONERROR );
						return E_INVALIDARG;
					}
					break;
				}
			case 4:
				{
					try
					{

						CCPCDisc *disc = OpenDSK(false);
						if (disc != NULL)
						{
							CCatalogueDlg catDlg;

							catDlg.SetDSK(disc);

							catDlg.DoModal();

							disc->close();
							delete disc;
						}
					}
					catch (tools::CException &e)
					{
						std::string errorMessage = e.GetErrorMessage();
						MessageBox ( pCmdInfo->hwnd, errorMessage.c_str(), "CPC File System error", MB_ICONERROR );
						return E_INVALIDARG;
					}
		
					break;
				}
			case 5:
				{
					try
					{
						CCPCDisc *disc = OpenDSK(false);
						if (disc != NULL)
						{
							CDiscInfoDlg infoDlg;

							infoDlg.SetDSK(disc);

							infoDlg.DoModal();

							disc->close();
							delete disc;
						}
					}
					catch (tools::CException &e)
					{
						std::string errorMessage = e.GetErrorMessage();
						MessageBox ( pCmdInfo->hwnd, errorMessage.c_str(), "CPC File System error", MB_ICONERROR );
						return E_INVALIDARG;
					}
					break;
				}
			case 10:
				{
					if (MessageBox ( pCmdInfo->hwnd, _T("Format will delete all files\nAre you sure to format this dsk ?"), "CPC File System", MB_ICONQUESTION| MB_OKCANCEL ) == IDOK)
					{
						try
						{
							CCPCDisc *disc = OpenDSK(false);
							if (disc != NULL)
							{
								disc->format();
								disc->close();

								delete disc;
							}
						}
						catch (tools::CException &e)
						{
							std::string errorMessage = e.GetErrorMessage();
							MessageBox ( pCmdInfo->hwnd, errorMessage.c_str(), "CPC File System error", MB_ICONERROR );
							return E_INVALIDARG;
						}
					}
					break;
				}
			case 7:
			case 8:
				{
					MessageBox ( pCmdInfo->hwnd, _T("Not implemented yet !"), "CPC File System", MB_ICONWARNING );
					break;
				}
			default:
				{
					return E_INVALIDARG;
				}
			}
			return S_OK;
			break;
		}
	case RightClickDsks:
		{
			switch ( LOWORD( pCmdInfo->lpVerb ))
			{
			case 0:
				{
					for (int i=0;i<_dskList.size();i++)
					{
						_dskFilename = _dskList[i];
						_directoryPath = _dskFilename;
						_directoryPath = _directoryPath.substr(0,_directoryPath.find_last_of('.'));
						try
						{
							ExtractToDirectory();
						}
						catch (tools::CException &e)
						{
							std::string errorMessage = e.GetErrorMessage();
							MessageBox ( pCmdInfo->hwnd, errorMessage.c_str(), "CPC File System error", MB_ICONERROR );
							return E_INVALIDARG;
						}
					}

					break;
				}
			case 1:
				{
					for (int i=0;i<_dskList.size();i++)
					{
						_dskFilename = _dskList[i];
						try
						{
							ExtractToDirectory();
						}
						catch (tools::CException &e)
						{
							std::string errorMessage = e.GetErrorMessage();
							MessageBox ( pCmdInfo->hwnd, errorMessage.c_str(), "CPC File System error", MB_ICONERROR );
							return E_INVALIDARG;
						}
					}

					break;
				}
			default:
				{
					return E_INVALIDARG;
				}
			}
			return S_OK;
			break;
		}
	case RightClickDirectory:
		{
			switch ( LOWORD( pCmdInfo->lpVerb ))
			{
			case 0:
				{
					CFileDialog newDsk(TRUE,
						".dsk",
						NULL,
						OFN_OVERWRITEPROMPT,
						"DSK Image file (*.dsk)|*.dsk||");
					int iRet = newDsk.DoModal();

					if(iRet == IDOK)
					{
						try
						{
							_dskFilename = newDsk.GetPathName();

							FillFileList(_directoryList[0]);
							
							AddToDSK();
						}
						catch (tools::CException &e)
						{
							std::string errorMessage = e.GetErrorMessage();
							MessageBox ( pCmdInfo->hwnd, errorMessage.c_str(), "CPC File System error", MB_ICONERROR );
							return E_INVALIDARG;
						}
					}
					break;
				}
			case 1:
				{
					try
					{
						_dskFilename = _directoryList[0];
						_dskFilename += ".dsk";

						FillFileList(_directoryList[0]);
						
						AddToDSK();
					}
					catch (tools::CException &e)
					{
						std::string errorMessage = e.GetErrorMessage();
						MessageBox ( pCmdInfo->hwnd, errorMessage.c_str(), "CPC File System error", MB_ICONERROR );
						return E_INVALIDARG;
					}					

					break;
				}
			default:
				{
					return E_INVALIDARG;
				}
			}
			return S_OK;
			break;
		}
	case RightClickDirectories:
		{
			switch ( LOWORD( pCmdInfo->lpVerb ))
			{
			case 0:
				{
					for (int i=0 ; i<_directoryList.size() ; i++)
					{
						try
						{
							_dskFilename = _directoryList[i];
							_dskFilename += ".dsk";

							FillFileList(_directoryList[i]);
							
							AddToDSK();
						}
						catch (tools::CException &e)
						{
							std::string errorMessage = e.GetErrorMessage();
							MessageBox ( pCmdInfo->hwnd, errorMessage.c_str(), "CPC File System error", MB_ICONERROR );
							return E_INVALIDARG;
						}
					}					

					break;
				}
			default:
				{
					return E_INVALIDARG;
				}
			}
			return S_OK;
			break;
		}
	case RightClickBackground:
		{
			switch ( LOWORD( pCmdInfo->lpVerb ))
			{
			case 0:
				{
					SetCurrentDirectory(_directoryPath.c_str());

					CFileDialog newDsk(TRUE,
						".dsk",
						NULL,
						OFN_OVERWRITEPROMPT,
						"DSK Image file (*.dsk)|*.dsk||");
					
					int iRet = newDsk.DoModal();

					if(iRet == IDOK)
					{
						try
						{
							_dskFilename = newDsk.GetPathName();

							if (!CCPCDisc::isDSK(_dskFilename))
							{
								CCPCDisc *disc = CCPCDisc::createDisc(_dskFilename,_dskFormat,_dskSide);
							
								disc->format();
							
								disc->close();
								delete disc;
							}
						}
						catch (tools::CException &e)
						{
							std::string errorMessage = e.GetErrorMessage();
							MessageBox ( pCmdInfo->hwnd, errorMessage.c_str(), "CPC File System error", MB_ICONERROR );
							return E_INVALIDARG;
						}
						break;
					}

					break;
				}
			case 1:
				{
					std::string dskFile = _directoryPath;
					dskFile = dskFile.substr(dskFile.find_last_of('\\')+1,dskFile.size() - dskFile.find_last_of('\\'));
					dskFile += ".dsk";
					dskFile = _directoryPath + "\\" + dskFile;

					try
					{
						if (!CCPCDisc::isDSK(dskFile))
						{
							CCPCDisc *disc = CCPCDisc::createDisc(dskFile,_dskFormat,_dskSide);
						
							disc->format();
						
							disc->close();
							delete disc;
						}
					}
					catch (tools::CException &e)
					{
						std::string errorMessage = e.GetErrorMessage();
						MessageBox ( pCmdInfo->hwnd, "Error", errorMessage.c_str(), MB_ICONINFORMATION );
						return E_INVALIDARG;
					}
					
					break;
				}
			default:
				{
					return E_INVALIDARG;
				}
			}
			return S_OK;
			break;
		}
	default:
		{
			return E_INVALIDARG;
		}
	}
}

bool CcpcFSShellExt::IsFileExist(std::string &file)
{
	WIN32_FIND_DATA FindFileData;
	HANDLE hFind;

	hFind = FindFirstFile(file.c_str(), &FindFileData);
	if (hFind == INVALID_HANDLE_VALUE) 
	{
		return false;
	}
	else
	{
		FindClose(hFind);
		return true;
	}
	return false;
}
bool CcpcFSShellExt::IsBinary(std::string &file)
{
	try
	{
		return CCPCBinaryFile::isFileBinary(file);
	}
	catch (tools::CException)
	{
		return false;
	}
}
bool CcpcFSShellExt::IsDSK(std::string &file, int side)
{
	return CCPCDisc::isDSK(file, side);
}

CCPCDisc* CcpcFSShellExt::OpenDSK(bool create)
{
	CCPCDisc *disc;
	if (IsDSK(_dskFilename, _dskSide))
	{
		disc = CCPCDisc::openDisc(_dskFilename, _dskSide);
	}
	else
	{
		if (IsFileExist(_dskFilename))
		{
			TOOLS_ERRORMSG("Do not seems to be a valid DSK");
		}
		else
		{
			if (create)
			{
				disc = CCPCDisc::createDisc(_dskFilename, _dskFormat, _dskSide);
				disc->format();
				disc->close();
				delete disc;
				disc = CCPCDisc::openDisc(_dskFilename, _dskSide);
			}
		}
	}
	
	return disc;
}

void CcpcFSShellExt::ExtractToDirectory()
{
	CCPCDisc *disc = OpenDSK(false);
	
	if (!IsFileExist(_directoryPath))
	{
		CreateDirectory(_directoryPath.c_str(), NULL);
	}

	unsigned int nbFiles = disc->getNbFiles();
	if (nbFiles != 0)
	{
		for (unsigned int i=0;i<nbFiles;i++)
		{
			int user;
			std::string filename = disc->getFilename(i, user);
			
			CCPCFile *file = disc->getFile(filename, user);

			if (user != 0)
			{
				char userStr[16];
				sprintf(userStr, "%d_", user);
				filename = userStr + filename;
			}
			
			filename = _directoryPath + '\\' + filename;
			file->saveFile(filename,true);
			delete file;
		}
	}
	
	disc->close();
	delete disc;
}

void CcpcFSShellExt::AddToDSK()
{
	unsigned int nbFiles = _fileList.size();

	if (nbFiles == 0)
		return;

	CCPCDisc *disc = OpenDSK(true);

	std::string unableToPutFile;

	for (unsigned int i=0;i<nbFiles;i++)
	{
		if (CCPCBinaryFile::isFileBinary(_fileList[i]))
		{
			CCPCBinaryFile fileIn;
			fileIn.openFile(_fileList[i],false);
			try
			{
				disc->putFile(fileIn,_fileList[i]);
			}
			catch (tools::CException &)
			{
				unableToPutFile += _fileList[i];
				unableToPutFile += "\n";
			}
		}
		else
		{
			CCPCAsciiFile fileIn;
			fileIn.openFile(_fileList[i],false);
			try
			{
				disc->putFile(fileIn,_fileList[i]);
			}
			catch (tools::CException &)
			{
				unableToPutFile += _fileList[i];
				unableToPutFile += "\n";
			}
		}
	}

	disc->close();
	delete disc;

	if (unableToPutFile.size() != 0)
	{
		TOOLS_ERRORMSG("Unable to put files\n" << unableToPutFile);
	}
}

void CcpcFSShellExt::FillFileList(std::string &directory)
{
	_fileList.clear();

	WIN32_FIND_DATA FindFileData;
	HANDLE hFind = INVALID_HANDLE_VALUE;

	std::string dir = directory;
	std::string dirSpec = directory;
	if (dir[dir.size()-1] == '\\')
	{
		dirSpec += "*.*";
	}
	else
	{
		dir += "\\";
		dirSpec += "\\*.*";
	}
	
	hFind = FindFirstFile(dirSpec.c_str(), &FindFileData);

	if (hFind != INVALID_HANDLE_VALUE) 
	{
		std::string file = dir+FindFileData.cFileName;
		if (file != "." && file != ".."&&
			(GetFileAttributes(file.c_str()) & FILE_ATTRIBUTE_DIRECTORY) == 0)
		{
			_fileList.push_back(file);
		}
		while (FindNextFile(hFind, &FindFileData) != 0) 
		{
			file = dir+FindFileData.cFileName;
			DWORD attrib = GetFileAttributes(file.c_str());
			if (file != "." && file != ".."&&
				(attrib & FILE_ATTRIBUTE_DIRECTORY) == 0)
			{
				_fileList.push_back(file);
			}
		}

		FindClose(hFind);
	}
}
