// cpcFSShellExt.h : Declaration of the CcpcFSShellExt

#ifndef __CPCFSSHELLEXT_H_
#define __CPCFSSHELLEXT_H_

#pragma warning(disable : 4530)

#include "resource.h"       // main symbols
#include <shlobj.h>
#include <comdef.h>
#include <vector>

#include "CCPCDisc.h"

/////////////////////////////////////////////////////////////////////////////
// CcpcFSShellExt
class ATL_NO_VTABLE CcpcFSShellExt : 
	public CComObjectRootEx<CComSingleThreadModel>,
	public CComCoClass<CcpcFSShellExt, &CLSID_cpcFSShellExt>,
	public IDispatchImpl<IcpcFSShellExt, &IID_IcpcFSShellExt, &LIBID_CPCFSEXTLib>,
	public IShellExtInit,
	public IContextMenu
{
public:
	CcpcFSShellExt();

DECLARE_REGISTRY_RESOURCEID(IDR_CPCFSSHELLEXT)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CcpcFSShellExt)
	COM_INTERFACE_ENTRY(IcpcFSShellExt)
	COM_INTERFACE_ENTRY(IDispatch)
	COM_INTERFACE_ENTRY(IShellExtInit)
	COM_INTERFACE_ENTRY(IContextMenu)
END_COM_MAP()

protected:
	enum CPCFSInterfaceMode
	{
		Unknown,
		RightClickBackground,
		RightClickFile,
		RightClickFiles,
		RightClickDsk,
		RightClickDsks,
		RightClickDirectory,
		RightClickDirectories
	};
protected:
	CPCFSInterfaceMode						_mode;

	std::string								_directoryPath;
	std::vector< std::basic_string<TCHAR> >	_fileList;
	std::vector< std::basic_string<TCHAR> >	_dskList;
	std::vector< std::basic_string<TCHAR> >	_directoryList;

	std::string								_dskFilename;
	int										_dskSide;
	CCPCDisc::TDisc							_dskFormat;

public:
    STDMETHOD(Initialize)(LPCITEMIDLIST, LPDATAOBJECT, HKEY);
    STDMETHOD(GetCommandString)(UINT, UINT, UINT*, LPSTR, UINT);
    STDMETHOD(InvokeCommand)(LPCMINVOKECOMMANDINFO);
    STDMETHOD(QueryContextMenu)(HMENU, UINT, UINT, UINT, UINT);
	
protected:
	//! Check if file exists
	bool IsFileExist(std::string &file);
	//! Check if file has binary header
	bool IsBinary(std::string &file);
	//! Check if file is a .dsk file
	bool IsDSK(std::string &file, int side = 0);

	//! Extract all .dsk file to directory
	void ExtractToDirectory();
	//! Create a new dsk
	CCPCDisc* OpenDSK(bool create=false);
	//! Add all file to a .dsk
	void AddToDSK();
	//! Fill fileList with files in directory
	void FillFileList(std::string &directory);
};

#endif //__CPCFSSHELLEXT_H_
