# Customizable datas (language, plattform related datas...)

CC=gcc
FLAGS= -Wall -ansi -pedantic
TMPFILES = *.o *~
DIR=Hideur2.0
FILES=INSTALLFR ALIRE hideur
ARCHIVE=hideur-linux.fr

LG= -DFRENCH # Franais

EXE=hideur # Nom de l'excutable

CLEANCMD=rm -f # commande d'effacement (Unix, Linux...)

# Variables de compilation - ne pas diter

#DEBUG=-DDBG

hideur : header.o main.o
	$(CC) -o $(EXE) header.o main.o $(FLAGS) $(LG) $(DEBUG)
	@echo Ok...
	@hideur

header.o : header.c header.h messages.h debug.h aff.h
	$(CC) -c header.c  $(LG) $(DEBUG) $(OS)

main.o : main.c header.h header.c messages.h debug.h
	$(CC) -c main.c  $(LG) $(DEBUG) $(OS)

clean :
	@$(CLEANCMD) $(TMPFILES)
	@echo Ok...

superclean :
	@$(CLEANCMD) $(TMPFILES) $(EXE)

idiot :
	@echo Agaaaa...gagaga.

tar :
	@echo "Cration de l'archive" $(ARCHIVE).tar.gz ...
	@mkdir $(DIR)
	@cp $(FILES) $(DIR)
	@tar cvfz $(ARCHIVE).tar.gz  $(DIR) > /dev/null
	@rm -fr $(DIR)


