/**
 * @class CCPCAsciiFile
 * Classe permettant la gestion d'un fichier binaire CPC
 * @author Thierry JOUIN
 * @version 1.1
 * @date 31/10/2001
 */

#include <iostream>
#include <fstream>

#include <string>
#include <stdio.h>
#include <stdlib.h>
#include "libdsk.h"
#include <errno.h>
#include <string.h>

#include "CError.h"

#include "CCPCFile.h"

#ifndef _CCPCASCIIFILE_HH_
#define _CCPCASCIIFILE_HH_

class CCPCAsciiFile:public CCPCFile
{
private:
  /// Contenu du fichier
  unsigned char *_content;
  /// Taille du fichier
  unsigned int _size;

protected:
  /// Affiche les infos sur le ficher
  virtual std::ostream& printInfo(std::ostream &io_os) const;

public:
  /// Constructeur
  CCPCAsciiFile();
  /// Destructeur
  ~CCPCAsciiFile();

  /// Renvoie le type de fichier
  virtual TFileType getType() const;

  /// Renvoie la taille du fichier (en octet)
  virtual unsigned int getSize() const;

  /// Creation d'un fichier a partir d'un buffer
  virtual void createFile(const void* i_buffer, const unsigned int i_size, bool i_createHeader = false);
  /// Lecture et creation d'un fichier a partir d'un fichier
  virtual void openFile(const std::string &i_filename,bool i_createHeader = false);
  /// Ecriture d'un fichier dans une stream
  virtual void saveFile(const std::string &i_filename,bool i_saveHeader = true) const;

  /// Renvoie la taille des donnees contenues dans le fichier (header eventuellement compris)
  virtual unsigned int getDatasSize() const;
  /// Renvoie un pointeur sur les donnees contenues dans le fichier
  virtual unsigned char* getDatas() const;

  /// Affichage du header du fichier
  virtual std::ostream& printHeader(std::ostream& io_os) const;
  /// Affichage de contenu du fichier
  virtual std::ostream& printContent(std::ostream& io_os) const;

};

#endif
