#ifndef BITMAPCPC_H
#define BITMAPCPC_H


#define     TAILLE_CPC_X    640

#define     TAILLE_CPC_Y    200

#define     MARKER_OCP      1       // Marker pour compression RLE


typedef struct
    {
    BYTE b, v, r, a;
    } StRVB;


class CBitmapCPC
{
public :
    CBitmapCPC( void ) { NbCol = 80; NbLignes = 200; }
    BOOL LireImage( char * Nom, StRVB * Bitmap );
    void Render( StRVB * Bitmap, BOOL Flat = FALSE );
    void SetBitmapCPC( BYTE * BitmapSource );
    BYTE * GetBitmapCPC( void ) { return( BitmapCPC ); }
    void SetMode( int m ) { Mode = m; }
    void InitPalette( BYTE Pal[ 16 ], BOOL SetPal );
    BYTE * GetPalette( void ) { return( Palette ); }
    int GetMode( void ) { return( Mode ); }
    void SetNbCol( int n );
    void SetNbLignes( int n );

private :
    void DepactOCP( void );
    void LisseBitmap( StRVB * Bitmap );

    BYTE BitmapCPC[ 0x4000 ];
    BYTE Palette[ 16 ];
    int Mode, NbCol, NbLignes;
};


StRVB GetPalCPC( int Coul );

int GetRgbCPC( int Coul );


#endif
