// ManageDskDlg.cpp : implementation file
//

#include  <afxwin.h>
#include  <afxcmn.h>
#include  <afxdlgs.h>
#include  <afxext.h>
#include  <afxole.h>

#include  "Locale.h"
#include  "GestDsk.h"
#include  "Resource.h"
#include  "ViewFile.h"
#include  "ManageDsk.h"
#include  "TypeFichier.h"
#include  "InfoFichier.h"
#include  "ManageDskDlg.h"
#include  "EditSecteurs.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CManageDskDlg dialog

CManageDskDlg::CManageDskDlg(CWnd* pParent /*=NULL*/)
    : CDialog(CManageDskDlg::IDD, pParent)
{
    //{{AFX_DATA_INIT(CManageDskDlg)
    //}}AFX_DATA_INIT
    Langue = LOC_FRANCAIS;
    IsDsk = FALSE;
}


void CManageDskDlg::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CManageDskDlg)
    DDX_Control(pDX, IDC_EDIT_FIC, m_BpEditFic);
    DDX_Control(pDX, IDC_STATIC_MODE_EXP, m_ModeExport);
    DDX_Control(pDX, IDC_RADIO_EXP_BIN, m_RadioExpBin);
    DDX_Control(pDX, IDC_RADIO_EXP_ASCII, m_RadioExpAscii);
    DDX_Control(pDX, IDC_EDIT_SECTEURS, m_Secteurs);
    DDX_Control(pDX, IDC_SAUVE_DIRECT, m_BpSauveDirect);
    DDX_Control(pDX, IDC_STATIC_MODE_AJ, m_ModeAjout);
    DDX_Control(pDX, IDC_RADIO_FORCE_BIN, m_RadioForceBin);
    DDX_Control(pDX, IDC_RADIO_FORCE_ASCII, m_RadioForceAscii);
    DDX_Control(pDX, IDC_RADIO_CHOIX, m_RadioChoix);
    DDX_Control(pDX, IDC_KO_UTIL, m_KoUtilTxt);
    DDX_Control(pDX, IDC_CONTENU_DSK, m_ContenuDsk);
    DDX_Control(pDX, IDC_CREER, m_BpCreer);
    DDX_Control(pDX, IDC_LIRE, m_BpLire);
    DDX_Control(pDX, IDC_SUPPRIME, m_BpSupprime);
    DDX_Control(pDX, IDC_SAUVE, m_BpSauve);
    DDX_Control(pDX, IDC_BP_EN, m_BpEn);
    DDX_Control(pDX, IDC_BP_FR, m_BpFr);
    DDX_Control(pDX, IDC_EXPORT, m_BpExport);
    DDX_Control(pDX, IDC_RENOME, m_BpRenome);
    DDX_Control(pDX, IDC_NETTOIE, m_Nettoie);
    DDX_Control(pDX, IDC_KOUTIL, m_KoUtil);
    DDX_Control(pDX, IDC_AJOUTEFIC, m_BpAjoute);
    DDX_Control(pDX, IDC_NOMDSK, m_NomDsk);
    DDX_Control(pDX, IDC_LIST, m_Liste);
    //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CManageDskDlg, CDialog)
    //{{AFX_MSG_MAP(CManageDskDlg)
    ON_BN_CLICKED(IDC_AJOUTEFIC, OnAjoutefic)
    ON_BN_CLICKED(IDC_LIRE, OnLire)
    ON_BN_CLICKED(IDC_SAUVE, OnSauve)
    ON_BN_CLICKED(IDC_CREER, OnCreer)
    ON_NOTIFY(NM_RCLICK, IDC_LIST, OnRclickList)
    ON_BN_CLICKED(IDC_EXPORT, OnExport)
    ON_BN_CLICKED(IDC_RENOME, OnRenome)
    ON_BN_CLICKED(IDC_SUPPRIME, OnSupprime)
    ON_BN_CLICKED(IDC_BP_EN, OnBpEn)
    ON_BN_CLICKED(IDC_BP_FR, OnBpFr)
    ON_BN_CLICKED(IDC_RADIO_FORCE_BIN, OnRadioForceBin)
    ON_BN_CLICKED(IDC_RADIO_CHOIX, OnRadioChoix)
    ON_BN_CLICKED(IDC_RADIO_FORCE_ASCII, OnRadioForceAscii)
    ON_BN_CLICKED(IDC_SAUVE_DIRECT, OnSauveDirect)
    ON_NOTIFY(NM_DBLCLK, IDC_LIST, OnDblclkList)
    ON_BN_CLICKED(IDC_EDIT_SECTEURS, OnEditSecteurs)
    ON_BN_CLICKED(IDC_RADIO_EXP_ASCII, OnRadioExpAscii)
    ON_BN_CLICKED(IDC_RADIO_EXP_BIN, OnRadioExpBin)
    ON_WM_QUERYDRAGICON()
    ON_BN_CLICKED(IDC_EDIT_FIC, OnEditFic)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CManageDskDlg message handlers


enum { COL_NOM, COL_USER, COL_READONLY, COL_HIDDEN, COL_TYPE, COL_TAILLE };


//
// Initialisation de l'interface
//
BOOL CManageDskDlg::OnInitDialog()
{
    CDialog::OnInitDialog();

    m_BpSauve.EnableWindow( FALSE );
    m_BpSauveDirect.EnableWindow( FALSE );
    m_Secteurs.EnableWindow( FALSE );
    m_BpAjoute.EnableWindow( FALSE );
    m_BpExport.EnableWindow( FALSE );
    m_BpRenome.EnableWindow( FALSE );
    m_BpSupprime.EnableWindow( FALSE );
    m_BpEditFic.EnableWindow( FALSE );

    m_BpFr.LoadBitmaps( IDB_FR );
    m_BpEn.LoadBitmaps( IDB_EN );

    m_RadioChoix.SetCheck( 1 );
    OnRadioChoix();
    m_RadioExpBin.SetCheck( 1 );
    OnRadioExpBin();

    SetInterface( Langue );

    return( TRUE );
}


//
// L'appui sur la touche entre ne fait rien
//
void CManageDskDlg::OnOK()
{
}


//
// Fonction de tri des fichiers
//
int FctTri( const void * a1, const void * a2 )
{
    static char Nom1[ 12 ];
    static char Nom2[ 12 ];

    memset( Nom1, 0, sizeof( Nom1 ) );
    memset( Nom2, 0, sizeof( Nom2 ) );
    memcpy( Nom1, ( char * )( ( StDirEntry * )a1 )->Nom, 11 );
    memcpy( Nom2, ( char * )( ( StDirEntry * )a2 )->Nom, 11 );

    BYTE User1 = ( ( StDirEntry * )a1 )->User;
    BYTE User2 = ( ( StDirEntry * )a2 )->User;
    //
    // Un fichier effac doit se mettre en fin de liste
    //
    if ( User1 == USER_DELETED || User2 == USER_DELETED )
        return( User1 - User2 );

    //
    // Masquer les bits 7 dans les noms (par exemples : bits d'attributs)
    //
    Nom1[ 11 ] = Nom2[ 11 ] = 0;
    for ( int i = 0; i < 11; i++ )
        {
        Nom1[ i ] &= 0x7F;
        Nom2[ i ] &= 0x7F;
        }

    int a = strcmp( Nom1, Nom2 );
    if ( ! a )
        a = ( ( StDirEntry * )a1 )->NumPage - ( ( StDirEntry * )a2 )->NumPage;

    return( a );
}


//
// Lecture et affichage du contenu d'un fichier DSK
//
void CManageDskDlg::ReadDirDsk( void )
{
    if ( IsDsk )
        {
        //
        // Tout remettre  zro
        //
        int NbItems = 0;
        m_Liste.DeleteAllItems();
        memset( PosItem, 0, sizeof( PosItem ) );

        //
        // Rcupre la table des rpertoires
        //
        for ( int i = 0; i < 64; i++ )
            memcpy( &TabDir[ i ]
                  , GetInfoDirEntry( i )
                  , sizeof( StDirEntry )
                  );
        // Trier les fichiers
        qsort( TabDir, 64, sizeof( TabDir[ 0 ] ), FctTri );

        //
        // Affichage...
        //
        for ( i = 0; i < 64; i++ )
            {
            SetInfoDirEntry( i, &TabDir[ i ] );
            //
            // Afficher les fichiers non ffacs
            //
            if ( TabDir[ i ].User != USER_DELETED && ! TabDir[ i ].NumPage )
                {
                memcpy( Nom, TabDir[ i ].Nom, 8 );
                memcpy( &Nom[ 9 ], TabDir[ i ].Ext, 3 );
                Nom[ 8 ] = '.';
                Nom[ 12 ] = 0;
                //
                // Masquer les bits d'attributs
                //
                for ( int j = 0; j < 12; j++ )
                    Nom[ j ] &= 0x7F;

                m_Liste.InsertItem( NbItems, GetNomAmsdos( ( BYTE * )Nom ) );
                StAmsdos * Ams = ( StAmsdos * )ReadBloc( TabDir[ i ].Blocks[ 0 ] );
                m_Liste.SetItemText( NbItems
                                   , COL_USER
                                   , GetUser( TabDir[ i ].User )
                                   );
                m_Liste.SetItemText( NbItems
                                   , COL_READONLY
                                   , TabDir[ i ].Ext[ 0 ] & 0x80 ? "[X]" : ""
                                   );
                m_Liste.SetItemText( NbItems
                                   , COL_HIDDEN
                                   , TabDir[ i ].Ext[ 1 ] & 0x80 ? "[X]" : ""
                                   );
                m_Liste.SetItemText( NbItems, COL_TYPE, GetType( Langue, Ams ) );

                //
                // Calcule la taille du fichier en fonction du nombre de blocs
                //
                int p = 0, t = 0;
                do
                    {
                    if ( TabDir[ p + i ].User == TabDir[ i ].User )
                        t += TabDir[ p + i ].NbPages;

                    p++;
                    }
                while( TabDir[ p + i ].NumPage && ( p + i ) < 64  );
                m_Liste.SetItemText( NbItems, COL_TAILLE, GetTaille( ( t + 7 ) >> 3 ) );
                PosItem[ NbItems++ ] = i;
                }
            }
        //
        // Affichage taille utilise par tous les fichiers
        //
        m_KoUtil.SetWindowText( itoa( FillBitmap(), Msg, 10 ) );
        }
}


//
// Ajouter un fichier
//
void CManageDskDlg::OnAjoutefic()
{
    static BYTE Buff[ 0x20000 ];
    static char Noms[ 0x1000 ];
    DWORD Lg;

    CFileDialog f( TRUE
                 , NULL
                 , NULL
                 , OFN_FILEMUSTEXIST | OFN_ALLOWMULTISELECT
                 , GetTexteLoc( 14, Langue )
                 );
    * Noms = 0;
    f.m_ofn.lpstrFile = Noms;
    f.m_ofn.nMaxFile = sizeof( Noms );
    if ( f.DoModal() != IDCANCEL )
        {
        POSITION PosFic = f.GetStartPosition();
        while( PosFic )
            {
            BOOL FicValid = TRUE;
            //
            // Parcourir tous les fichiers slectionns
            //
            CString Path = f.GetNextPathName( PosFic );
            char * p = ( char * )( const char * )Path;
            char * q = p;
            char * r;
            //
            // Normalise le nom du fichier en cours
            //
            do
                {
                r = strchr( q, ':' );
                if ( ! r )
                    r = strchr( q, '\\' );

                if ( r )
                    q = ++r;
                }
            while( r );
            char * NomFic = q;

            HANDLE fp = CreateFile( p
                                 , GENERIC_READ
                                 , 0
                                 , NULL
                                 , OPEN_EXISTING
                                 , 0
                                 , NULL
                                 );
            if ( fp != INVALID_HANDLE_VALUE )
                {
                memset( Buff, 0, sizeof( Buff ) );
                // Lecture fichier
                ReadFile( fp, &Buff, sizeof( Buff ), &Lg, NULL );
                CloseHandle( fp );
                BOOL AjouteEntete = FALSE;
                StAmsdos * e = ( StAmsdos * )Buff;
                // Attention : longueur > 64Ko !
                if ( Lg > 0x10080 )
                    FicValid = ( MessageBox( GetTexteLoc( 15, Langue )
                                           , NomFic
                                           , MB_YESNO | MB_ICONQUESTION
                                           ) == IDYES
                                );
                if ( FicValid )
                    {
                    //
                    // Regarde si le fichier contient une en-tte ou non
                    //
                    BOOL IsAmsdos = CheckAmsdos( Buff );

                    if ( ! IsAmsdos )
                        // Crer une en-tte amsdos par dfaut
                        e = CreeEnteteAmsdos( NomFic, ( USHORT )Lg );

                    CTypeFichier DialType( TypeModeImport
                                         , e
                                         , IsAmsdos
                                         , Langue
                                         , NomFic
                                         );
                    //
                    // En fonction du mode d'importation...
                    //
                    switch( TypeModeImport )
                        {
                        case MODE_ASCII :
                            //
                            // Importation en mode ASCII
                            //
                            if ( IsAmsdos )
                                {
                                // Supprmier en-tte si elle existe
                                memcpy( Buff
                                      , &Buff[ sizeof( StAmsdos ) ]
                                      , Lg - sizeof( StAmsdos )
                                      );
                                Lg -= sizeof( StAmsdos );
                                }
                            FicValid = TRUE;
                            break;

                        case MODE_BINAIRE :
                            //
                            // Importation en mode BINAIRE
                            //
                            DialType.DoModal();
                            if ( ! IsAmsdos )
                                //
                                // Indique qu'il faudra ajouter une en-tte
                                //
                                AjouteEntete = TRUE;
                            break;

                        case MODE_USER :
                            //
                            // Importation en mode choix utilisateur
                            //
                            DialType.DoModal();
                            if (  DialType.GetTypeModeImport() == MODE_BINAIRE
                               && ! IsAmsdos
                               )
                                //
                                // Indique qu'il faudra ajouter une en-tte
                                //
                                AjouteEntete = TRUE;
                            break;
                        }
                    }
                //
                // Si fichier ok pour tre import
                //
                if ( FicValid )
                    {
                    if ( m_Nettoie.GetCheck() )
                        ClearAmsdos( Buff );

                    if ( AjouteEntete )
                        {
                        // Ajoute l'en-tte amsdos si ncessaire
                        memmove( &Buff[ sizeof( StAmsdos ) ], Buff, Lg );
                        memcpy( Buff, e, sizeof( StAmsdos ) );
                        Lg += sizeof( StAmsdos );
                        }
                    // Ajoute le fichier sur le DSK
                    int Res = CopieFichier( Buff, NomFic, Lg );
                    if ( Res == ERR_NO_ERR )
                        ReadDirDsk();
                    else
                        {
                        // Erreur d'ajout du fichier...
                        switch( Res )
                            {
                            case ERR_NO_DIRENTRY :
                                MessageBox( GetTexteLoc( 17, Langue ) );
                                break;

                            case ERR_NO_BLOCK :
                                MessageBox( GetTexteLoc( 18, Langue ) );
                                break;
                            }
                        }
                    }
                }
            }
        }
}


//
// Crer un DSK vierge
//
void CManageDskDlg::OnCreer()
{
    IsDsk = TRUE;
    FormatDsk( 9, 40 );     // 9 secteurs et 40 pistes
    ReadDirDsk();
    //
    // Autoriser les boutons de l'interface
    //
    m_BpAjoute.EnableWindow( TRUE );
    m_BpExport.EnableWindow( TRUE );
    m_BpRenome.EnableWindow( TRUE );
    m_BpSupprime.EnableWindow( TRUE );
    m_BpSauve.EnableWindow( TRUE );
    m_BpSauveDirect.EnableWindow( TRUE );
    m_Secteurs.EnableWindow( TRUE );
    m_BpEditFic.EnableWindow( TRUE );

    // Nom par dfaut du DSK
    strcpy( Nom, "Disquette_Vide.DSK" );
    m_NomDsk.SetWindowText( Nom );
}


//
// Lecture d'un fichier DSK
//
void CManageDskDlg::OnLire()
{
    CFileDialog f( TRUE
                 , NULL
                 , NULL
                 , OFN_FILEMUSTEXIST
                 , GetTexteLoc( 19, Langue )
                 );
    if ( f.DoModal() == IDOK )
        {
        m_NomDsk.SetWindowText( f.GetPathName() );
        m_NomDsk.GetWindowText( Nom, sizeof( Nom ) );
        if ( ReadDsk( Nom ) )
            {
            IsDsk = TRUE;
            ReadDirDsk();
            //
            // Autoriser les boutons de l'interface
            //
            m_BpAjoute.EnableWindow( TRUE );
            m_BpExport.EnableWindow( TRUE );
            m_BpRenome.EnableWindow( TRUE );
            m_BpSupprime.EnableWindow( TRUE );
            m_BpSauve.EnableWindow( TRUE );
            m_BpSauveDirect.EnableWindow( TRUE );
            m_Secteurs.EnableWindow( TRUE );
            m_BpEditFic.EnableWindow( TRUE );
            }
        else
            MessageBox( GetTexteLoc( 20, Langue ) );
        }
}


//
// Sauvegarde du fichier DSK en demandant le nom
//
void CManageDskDlg::OnSauve()
{
    m_NomDsk.GetWindowText( Nom, sizeof( Nom ) );
    if ( IsDsk )
        {
        CFileDialog f( FALSE
                     , "*.DSK"
                     , Nom
                     , OFN_OVERWRITEPROMPT
                     , GetTexteLoc( 19, Langue )
                     );
        if ( f.DoModal() == IDOK )
            {
            m_NomDsk.SetWindowText( f.GetPathName() );
            m_NomDsk.GetWindowText( Nom, sizeof( Nom ) );
            WriteDsk( Nom );
            }
        }
}


//
// Sauvegarde "directe" du fichier DSK
//
void CManageDskDlg::OnSauveDirect()
{
    m_NomDsk.GetWindowText( Nom, sizeof( Nom ) );
    if ( * Nom )
        {
        WriteDsk( Nom );
        wsprintf( Msg, GetTexteLoc( 47, Langue ), Nom );
        MessageBox( Msg );
        }
    else
        MessageBox( GetTexteLoc( 48, Langue ) );
}


//
// Gestion du "click droit" sur la liste des fichiers
//
void CManageDskDlg::OnRclickList(NMHDR * pNMHDR, LRESULT * pResult)
{
    POSITION pos = m_Liste.GetFirstSelectedItemPosition();
    if ( pos )
        {
        int nItem = m_Liste.GetNextSelectedItem( pos );
        // Recherche le direntry correspondant
        int i = PosItem[ nItem ];
        CInfoFichier Info( TabDir, i, Langue, FALSE );
        Info.DoModal();
        if ( Info.IsValide() )
            {
            char NomFic[ 16 ];
            strcpy( NomFic, GetNomAmsdos( TabDir[ i ].Nom ) );
            BOOL First = FALSE;
            char * p;
            do
                {
                //
                // Relecture du premier bloc du fichier
                //
                BYTE * b = ReadBloc( TabDir[ i ].Blocks[ 0 ] );
                BYTE * e = ( BYTE * )Info.GetAms();
                //
                // Recopie l'en-tte amsdos modifie par l'utilisateur
                //
                if ( ! First && CheckAmsdos( b ) )
                    {
                    memcpy( b, e, sizeof( StAmsdos ) );
                    First = TRUE;
                    }
                //
                // Positionne le flag "read only"
                //
                if ( Info.IsReadOnly() )
                    TabDir[ i ].Ext[ 0 ] |= 0x80;
                else
                    TabDir[ i ].Ext[ 0 ] &= ~0x80;

                //
                // Positionne le flag "systme" (fichier cach)
                //
                if ( Info.IsHidden() )
                    TabDir[ i ].Ext[ 1 ] |= 0x80;
                else
                    TabDir[ i ].Ext[ 1 ] &= ~0x80;

                SetInfoDirEntry( i, &TabDir[ i ] );
                //
                // Rcriture du premier bloc du fichier
                //
                WriteBloc( TabDir[ i ].Blocks[ 0 ], b );
                p = GetNomAmsdos( TabDir[ ++i ].Nom );
                }
            while( ! strncmp( NomFic
                            , p
                            , max( strlen( p ), strlen( NomFic ) )
                            )
                 );
            ReadDirDsk();
            }
        }
    * pResult = 0;
}


//
// Double click = Click droit
//
void CManageDskDlg::OnDblclkList(NMHDR* pNMHDR, LRESULT* pResult) 
{
    OnRclickList( pNMHDR, pResult );
    * pResult = 0;
}


//
// Export de fichiers
//
void CManageDskDlg::OnExport()
{
    DWORD Lg;

    POSITION pos = m_Liste.GetFirstSelectedItemPosition();
    while( pos )
        {
        int nItem = m_Liste.GetNextSelectedItem( pos );
        m_Liste.GetItemText( nItem, COL_TAILLE, Msg, sizeof( Msg ) );
        int Ko = atoi( Msg );
        // Recherche le direntry correspondant
        int Indice = PosItem[ nItem ];
        CFileDialog SelectFic( FALSE
                             , NULL
                             , GetNomAmsdos( TabDir[ Indice ].Nom )
                             , OFN_OVERWRITEPROMPT
                             , NULL
                             );
        if ( SelectFic.DoModal() == IDOK )
            {
            HANDLE f = CreateFile( SelectFic.GetPathName()
                                 , GENERIC_WRITE
                                 , 0
                                 , NULL
                                 , CREATE_ALWAYS
                                 , 0
                                 , NULL
                                 );
            if ( f != INVALID_HANDLE_VALUE )
                {
                char NomFic[ 16 ];
                int i = Indice;
                BOOL FirstBlock = TRUE;
                strcpy( NomFic, GetNomAmsdos( TabDir[ i ].Nom ) );
                char * p;
                int lMax = 0x1000000;
                do
                    {
                    // Longueur du fichier
                    int l = ( TabDir[ i ].NbPages + 7 ) >> 3;
                    for ( int j = 0; j < l; j++ )
                        {
                        int TailleBloc = 1024;
                        BYTE * p = ReadBloc( TabDir[ i ].Blocks[ j ] );
                        if ( FirstBlock )
                            {
                            if ( CheckAmsdos( p ) )
                                {
                                StAmsdos * Ams = ( StAmsdos * )p;
                                if ( Ams->Length )
                                    lMax = Ams->Length + sizeof( StAmsdos );
                                else
                                    if ( Ams->LogicalLength )
                                        lMax = Ams->LogicalLength + sizeof( StAmsdos );
                                    else
                                        if ( Ams->RealLength )
                                            lMax = Ams->RealLength + sizeof( StAmsdos );

                                //
                                // Supprime en-tte si mode ASCII
                                //
                                if ( TypeModeExport == MODE_ASCII )
                                    {
                                    TailleBloc -= sizeof( StAmsdos );
                                    memcpy( p
                                          , &p[ sizeof( StAmsdos ) ]
                                          , TailleBloc
                                          );
                                    }
                                }
                            else
                                {
                                if ( TypeModeExport == MODE_BINAIRE )
                                    {
                                    //
                                    // Ajoute en-tte amsdos
                                    //
                                    StAmsdos * e = CreeEnteteAmsdos( NomFic
                                                                   , Ko << 10
                                                                   );
                                    WriteFile( f, e, sizeof( StAmsdos ), &Lg, NULL );
                                    }
                                }
                            if ( m_Nettoie.GetCheck() && TailleBloc == 1024 )
                                ClearAmsdos( p );

                            FirstBlock = FALSE;
                            }
                        int NbOctets = min( lMax, TailleBloc );
                        if ( NbOctets > 0 )
                            WriteFile( f, p, NbOctets, &Lg, NULL );

                        lMax -= 1024;
                        }
                    p = GetNomAmsdos( TabDir[ ++i ].Nom );
                    }
                while( ! strncmp( NomFic
                                , p
                                , max( strlen( p ), strlen( NomFic ) )
                                )
                     );
                CloseHandle( f );
                }
            }
        }
}


//
// Renomer des fichiers
//
void CManageDskDlg::OnRenome()
{
    char NomFic[ 32 ];
    BOOL Modif = FALSE;

    POSITION pos = m_Liste.GetFirstSelectedItemPosition();
    while( pos )
        {
        //
        // Parcourir tous les fichiers slectionns
        //
        int nItem = m_Liste.GetNextSelectedItem( pos );
        // Recherche le direntry correspondant
        int i = PosItem[ nItem ];
        CInfoFichier Info( TabDir, i, Langue, TRUE );
        Info.DoModal();
        //
        // Si appui sur bp "valider"
        //
        if ( Info.IsValide() )
            {
            StDirEntry DirLoc;
            memset( DirLoc.Nom, ' ', 8 );
            memset( DirLoc.Ext, ' ', 3 );
            int User = atoi( Info.GetUser() );
            strcpy( NomFic, Info.GetNom() );
            char * p = strchr( NomFic, '.' );
            if ( p )
                {
                p++;
                memcpy( DirLoc.Nom, NomFic, p - NomFic - 1 );
                memcpy( DirLoc.Ext, p, min( strlen( p ), 3 ) );
                }
            else
                memcpy( DirLoc.Nom, NomFic, min( strlen( NomFic ), 8 ) );

            strcpy( NomFic, GetNomAmsdos( TabDir[ i ].Nom ) );
            do
                {
                TabDir[ i ].User = User;
                memcpy( TabDir[ i ].Nom, DirLoc.Nom, 11 );
                SetInfoDirEntry( i, &TabDir[ i ] );
                p = GetNomAmsdos( TabDir[ ++i ].Nom );
                }
            while( ! strncmp( NomFic
                            , p
                            , max( strlen( p ), strlen( NomFic ) )
                            )
                 );
            Modif = TRUE;
            }
        }
    //
    // Si au moins 1 fichier renom, rafficher le contenu du DSK
    //
    if ( Modif )
        ReadDirDsk();
}


void CManageDskDlg::OnSupprime()
{
    BOOL Modif = FALSE;
    POSITION pos = m_Liste.GetFirstSelectedItemPosition();
    while( pos )
        {
        int nItem = m_Liste.GetNextSelectedItem( pos );
        // Recherche le direntry correspondant
        int Indice = PosItem[ nItem ];
        if ( MessageBox( "Voulez-vous vraiment supprimer ce fichier ?"
                       , GetNomAmsdos( TabDir[ Indice ].Nom )
                       , MB_YESNO | MB_ICONQUESTION
                       ) == IDYES
           )
            {
            char NomFic[ 16 ];
            int i = Indice;
            strcpy( NomFic, GetNomAmsdos( TabDir[ i ].Nom ) );
            char * p;
            do
                {
                TabDir[ i ].User = USER_DELETED;
                SetInfoDirEntry( i, &TabDir[ i ] );
                p = GetNomAmsdos( TabDir[ ++i ].Nom );
                }
            while( ! strncmp( NomFic
                            , p
                            , max( strlen( p ), strlen( NomFic ) )
                            )
                 );
            Modif = TRUE;
            }
        }
    //
    // Si au moins 1 fichier supprim, rafficher le contenu du DSK
    //
    if ( Modif )
        ReadDirDsk();
}


//
// Paramtrer l'interface en "ANGLAIS"
//
void CManageDskDlg::OnBpEn()
{
    Langue = LOC_ENGLISH;
    SetInterface( Langue );
}


//
// Paramtrer l'interface en "FRANCAIS"
//
void CManageDskDlg::OnBpFr()
{
    Langue = LOC_FRANCAIS;
    SetInterface( Langue );
}


//
// Initialisation de l'interface (textes en fonction de la langue)
//
void CManageDskDlg::SetInterface( int Langue )
{
    int nColumnCount = m_Liste.GetHeaderCtrl()->GetItemCount();
    for ( int i = 0;i < nColumnCount; i++ )
       m_Liste.DeleteColumn( 0 );

    m_Liste.InsertColumn( COL_NOM
                        , GetTexteLoc( 10, Langue )
                        , LVCFMT_LEFT
                        , 130
                        );
    m_Liste.InsertColumn( COL_USER
                        , GetTexteLoc( 11, Langue )
                        , LVCFMT_LEFT
                        , 50
                        );
    m_Liste.InsertColumn( COL_READONLY
                        , GetTexteLoc( 49, Langue )
                        , LVCFMT_LEFT
                        , 80
                        );
    m_Liste.InsertColumn( COL_HIDDEN
                        , GetTexteLoc( 50, Langue )
                        , LVCFMT_LEFT
                        , 50
                        );
    m_Liste.InsertColumn( COL_TYPE
                        , GetTexteLoc( 12, Langue )
                        , LVCFMT_LEFT
                        , 70
                        );
    m_Liste.InsertColumn( COL_TAILLE
                        , GetTexteLoc( 13, Langue )
                        , LVCFMT_LEFT
                        , 70
                        );
    m_ContenuDsk.SetWindowText( GetTexteLoc( 0, Langue ) );
    m_BpAjoute.SetWindowText( GetTexteLoc( 1, Langue ) );
    m_BpExport.SetWindowText( GetTexteLoc( 2, Langue ) );
    m_BpRenome.SetWindowText( GetTexteLoc( 3, Langue ) );
    m_BpSupprime.SetWindowText( GetTexteLoc( 4, Langue ) );
    m_BpCreer.SetWindowText( GetTexteLoc( 5, Langue ) );
    m_BpLire.SetWindowText( GetTexteLoc( 6, Langue ) );
    m_BpSauve.SetWindowText( GetTexteLoc( 7, Langue ) );
    m_BpSauveDirect.SetWindowText( GetTexteLoc( 46, Langue ) );
    m_Secteurs.SetWindowText( GetTexteLoc( 51, Langue ) );
    m_BpEditFic.SetWindowText( GetTexteLoc( 58, Langue ) );
    m_KoUtilTxt.SetWindowText( GetTexteLoc( 8, Langue ) );

    m_ModeAjout.SetWindowText( GetTexteLoc( 42, Langue ) );
    m_RadioForceBin.SetWindowText( GetTexteLoc( 43, Langue ) );
    m_RadioForceAscii.SetWindowText( GetTexteLoc( 44, Langue ) );
    m_RadioChoix.SetWindowText( GetTexteLoc( 45, Langue ) );
    m_ModeExport.SetWindowText( GetTexteLoc( 55, Langue ) );
    m_RadioExpBin.SetWindowText( GetTexteLoc( 56, Langue ) );
    m_RadioExpAscii.SetWindowText( GetTexteLoc( 57, Langue ) );
    m_Nettoie.SetWindowText( GetTexteLoc( 9, Langue ) );
    ReadDirDsk();
}


//
// Appui sur le bouton "forcer mode export binaire"
//
void CManageDskDlg::OnRadioForceBin()
{
    TypeModeImport = MODE_BINAIRE;
}


//
// Appui sur le bouton "forcer mode export utilisateur"
//
void CManageDskDlg::OnRadioChoix()
{
    TypeModeImport = MODE_USER;
}


//
// Appui sur le bouton "forcer mode import ascii"
//
void CManageDskDlg::OnRadioForceAscii()
{
    TypeModeImport = MODE_ASCII;
}


//
// Appui sur le bouton "forcer mode export binaire"
//
void CManageDskDlg::OnRadioExpBin()
{
    TypeModeExport = MODE_BINAIRE;
}


//
// Appui sur le bouton "forcer mode export ascii"
//
void CManageDskDlg::OnRadioExpAscii()
{
    TypeModeExport = MODE_ASCII;
}


//
// Ouverture de l'diteur de secteurs
//
void CManageDskDlg::OnEditSecteurs()
{
    CEditSecteurs s( Langue );
    s.DoModal();
}


//
// Voir un fichier
//
void CManageDskDlg::OnEditFic()
{
    static BYTE BufFile[ 0x10000 ];
    int LongFic = 0;

    memset( BufFile, 0, sizeof( BufFile ) );
    POSITION pos = m_Liste.GetFirstSelectedItemPosition();
    while( pos )
        {
        int nItem = m_Liste.GetNextSelectedItem( pos );
        m_Liste.GetItemText( nItem, COL_TAILLE, Msg, sizeof( Msg ) );
        int Ko = atoi( Msg );
        // Recherche le direntry correspondant
        int Indice = PosItem[ nItem ];
        char NomFic[ 16 ];
        int i = Indice;
        BOOL FirstBlock = TRUE;
        strcpy( NomFic, GetNomAmsdos( TabDir[ i ].Nom ) );
        char * p;
        int lMax = sizeof( BufFile );
        do
            {
            // Longueur du fichier
            int l = ( TabDir[ i ].NbPages + 7 ) >> 3;
            for ( int j = 0; j < l; j++ )
                {
                int TailleBloc = 1024;
                BYTE * p = ReadBloc( TabDir[ i ].Blocks[ j ] );
                if ( FirstBlock )
                    {
                    if ( CheckAmsdos( p ) )
                        {
                        StAmsdos * Ams = ( StAmsdos * )p;
                        if ( Ams->Length )
                            lMax = Ams->Length + sizeof( StAmsdos );
                        else
                            if ( Ams->LogicalLength )
                                lMax = Ams->LogicalLength + sizeof( StAmsdos );
                            else
                                if ( Ams->RealLength )
                                    lMax = Ams->RealLength + sizeof( StAmsdos );
                        }
                    FirstBlock = FALSE;
                    }
                int NbOctets = min( lMax, TailleBloc );
                if ( NbOctets > 0 )
                    {
                    memcpy( &BufFile[ LongFic ], p, NbOctets );
                    LongFic += NbOctets;
                    }
                lMax -= 1024;
                }
            p = GetNomAmsdos( TabDir[ ++i ].Nom );
            }
        while( ! strncmp( NomFic
                        , p
                        , max( strlen( p ), strlen( NomFic ) )
                        )
             );
        CViewFile s( BufFile, LongFic, TypeModeExport, Langue );
        s.DoModal();
        }
}
